// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetImageRecipeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe that you wish to retrieve.
	//
	// ImageRecipeArn is a required field
	ImageRecipeArn *string `location:"querystring" locationName:"imageRecipeArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImageRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageRecipeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetImageRecipeInput"}

	if s.ImageRecipeArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetImageRecipeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ImageRecipeArn != nil {
		v := *s.ImageRecipeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "imageRecipeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetImageRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The image recipe object.
	ImageRecipe *ImageRecipe `locationName:"imageRecipe" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s GetImageRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetImageRecipeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImageRecipe != nil {
		v := s.ImageRecipe

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "imageRecipe", v, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetImageRecipe = "GetImageRecipe"

// GetImageRecipeRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Gets an image recipe.
//
//    // Example sending a request using GetImageRecipeRequest.
//    req := client.GetImageRecipeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe
func (c *Client) GetImageRecipeRequest(input *GetImageRecipeInput) GetImageRecipeRequest {
	op := &aws.Operation{
		Name:       opGetImageRecipe,
		HTTPMethod: "GET",
		HTTPPath:   "/GetImageRecipe",
	}

	if input == nil {
		input = &GetImageRecipeInput{}
	}

	req := c.newRequest(op, input, &GetImageRecipeOutput{})
	return GetImageRecipeRequest{Request: req, Input: input, Copy: c.GetImageRecipeRequest}
}

// GetImageRecipeRequest is the request type for the
// GetImageRecipe API operation.
type GetImageRecipeRequest struct {
	*aws.Request
	Input *GetImageRecipeInput
	Copy  func(*GetImageRecipeInput) GetImageRecipeRequest
}

// Send marshals and sends the GetImageRecipe API request.
func (r GetImageRecipeRequest) Send(ctx context.Context) (*GetImageRecipeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetImageRecipeResponse{
		GetImageRecipeOutput: r.Request.Data.(*GetImageRecipeOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetImageRecipeResponse is the response type for the
// GetImageRecipe API operation.
type GetImageRecipeResponse struct {
	*GetImageRecipeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetImageRecipe request.
func (r *GetImageRecipeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
