// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type SetSecurityTokenServicePreferencesInput struct {
	_ struct{} `type:"structure"`

	// The version of the global endpoint token. Version 1 tokens are valid only
	// in AWS Regions that are available by default. These tokens do not work in
	// manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens
	// are valid in all Regions. However, version 2 tokens are longer and might
	// affect systems where you temporarily store tokens.
	//
	// For information, see Activating and Deactivating STS in an AWS Region (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
	// in the IAM User Guide.
	//
	// GlobalEndpointTokenVersion is a required field
	GlobalEndpointTokenVersion GlobalEndpointTokenVersion `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SetSecurityTokenServicePreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSecurityTokenServicePreferencesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetSecurityTokenServicePreferencesInput"}
	if len(s.GlobalEndpointTokenVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("GlobalEndpointTokenVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetSecurityTokenServicePreferencesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetSecurityTokenServicePreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetSecurityTokenServicePreferences = "SetSecurityTokenServicePreferences"

// SetSecurityTokenServicePreferencesRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Sets the specified version of the global endpoint token as the token version
// used for the AWS account.
//
// By default, AWS Security Token Service (STS) is available as a global service,
// and all STS requests go to a single endpoint at https://sts.amazonaws.com.
// AWS recommends using Regional STS endpoints to reduce latency, build in redundancy,
// and increase session token availability. For information about Regional endpoints
// for STS, see AWS Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#sts_region)
// in the AWS General Reference.
//
// If you make an STS call to the global endpoint, the resulting session tokens
// might be valid in some Regions but not others. It depends on the version
// that is set in this operation. Version 1 tokens are valid only in AWS Regions
// that are available by default. These tokens do not work in manually enabled
// Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid in
// all Regions. However, version 2 tokens are longer and might affect systems
// where you temporarily store tokens. For information, see Activating and Deactivating
// STS in an AWS Region (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
// in the IAM User Guide.
//
// To view the current session token version, see the GlobalEndpointTokenVersion
// entry in the response of the GetAccountSummary operation.
//
//    // Example sending a request using SetSecurityTokenServicePreferencesRequest.
//    req := client.SetSecurityTokenServicePreferencesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetSecurityTokenServicePreferences
func (c *Client) SetSecurityTokenServicePreferencesRequest(input *SetSecurityTokenServicePreferencesInput) SetSecurityTokenServicePreferencesRequest {
	op := &aws.Operation{
		Name:       opSetSecurityTokenServicePreferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSecurityTokenServicePreferencesInput{}
	}

	req := c.newRequest(op, input, &SetSecurityTokenServicePreferencesOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetSecurityTokenServicePreferencesRequest{Request: req, Input: input, Copy: c.SetSecurityTokenServicePreferencesRequest}
}

// SetSecurityTokenServicePreferencesRequest is the request type for the
// SetSecurityTokenServicePreferences API operation.
type SetSecurityTokenServicePreferencesRequest struct {
	*aws.Request
	Input *SetSecurityTokenServicePreferencesInput
	Copy  func(*SetSecurityTokenServicePreferencesInput) SetSecurityTokenServicePreferencesRequest
}

// Send marshals and sends the SetSecurityTokenServicePreferences API request.
func (r SetSecurityTokenServicePreferencesRequest) Send(ctx context.Context) (*SetSecurityTokenServicePreferencesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetSecurityTokenServicePreferencesResponse{
		SetSecurityTokenServicePreferencesOutput: r.Request.Data.(*SetSecurityTokenServicePreferencesOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetSecurityTokenServicePreferencesResponse is the response type for the
// SetSecurityTokenServicePreferences API operation.
type SetSecurityTokenServicePreferencesResponse struct {
	*SetSecurityTokenServicePreferencesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetSecurityTokenServicePreferences request.
func (r *SetSecurityTokenServicePreferencesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
