// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListSigningCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, the number of items defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true, and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the IAM user whose signing certificates you want to examine.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSigningCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningCertificatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSigningCertificatesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful ListSigningCertificates request.
type ListSigningCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the user's signing certificate information.
	//
	// Certificates is a required field
	Certificates []SigningCertificate `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListSigningCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSigningCertificates = "ListSigningCertificates"

// ListSigningCertificatesRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Returns information about the signing certificates associated with the specified
// IAM user. If none exists, the operation returns an empty list.
//
// Although each user is limited to a small number of signing certificates,
// you can still paginate the results using the MaxItems and Marker parameters.
//
// If the UserName field is not specified, the user name is determined implicitly
// based on the AWS access key ID used to sign the request for this API. This
// operation works for access keys under the AWS account. Consequently, you
// can use this operation to manage AWS account root user credentials even if
// the AWS account has no associated users.
//
//    // Example sending a request using ListSigningCertificatesRequest.
//    req := client.ListSigningCertificatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates
func (c *Client) ListSigningCertificatesRequest(input *ListSigningCertificatesInput) ListSigningCertificatesRequest {
	op := &aws.Operation{
		Name:       opListSigningCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListSigningCertificatesInput{}
	}

	req := c.newRequest(op, input, &ListSigningCertificatesOutput{})
	return ListSigningCertificatesRequest{Request: req, Input: input, Copy: c.ListSigningCertificatesRequest}
}

// ListSigningCertificatesRequest is the request type for the
// ListSigningCertificates API operation.
type ListSigningCertificatesRequest struct {
	*aws.Request
	Input *ListSigningCertificatesInput
	Copy  func(*ListSigningCertificatesInput) ListSigningCertificatesRequest
}

// Send marshals and sends the ListSigningCertificates API request.
func (r ListSigningCertificatesRequest) Send(ctx context.Context) (*ListSigningCertificatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSigningCertificatesResponse{
		ListSigningCertificatesOutput: r.Request.Data.(*ListSigningCertificatesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSigningCertificatesRequestPaginator returns a paginator for ListSigningCertificates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSigningCertificatesRequest(input)
//   p := iam.NewListSigningCertificatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSigningCertificatesPaginator(req ListSigningCertificatesRequest) ListSigningCertificatesPaginator {
	return ListSigningCertificatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSigningCertificatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSigningCertificatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSigningCertificatesPaginator struct {
	aws.Pager
}

func (p *ListSigningCertificatesPaginator) CurrentPage() *ListSigningCertificatesOutput {
	return p.Pager.CurrentPage().(*ListSigningCertificatesOutput)
}

// ListSigningCertificatesResponse is the response type for the
// ListSigningCertificates API operation.
type ListSigningCertificatesResponse struct {
	*ListSigningCertificatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSigningCertificates request.
func (r *ListSigningCertificatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
