// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the managed policy that you want information
	// about.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPolicyInput"}

	if s.PolicyArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful GetPolicy request.
type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves information about the specified managed policy, including the policy's
// default version and the total number of IAM users, groups, and roles to which
// the policy is attached. To retrieve the list of the specific users, groups,
// and roles that the policy is attached to, use the ListEntitiesForPolicy API.
// This API returns metadata about the policy. To retrieve the actual policy
// document for a specific version of the policy, use GetPolicyVersion.
//
// This API retrieves information about managed policies. To retrieve information
// about an inline policy that is embedded with an IAM user, group, or role,
// use the GetUserPolicy, GetGroupPolicy, or GetRolePolicy API.
//
// For more information about policies, see Managed Policies and Inline Policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
//    // Example sending a request using GetPolicyRequest.
//    req := client.GetPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy
func (c *Client) GetPolicyRequest(input *GetPolicyInput) GetPolicyRequest {
	op := &aws.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	req := c.newRequest(op, input, &GetPolicyOutput{})
	return GetPolicyRequest{Request: req, Input: input, Copy: c.GetPolicyRequest}
}

// GetPolicyRequest is the request type for the
// GetPolicy API operation.
type GetPolicyRequest struct {
	*aws.Request
	Input *GetPolicyInput
	Copy  func(*GetPolicyInput) GetPolicyRequest
}

// Send marshals and sends the GetPolicy API request.
func (r GetPolicyRequest) Send(ctx context.Context) (*GetPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPolicyResponse{
		GetPolicyOutput: r.Request.Data.(*GetPolicyOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPolicyResponse is the response type for the
// GetPolicy API operation.
type GetPolicyResponse struct {
	*GetPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPolicy request.
func (r *GetPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
