// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the user whose login profile you want to retrieve.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoginProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLoginProfileInput"}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful GetLoginProfile request.
type GetLoginProfileOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the user name and password create date for the user.
	//
	// LoginProfile is a required field
	LoginProfile *LoginProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetLoginProfile = "GetLoginProfile"

// GetLoginProfileRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves the user name and password-creation date for the specified IAM
// user. If the user has not been assigned a password, the operation returns
// a 404 (NoSuchEntity) error.
//
//    // Example sending a request using GetLoginProfileRequest.
//    req := client.GetLoginProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile
func (c *Client) GetLoginProfileRequest(input *GetLoginProfileInput) GetLoginProfileRequest {
	op := &aws.Operation{
		Name:       opGetLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoginProfileInput{}
	}

	req := c.newRequest(op, input, &GetLoginProfileOutput{})
	return GetLoginProfileRequest{Request: req, Input: input, Copy: c.GetLoginProfileRequest}
}

// GetLoginProfileRequest is the request type for the
// GetLoginProfile API operation.
type GetLoginProfileRequest struct {
	*aws.Request
	Input *GetLoginProfileInput
	Copy  func(*GetLoginProfileInput) GetLoginProfileRequest
}

// Send marshals and sends the GetLoginProfile API request.
func (r GetLoginProfileRequest) Send(ctx context.Context) (*GetLoginProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLoginProfileResponse{
		GetLoginProfileOutput: r.Request.Data.(*GetLoginProfileOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetLoginProfileResponse is the response type for the
// GetLoginProfile API operation.
type GetLoginProfileResponse struct {
	*GetLoginProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLoginProfile request.
func (r *GetLoginProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
