// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GenerateCredentialReportInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GenerateCredentialReportInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a successful GenerateCredentialReport request.
type GenerateCredentialReportOutput struct {
	_ struct{} `type:"structure"`

	// Information about the credential report.
	Description *string `type:"string"`

	// Information about the state of the credential report.
	State ReportStateType `type:"string" enum:"true"`
}

// String returns the string representation
func (s GenerateCredentialReportOutput) String() string {
	return awsutil.Prettify(s)
}

const opGenerateCredentialReport = "GenerateCredentialReport"

// GenerateCredentialReportRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Generates a credential report for the AWS account. For more information about
// the credential report, see Getting Credential Reports (https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
// in the IAM User Guide.
//
//    // Example sending a request using GenerateCredentialReportRequest.
//    req := client.GenerateCredentialReportRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport
func (c *Client) GenerateCredentialReportRequest(input *GenerateCredentialReportInput) GenerateCredentialReportRequest {
	op := &aws.Operation{
		Name:       opGenerateCredentialReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateCredentialReportInput{}
	}

	req := c.newRequest(op, input, &GenerateCredentialReportOutput{})
	return GenerateCredentialReportRequest{Request: req, Input: input, Copy: c.GenerateCredentialReportRequest}
}

// GenerateCredentialReportRequest is the request type for the
// GenerateCredentialReport API operation.
type GenerateCredentialReportRequest struct {
	*aws.Request
	Input *GenerateCredentialReportInput
	Copy  func(*GenerateCredentialReportInput) GenerateCredentialReportRequest
}

// Send marshals and sends the GenerateCredentialReport API request.
func (r GenerateCredentialReportRequest) Send(ctx context.Context) (*GenerateCredentialReportResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GenerateCredentialReportResponse{
		GenerateCredentialReportOutput: r.Request.Data.(*GenerateCredentialReportOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GenerateCredentialReportResponse is the response type for the
// GenerateCredentialReport API operation.
type GenerateCredentialReportResponse struct {
	*GenerateCredentialReportOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GenerateCredentialReport request.
func (r *GenerateCredentialReportResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
