// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateMLTransformInput struct {
	_ struct{} `type:"structure"`

	// A description of the machine learning transform that is being defined. The
	// default is an empty string.
	Description *string `type:"string"`

	// This value determines which version of AWS Glue this machine learning transform
	// is compatible with. Glue 1.0 is recommended for most customers. If the value
	// is not set, the Glue compatibility defaults to Glue 0.9. For more information,
	// see AWS Glue Versions (https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
	// in the developer guide.
	GlueVersion *string `min:"1" type:"string"`

	// A list of AWS Glue table definitions used by the transform.
	//
	// InputRecordTables is a required field
	InputRecordTables []GlueTable `type:"list" required:"true"`

	// The number of AWS Glue data processing units (DPUs) that are allocated to
	// task runs for this transform. You can allocate from 2 to 100 DPUs; the default
	// is 10. A DPU is a relative measure of processing power that consists of 4
	// vCPUs of compute capacity and 16 GB of memory. For more information, see
	// the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.
	//
	//    * If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot
	//    be set.
	//
	//    * If MaxCapacity is set then neither NumberOfWorkers or WorkerType can
	//    be set.
	//
	//    * If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	//
	//    * MaxCapacity and NumberOfWorkers must both be at least 1.
	//
	// When the WorkerType field is set to a value other than Standard, the MaxCapacity
	// field is set automatically and becomes read-only.
	//
	// When the WorkerType field is set to a value other than Standard, the MaxCapacity
	// field is set automatically and becomes read-only.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry a task for this transform after a task
	// run fails.
	MaxRetries *int64 `type:"integer"`

	// The unique name that you give the transform when you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The number of workers of a defined workerType that are allocated when this
	// task runs.
	//
	// If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	NumberOfWorkers *int64 `type:"integer"`

	// The algorithmic parameters that are specific to the transform type used.
	// Conditionally dependent on the transform type.
	//
	// Parameters is a required field
	Parameters *TransformParameters `type:"structure" required:"true"`

	// The name or Amazon Resource Name (ARN) of the IAM role with the required
	// permissions. The required permissions include both AWS Glue service role
	// permissions to AWS Glue resources, and Amazon S3 permissions required by
	// the transform.
	//
	//    * This role needs AWS Glue service role permissions to allow access to
	//    resources in AWS Glue. See Attach a Policy to IAM Users That Access AWS
	//    Glue (https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html).
	//
	//    * This role needs permission to your Amazon Simple Storage Service (Amazon
	//    S3) sources, targets, temporary directory, scripts, and any libraries
	//    used by the task run for this transform.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The timeout of the task run for this transform in minutes. This is the maximum
	// time that a task run for this transform can consume resources before it is
	// terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The type of predefined worker that is allocated when this task runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	//
	// MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.
	//
	//    * If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot
	//    be set.
	//
	//    * If MaxCapacity is set then neither NumberOfWorkers or WorkerType can
	//    be set.
	//
	//    * If WorkerType is set, then NumberOfWorkers is required (and vice versa).
	//
	//    * MaxCapacity and NumberOfWorkers must both be at least 1.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateMLTransformInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMLTransformInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateMLTransformInput"}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GlueVersion", 1))
	}

	if s.InputRecordTables == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputRecordTables"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Parameters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Parameters"))
	}

	if s.Role == nil {
		invalidParams.Add(aws.NewErrParamRequired("Role"))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}
	if s.InputRecordTables != nil {
		for i, v := range s.InputRecordTables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputRecordTables", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateMLTransformOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that is generated for the transform.
	TransformId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateMLTransformOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateMLTransform = "CreateMLTransform"

// CreateMLTransformRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates an AWS Glue machine learning transform. This operation creates the
// transform and all the necessary parameters to train it.
//
// Call this operation as the first step in the process of using a machine learning
// transform (such as the FindMatches transform) for deduplicating data. You
// can provide an optional Description, in addition to the parameters that you
// want to use for your algorithm.
//
// You must also specify certain parameters for the tasks that AWS Glue runs
// on your behalf as part of learning from your data and creating a high-quality
// machine learning transform. These parameters include Role, and optionally,
// AllocatedCapacity, Timeout, and MaxRetries. For more information, see Jobs
// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html).
//
//    // Example sending a request using CreateMLTransformRequest.
//    req := client.CreateMLTransformRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform
func (c *Client) CreateMLTransformRequest(input *CreateMLTransformInput) CreateMLTransformRequest {
	op := &aws.Operation{
		Name:       opCreateMLTransform,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMLTransformInput{}
	}

	req := c.newRequest(op, input, &CreateMLTransformOutput{})
	return CreateMLTransformRequest{Request: req, Input: input, Copy: c.CreateMLTransformRequest}
}

// CreateMLTransformRequest is the request type for the
// CreateMLTransform API operation.
type CreateMLTransformRequest struct {
	*aws.Request
	Input *CreateMLTransformInput
	Copy  func(*CreateMLTransformInput) CreateMLTransformRequest
}

// Send marshals and sends the CreateMLTransform API request.
func (r CreateMLTransformRequest) Send(ctx context.Context) (*CreateMLTransformResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateMLTransformResponse{
		CreateMLTransformOutput: r.Request.Data.(*CreateMLTransformOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateMLTransformResponse is the response type for the
// CreateMLTransform API operation.
type CreateMLTransformResponse struct {
	*CreateMLTransformOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateMLTransform request.
func (r *CreateMLTransformResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
