// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input for a request action.
type DeleteBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to delete.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBuildInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBuildInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBuildInput"}

	if s.BuildId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteBuildOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBuildOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteBuild = "DeleteBuild"

// DeleteBuildRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Deletes a build. This action permanently deletes the build record and any
// uploaded build files.
//
// To delete a build, specify its ID. Deleting a build does not affect the status
// of any active fleets using the build, but you can no longer create new fleets
// with the deleted build.
//
// Learn more
//
//  Working with Builds (https://docs.aws.amazon.com/gamelift/latest/developerguide/build-intro.html)
//
// Related operations
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
//    // Example sending a request using DeleteBuildRequest.
//    req := client.DeleteBuildRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild
func (c *Client) DeleteBuildRequest(input *DeleteBuildInput) DeleteBuildRequest {
	op := &aws.Operation{
		Name:       opDeleteBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBuildInput{}
	}

	req := c.newRequest(op, input, &DeleteBuildOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteBuildRequest{Request: req, Input: input, Copy: c.DeleteBuildRequest}
}

// DeleteBuildRequest is the request type for the
// DeleteBuild API operation.
type DeleteBuildRequest struct {
	*aws.Request
	Input *DeleteBuildInput
	Copy  func(*DeleteBuildInput) DeleteBuildRequest
}

// Send marshals and sends the DeleteBuild API request.
func (r DeleteBuildRequest) Send(ctx context.Context) (*DeleteBuildResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBuildResponse{
		DeleteBuildOutput: r.Request.Data.(*DeleteBuildOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBuildResponse is the response type for the
// DeleteBuild API operation.
type DeleteBuildResponse struct {
	*DeleteBuildOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBuild request.
func (r *DeleteBuildResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
