// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribePredictorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the predictor that you want information
	// about.
	//
	// PredictorArn is a required field
	PredictorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePredictorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePredictorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePredictorInput"}

	if s.PredictorArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PredictorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribePredictorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm used for model training.
	AlgorithmArn *string `type:"string"`

	// When PerformAutoML is specified, the ARN of the chosen algorithm.
	AutoMLAlgorithmArns []string `type:"list"`

	// When the model training task was created.
	CreationTime *time.Time `type:"timestamp"`

	// An array of the ARNs of the dataset import jobs used to import training data
	// for the predictor.
	DatasetImportJobArns []string `type:"list"`

	// An AWS Key Management Service (KMS) key and the AWS Identity and Access Management
	// (IAM) role that Amazon Forecast can assume to access the key.
	EncryptionConfig *EncryptionConfig `type:"structure"`

	// Used to override the default evaluation parameters of the specified algorithm.
	// Amazon Forecast evaluates a predictor by splitting a dataset into training
	// data and testing data. The evaluation parameters define how to perform the
	// split and the number of iterations.
	EvaluationParameters *EvaluationParameters `type:"structure"`

	// The featurization configuration.
	FeaturizationConfig *FeaturizationConfig `type:"structure"`

	// The number of time-steps of the forecast. The forecast horizon is also called
	// the prediction length.
	ForecastHorizon *int64 `type:"integer"`

	// The hyperparameter override values for the algorithm.
	HPOConfig *HyperParameterTuningJobConfig `type:"structure"`

	// Describes the dataset group that contains the data to use to train the predictor.
	InputDataConfig *InputDataConfig `type:"structure"`

	// Initially, the same as CreationTime (when the status is CREATE_PENDING).
	// This value is updated when training starts (when the status changes to CREATE_IN_PROGRESS),
	// and when training has completed (when the status changes to ACTIVE) or fails
	// (when the status changes to CREATE_FAILED).
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// Whether the predictor is set to perform AutoML.
	PerformAutoML *bool `type:"boolean"`

	// Whether the predictor is set to perform hyperparameter optimization (HPO).
	PerformHPO *bool `type:"boolean"`

	// The ARN of the predictor.
	PredictorArn *string `min:"1" type:"string"`

	// Details on the the status and results of the backtests performed to evaluate
	// the accuracy of the predictor. You specify the number of backtests to perform
	// when you call the operation.
	PredictorExecutionDetails *PredictorExecutionDetails `type:"structure"`

	// The name of the predictor.
	PredictorName *string `min:"1" type:"string"`

	// The status of the predictor. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	//    * UPDATE_PENDING, UPDATE_IN_PROGRESS, UPDATE_FAILED
	//
	// The Status of the predictor must be ACTIVE before you can use the predictor
	// to create a forecast.
	Status *string `type:"string"`

	// The default training parameters or overrides selected during model training.
	// If using the AutoML algorithm or if HPO is turned on while using the DeepAR+
	// algorithms, the optimized values for the chosen hyperparameters are returned.
	// For more information, see aws-forecast-choosing-recipes.
	TrainingParameters map[string]string `type:"map"`
}

// String returns the string representation
func (s DescribePredictorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePredictor = "DescribePredictor"

// DescribePredictorRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Describes a predictor created using the CreatePredictor operation.
//
// In addition to listing the properties provided in the CreatePredictor request,
// this operation lists the following properties:
//
//    * DatasetImportJobArns - The dataset import jobs used to import training
//    data.
//
//    * AutoMLAlgorithmArns - If AutoML is performed, the algorithms that were
//    evaluated.
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
//    * Message - If an error occurred, information about the error.
//
//    // Example sending a request using DescribePredictorRequest.
//    req := client.DescribePredictorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribePredictor
func (c *Client) DescribePredictorRequest(input *DescribePredictorInput) DescribePredictorRequest {
	op := &aws.Operation{
		Name:       opDescribePredictor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePredictorInput{}
	}

	req := c.newRequest(op, input, &DescribePredictorOutput{})
	return DescribePredictorRequest{Request: req, Input: input, Copy: c.DescribePredictorRequest}
}

// DescribePredictorRequest is the request type for the
// DescribePredictor API operation.
type DescribePredictorRequest struct {
	*aws.Request
	Input *DescribePredictorInput
	Copy  func(*DescribePredictorInput) DescribePredictorRequest
}

// Send marshals and sends the DescribePredictor API request.
func (r DescribePredictorRequest) Send(ctx context.Context) (*DescribePredictorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePredictorResponse{
		DescribePredictorOutput: r.Request.Data.(*DescribePredictorOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePredictorResponse is the response type for the
// DescribePredictor API operation.
type DescribePredictorResponse struct {
	*DescribePredictorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePredictor request.
func (r *DescribePredictorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
