// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// The input to the SetVisibleToAllUsers action.
type SetVisibleToAllUsersInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the job flow (cluster).
	//
	// JobFlowIds is a required field
	JobFlowIds []string `type:"list" required:"true"`

	// A value of true indicates that all IAM users in the AWS account can perform
	// cluster actions if they have the proper IAM policy permissions. This is the
	// default. A value of false indicates that only the IAM user who created the
	// cluster can perform actions.
	//
	// VisibleToAllUsers is a required field
	VisibleToAllUsers *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SetVisibleToAllUsersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVisibleToAllUsersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetVisibleToAllUsersInput"}

	if s.JobFlowIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobFlowIds"))
	}

	if s.VisibleToAllUsers == nil {
		invalidParams.Add(aws.NewErrParamRequired("VisibleToAllUsers"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetVisibleToAllUsersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetVisibleToAllUsersOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetVisibleToAllUsers = "SetVisibleToAllUsers"

// SetVisibleToAllUsersRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Sets the Cluster$VisibleToAllUsers value, which determines whether the cluster
// is visible to all IAM users of the AWS account associated with the cluster.
// Only the IAM user who created the cluster or the AWS account root user can
// call this action. The default value, true, indicates that all IAM users in
// the AWS account can perform cluster actions if they have the proper IAM policy
// permissions. If set to false, only the IAM user that created the cluster
// can perform actions. This action works on running clusters. You can override
// the default true setting when you create a cluster by using the VisibleToAllUsers
// parameter with RunJobFlow.
//
//    // Example sending a request using SetVisibleToAllUsersRequest.
//    req := client.SetVisibleToAllUsersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetVisibleToAllUsers
func (c *Client) SetVisibleToAllUsersRequest(input *SetVisibleToAllUsersInput) SetVisibleToAllUsersRequest {
	op := &aws.Operation{
		Name:       opSetVisibleToAllUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetVisibleToAllUsersInput{}
	}

	req := c.newRequest(op, input, &SetVisibleToAllUsersOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetVisibleToAllUsersRequest{Request: req, Input: input, Copy: c.SetVisibleToAllUsersRequest}
}

// SetVisibleToAllUsersRequest is the request type for the
// SetVisibleToAllUsers API operation.
type SetVisibleToAllUsersRequest struct {
	*aws.Request
	Input *SetVisibleToAllUsersInput
	Copy  func(*SetVisibleToAllUsersInput) SetVisibleToAllUsersRequest
}

// Send marshals and sends the SetVisibleToAllUsers API request.
func (r SetVisibleToAllUsersRequest) Send(ctx context.Context) (*SetVisibleToAllUsersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetVisibleToAllUsersResponse{
		SetVisibleToAllUsersOutput: r.Request.Data.(*SetVisibleToAllUsersOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetVisibleToAllUsersResponse is the response type for the
// SetVisibleToAllUsers API operation.
type SetVisibleToAllUsersResponse struct {
	*SetVisibleToAllUsersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetVisibleToAllUsers request.
func (r *SetVisibleToAllUsersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
