// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesInput struct {
	_ struct{} `type:"structure"`

	// DomainName represents the name of the Domain that we are trying to modify.
	// This should be present only if we are querying for list of available Elasticsearch
	// instance types when modifying existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of Elasticsearch for which list of supported elasticsearch instance
	// types are needed.
	//
	// ElasticsearchVersion is a required field
	ElasticsearchVersion *string `location:"uri" locationName:"ElasticsearchVersion" type:"string" required:"true"`

	// Set this value to limit the number of results returned. Value provided must
	// be greater than 30 else it wont be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListElasticsearchInstanceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListElasticsearchInstanceTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListElasticsearchInstanceTypesInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if s.ElasticsearchVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ElasticsearchVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListElasticsearchInstanceTypesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ElasticsearchVersion != nil {
		v := *s.ElasticsearchVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ElasticsearchVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Container for the parameters returned by ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesOutput struct {
	_ struct{} `type:"structure"`

	// List of instance types supported by Amazon Elasticsearch service for given
	// ElasticsearchVersion
	ElasticsearchInstanceTypes []ESPartitionInstanceType `type:"list"`

	// In case if there are more results available NextToken would be present, make
	// further request to the same API with received NextToken to paginate remaining
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListElasticsearchInstanceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListElasticsearchInstanceTypesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ElasticsearchInstanceTypes != nil {
		v := s.ElasticsearchInstanceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ElasticsearchInstanceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListElasticsearchInstanceTypes = "ListElasticsearchInstanceTypes"

// ListElasticsearchInstanceTypesRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// List all Elasticsearch instance types that are supported for given ElasticsearchVersion
//
//    // Example sending a request using ListElasticsearchInstanceTypesRequest.
//    req := client.ListElasticsearchInstanceTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListElasticsearchInstanceTypesRequest(input *ListElasticsearchInstanceTypesInput) ListElasticsearchInstanceTypesRequest {
	op := &aws.Operation{
		Name:       opListElasticsearchInstanceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/instanceTypes/{ElasticsearchVersion}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListElasticsearchInstanceTypesInput{}
	}

	req := c.newRequest(op, input, &ListElasticsearchInstanceTypesOutput{})
	return ListElasticsearchInstanceTypesRequest{Request: req, Input: input, Copy: c.ListElasticsearchInstanceTypesRequest}
}

// ListElasticsearchInstanceTypesRequest is the request type for the
// ListElasticsearchInstanceTypes API operation.
type ListElasticsearchInstanceTypesRequest struct {
	*aws.Request
	Input *ListElasticsearchInstanceTypesInput
	Copy  func(*ListElasticsearchInstanceTypesInput) ListElasticsearchInstanceTypesRequest
}

// Send marshals and sends the ListElasticsearchInstanceTypes API request.
func (r ListElasticsearchInstanceTypesRequest) Send(ctx context.Context) (*ListElasticsearchInstanceTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListElasticsearchInstanceTypesResponse{
		ListElasticsearchInstanceTypesOutput: r.Request.Data.(*ListElasticsearchInstanceTypesOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListElasticsearchInstanceTypesRequestPaginator returns a paginator for ListElasticsearchInstanceTypes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListElasticsearchInstanceTypesRequest(input)
//   p := elasticsearchservice.NewListElasticsearchInstanceTypesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListElasticsearchInstanceTypesPaginator(req ListElasticsearchInstanceTypesRequest) ListElasticsearchInstanceTypesPaginator {
	return ListElasticsearchInstanceTypesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListElasticsearchInstanceTypesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListElasticsearchInstanceTypesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListElasticsearchInstanceTypesPaginator struct {
	aws.Pager
}

func (p *ListElasticsearchInstanceTypesPaginator) CurrentPage() *ListElasticsearchInstanceTypesOutput {
	return p.Pager.CurrentPage().(*ListElasticsearchInstanceTypesOutput)
}

// ListElasticsearchInstanceTypesResponse is the response type for the
// ListElasticsearchInstanceTypes API operation.
type ListElasticsearchInstanceTypesResponse struct {
	*ListElasticsearchInstanceTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListElasticsearchInstanceTypes request.
func (r *ListElasticsearchInstanceTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
