// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the DescribeElasticsearchDomains operation.
// By default, the API returns the status of all Elasticsearch domains.
type DescribeElasticsearchDomainsInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domains for which you want information.
	//
	// DomainNames is a required field
	DomainNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeElasticsearchDomainsInput"}

	if s.DomainNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeElasticsearchDomainsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DomainNames != nil {
		v := s.DomainNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DomainNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The result of a DescribeElasticsearchDomains request. Contains the status
// of the specified domains or all domains owned by the account.
type DescribeElasticsearchDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domains requested in the DescribeElasticsearchDomains request.
	//
	// DomainStatusList is a required field
	DomainStatusList []ElasticsearchDomainStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeElasticsearchDomainsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainStatusList != nil {
		v := s.DomainStatusList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DomainStatusList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeElasticsearchDomains = "DescribeElasticsearchDomains"

// DescribeElasticsearchDomainsRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domains, including the domain ID, domain endpoint, and domain ARN.
//
//    // Example sending a request using DescribeElasticsearchDomainsRequest.
//    req := client.DescribeElasticsearchDomainsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeElasticsearchDomainsRequest(input *DescribeElasticsearchDomainsInput) DescribeElasticsearchDomainsRequest {
	op := &aws.Operation{
		Name:       opDescribeElasticsearchDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain-info",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainsInput{}
	}

	req := c.newRequest(op, input, &DescribeElasticsearchDomainsOutput{})
	return DescribeElasticsearchDomainsRequest{Request: req, Input: input, Copy: c.DescribeElasticsearchDomainsRequest}
}

// DescribeElasticsearchDomainsRequest is the request type for the
// DescribeElasticsearchDomains API operation.
type DescribeElasticsearchDomainsRequest struct {
	*aws.Request
	Input *DescribeElasticsearchDomainsInput
	Copy  func(*DescribeElasticsearchDomainsInput) DescribeElasticsearchDomainsRequest
}

// Send marshals and sends the DescribeElasticsearchDomains API request.
func (r DescribeElasticsearchDomainsRequest) Send(ctx context.Context) (*DescribeElasticsearchDomainsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeElasticsearchDomainsResponse{
		DescribeElasticsearchDomainsOutput: r.Request.Data.(*DescribeElasticsearchDomainsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeElasticsearchDomainsResponse is the response type for the
// DescribeElasticsearchDomains API operation.
type DescribeElasticsearchDomainsResponse struct {
	*DescribeElasticsearchDomainsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeElasticsearchDomains request.
func (r *DescribeElasticsearchDomainsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
