// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeListenerCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The maximum number of results to return with this call.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DescribeListenerCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeListenerCertificatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeListenerCertificatesInput"}

	if s.ListenerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListenerArn"))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeListenerCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the certificates.
	Certificates []Certificate `type:"list"`

	// If there are additional results, this is the marker for the next set of results.
	// Otherwise, this is null.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s DescribeListenerCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeListenerCertificates = "DescribeListenerCertificates"

// DescribeListenerCertificatesRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Describes the default certificate and the certificate list for the specified
// HTTPS or TLS listener.
//
// If the default certificate is also in the certificate list, it appears twice
// in the results (once with IsDefault set to true and once with IsDefault set
// to false).
//
// For more information, see SSL Certificates (https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates)
// in the Application Load Balancers Guide.
//
//    // Example sending a request using DescribeListenerCertificatesRequest.
//    req := client.DescribeListenerCertificatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates
func (c *Client) DescribeListenerCertificatesRequest(input *DescribeListenerCertificatesInput) DescribeListenerCertificatesRequest {
	op := &aws.Operation{
		Name:       opDescribeListenerCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeListenerCertificatesInput{}
	}

	req := c.newRequest(op, input, &DescribeListenerCertificatesOutput{})
	return DescribeListenerCertificatesRequest{Request: req, Input: input, Copy: c.DescribeListenerCertificatesRequest}
}

// DescribeListenerCertificatesRequest is the request type for the
// DescribeListenerCertificates API operation.
type DescribeListenerCertificatesRequest struct {
	*aws.Request
	Input *DescribeListenerCertificatesInput
	Copy  func(*DescribeListenerCertificatesInput) DescribeListenerCertificatesRequest
}

// Send marshals and sends the DescribeListenerCertificates API request.
func (r DescribeListenerCertificatesRequest) Send(ctx context.Context) (*DescribeListenerCertificatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeListenerCertificatesResponse{
		DescribeListenerCertificatesOutput: r.Request.Data.(*DescribeListenerCertificatesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeListenerCertificatesResponse is the response type for the
// DescribeListenerCertificates API operation.
type DescribeListenerCertificatesResponse struct {
	*DescribeListenerCertificatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeListenerCertificates request.
func (r *DescribeListenerCertificatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
