// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLocalGatewayRouteTableVpcAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The IDs of the associations.
	LocalGatewayRouteTableVpcAssociationIds []string `locationName:"LocalGatewayRouteTableVpcAssociationId" locationNameList:"item" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTableVpcAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocalGatewayRouteTableVpcAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLocalGatewayRouteTableVpcAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLocalGatewayRouteTableVpcAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations.
	LocalGatewayRouteTableVpcAssociations []LocalGatewayRouteTableVpcAssociation `locationName:"localGatewayRouteTableVpcAssociationSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeLocalGatewayRouteTableVpcAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLocalGatewayRouteTableVpcAssociations = "DescribeLocalGatewayRouteTableVpcAssociations"

// DescribeLocalGatewayRouteTableVpcAssociationsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the specified associations between VPCs and local gateway route
// tables.
//
//    // Example sending a request using DescribeLocalGatewayRouteTableVpcAssociationsRequest.
//    req := client.DescribeLocalGatewayRouteTableVpcAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociations
func (c *Client) DescribeLocalGatewayRouteTableVpcAssociationsRequest(input *DescribeLocalGatewayRouteTableVpcAssociationsInput) DescribeLocalGatewayRouteTableVpcAssociationsRequest {
	op := &aws.Operation{
		Name:       opDescribeLocalGatewayRouteTableVpcAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocalGatewayRouteTableVpcAssociationsInput{}
	}

	req := c.newRequest(op, input, &DescribeLocalGatewayRouteTableVpcAssociationsOutput{})
	return DescribeLocalGatewayRouteTableVpcAssociationsRequest{Request: req, Input: input, Copy: c.DescribeLocalGatewayRouteTableVpcAssociationsRequest}
}

// DescribeLocalGatewayRouteTableVpcAssociationsRequest is the request type for the
// DescribeLocalGatewayRouteTableVpcAssociations API operation.
type DescribeLocalGatewayRouteTableVpcAssociationsRequest struct {
	*aws.Request
	Input *DescribeLocalGatewayRouteTableVpcAssociationsInput
	Copy  func(*DescribeLocalGatewayRouteTableVpcAssociationsInput) DescribeLocalGatewayRouteTableVpcAssociationsRequest
}

// Send marshals and sends the DescribeLocalGatewayRouteTableVpcAssociations API request.
func (r DescribeLocalGatewayRouteTableVpcAssociationsRequest) Send(ctx context.Context) (*DescribeLocalGatewayRouteTableVpcAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLocalGatewayRouteTableVpcAssociationsResponse{
		DescribeLocalGatewayRouteTableVpcAssociationsOutput: r.Request.Data.(*DescribeLocalGatewayRouteTableVpcAssociationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLocalGatewayRouteTableVpcAssociationsResponse is the response type for the
// DescribeLocalGatewayRouteTableVpcAssociations API operation.
type DescribeLocalGatewayRouteTableVpcAssociationsResponse struct {
	*DescribeLocalGatewayRouteTableVpcAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLocalGatewayRouteTableVpcAssociations request.
func (r *DescribeLocalGatewayRouteTableVpcAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
