// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateGlobalTableInput struct {
	_ struct{} `type:"structure"`

	// The global table name.
	//
	// GlobalTableName is a required field
	GlobalTableName *string `min:"3" type:"string" required:"true"`

	// A list of Regions that should be added or removed from the global table.
	//
	// ReplicaUpdates is a required field
	ReplicaUpdates []ReplicaUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGlobalTableInput"}

	if s.GlobalTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalTableName"))
	}
	if s.GlobalTableName != nil && len(*s.GlobalTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("GlobalTableName", 3))
	}

	if s.ReplicaUpdates == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicaUpdates"))
	}
	if s.ReplicaUpdates != nil {
		for i, v := range s.ReplicaUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateGlobalTableOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the global table.
	GlobalTableDescription *GlobalTableDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateGlobalTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateGlobalTable = "UpdateGlobalTable"

// UpdateGlobalTableRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Adds or removes replicas in the specified global table. The global table
// must already exist to be able to use this operation. Any replica to be added
// must be empty, have the same name as the global table, have the same key
// schema, have DynamoDB Streams enabled, and have the same provisioned and
// maximum write capacity units.
//
// Although you can use UpdateGlobalTable to add replicas and remove replicas
// in a single request, for simplicity we recommend that you issue separate
// requests for adding or removing replicas.
//
// If global secondary indexes are specified, then the following conditions
// must also be met:
//
//    * The global secondary indexes must have the same name.
//
//    * The global secondary indexes must have the same hash key and sort key
//    (if present).
//
//    * The global secondary indexes must have the same provisioned and maximum
//    write capacity units.
//
//    // Example sending a request using UpdateGlobalTableRequest.
//    req := client.UpdateGlobalTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTable
func (c *Client) UpdateGlobalTableRequest(input *UpdateGlobalTableInput) UpdateGlobalTableRequest {
	op := &aws.Operation{
		Name:       opUpdateGlobalTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGlobalTableInput{}
	}

	req := c.newRequest(op, input, &UpdateGlobalTableOutput{})
	return UpdateGlobalTableRequest{Request: req, Input: input, Copy: c.UpdateGlobalTableRequest}
}

// UpdateGlobalTableRequest is the request type for the
// UpdateGlobalTable API operation.
type UpdateGlobalTableRequest struct {
	*aws.Request
	Input *UpdateGlobalTableInput
	Copy  func(*UpdateGlobalTableInput) UpdateGlobalTableRequest
}

// Send marshals and sends the UpdateGlobalTable API request.
func (r UpdateGlobalTableRequest) Send(ctx context.Context) (*UpdateGlobalTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGlobalTableResponse{
		UpdateGlobalTableOutput: r.Request.Data.(*UpdateGlobalTableOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGlobalTableResponse is the response type for the
// UpdateGlobalTable API operation.
type UpdateGlobalTableResponse struct {
	*UpdateGlobalTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGlobalTable request.
func (r *UpdateGlobalTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
