// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSavingsPlansUtilizationDetailsInput struct {
	_ struct{} `type:"structure"`

	// Filters Savings Plans utilization coverage data for active Savings Plans
	// dimensions. You can filter data with the following dimensions:
	//
	//    * LINKED_ACCOUNT
	//
	//    * SAVINGS_PLAN_ARN
	//
	//    * REGION
	//
	//    * PAYMENT_OPTION
	//
	//    * INSTANCE_TYPE_FAMILY
	//
	// GetSavingsPlansUtilizationDetails uses the same Expression (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object as the other operations, but only AND is supported among each dimension.
	Filter *Expression `type:"structure"`

	// The number of items to be returned in a response. The default is 20, with
	// a minimum value of 1.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// The time period that you want the usage and costs for. The Start date must
	// be within 13 months. The End date must be after the Start date, and before
	// the current date. Future dates can't be used as an End date.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSavingsPlansUtilizationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSavingsPlansUtilizationDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSavingsPlansUtilizationDetailsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.TimePeriod == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimePeriod"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.TimePeriod != nil {
		if err := s.TimePeriod.Validate(); err != nil {
			invalidParams.AddNested("TimePeriod", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSavingsPlansUtilizationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results. Amazon Web Services provides
	// the token when the response from a previous call has more results than the
	// maximum page size.
	NextToken *string `type:"string"`

	// Retrieves a single daily or monthly Savings Plans utilization rate and details
	// for your account.
	//
	// SavingsPlansUtilizationDetails is a required field
	SavingsPlansUtilizationDetails []SavingsPlansUtilizationDetail `type:"list" required:"true"`

	// The time period that you want the usage and costs for.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`

	// The total Savings Plans utilization, regardless of time period.
	Total *SavingsPlansUtilizationAggregates `type:"structure"`
}

// String returns the string representation
func (s GetSavingsPlansUtilizationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSavingsPlansUtilizationDetails = "GetSavingsPlansUtilizationDetails"

// GetSavingsPlansUtilizationDetailsRequest returns a request value for making API operation for
// AWS Cost Explorer Service.
//
// Retrieves attribute data along with aggregate utilization and savings data
// for a given time period. This doesn't support granular or grouped data (daily/monthly)
// in response. You can't retrieve data by dates in a single response similar
// to GetSavingsPlanUtilization, but you have the option to make multiple calls
// to GetSavingsPlanUtilizationDetails by providing individual dates. You can
// use GetDimensionValues in SAVINGS_PLANS to determine the possible dimension
// values.
//
// GetSavingsPlanUtilizationDetails internally groups data by SavingsPlansArn.
//
//    // Example sending a request using GetSavingsPlansUtilizationDetailsRequest.
//    req := client.GetSavingsPlansUtilizationDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/GetSavingsPlansUtilizationDetails
func (c *Client) GetSavingsPlansUtilizationDetailsRequest(input *GetSavingsPlansUtilizationDetailsInput) GetSavingsPlansUtilizationDetailsRequest {
	op := &aws.Operation{
		Name:       opGetSavingsPlansUtilizationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSavingsPlansUtilizationDetailsInput{}
	}

	req := c.newRequest(op, input, &GetSavingsPlansUtilizationDetailsOutput{})
	return GetSavingsPlansUtilizationDetailsRequest{Request: req, Input: input, Copy: c.GetSavingsPlansUtilizationDetailsRequest}
}

// GetSavingsPlansUtilizationDetailsRequest is the request type for the
// GetSavingsPlansUtilizationDetails API operation.
type GetSavingsPlansUtilizationDetailsRequest struct {
	*aws.Request
	Input *GetSavingsPlansUtilizationDetailsInput
	Copy  func(*GetSavingsPlansUtilizationDetailsInput) GetSavingsPlansUtilizationDetailsRequest
}

// Send marshals and sends the GetSavingsPlansUtilizationDetails API request.
func (r GetSavingsPlansUtilizationDetailsRequest) Send(ctx context.Context) (*GetSavingsPlansUtilizationDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSavingsPlansUtilizationDetailsResponse{
		GetSavingsPlansUtilizationDetailsOutput: r.Request.Data.(*GetSavingsPlansUtilizationDetailsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetSavingsPlansUtilizationDetailsRequestPaginator returns a paginator for GetSavingsPlansUtilizationDetails.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetSavingsPlansUtilizationDetailsRequest(input)
//   p := costexplorer.NewGetSavingsPlansUtilizationDetailsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetSavingsPlansUtilizationDetailsPaginator(req GetSavingsPlansUtilizationDetailsRequest) GetSavingsPlansUtilizationDetailsPaginator {
	return GetSavingsPlansUtilizationDetailsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetSavingsPlansUtilizationDetailsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetSavingsPlansUtilizationDetailsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetSavingsPlansUtilizationDetailsPaginator struct {
	aws.Pager
}

func (p *GetSavingsPlansUtilizationDetailsPaginator) CurrentPage() *GetSavingsPlansUtilizationDetailsOutput {
	return p.Pager.CurrentPage().(*GetSavingsPlansUtilizationDetailsOutput)
}

// GetSavingsPlansUtilizationDetailsResponse is the response type for the
// GetSavingsPlansUtilizationDetails API operation.
type GetSavingsPlansUtilizationDetailsResponse struct {
	*GetSavingsPlansUtilizationDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSavingsPlansUtilizationDetails request.
func (r *GetSavingsPlansUtilizationDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
