// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type UpdateUserPhoneConfigInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Information about phone configuration settings for the user.
	//
	// PhoneConfig is a required field
	PhoneConfig *UserPhoneConfig `type:"structure" required:"true"`

	// The identifier of the user account.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserPhoneConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPhoneConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateUserPhoneConfigInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if s.PhoneConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("PhoneConfig"))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}
	if s.PhoneConfig != nil {
		if err := s.PhoneConfig.Validate(); err != nil {
			invalidParams.AddNested("PhoneConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateUserPhoneConfigInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PhoneConfig != nil {
		v := s.PhoneConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PhoneConfig", v, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateUserPhoneConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPhoneConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateUserPhoneConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateUserPhoneConfig = "UpdateUserPhoneConfig"

// UpdateUserPhoneConfigRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Updates the phone configuration settings for the specified user.
//
//    // Example sending a request using UpdateUserPhoneConfigRequest.
//    req := client.UpdateUserPhoneConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig
func (c *Client) UpdateUserPhoneConfigRequest(input *UpdateUserPhoneConfigInput) UpdateUserPhoneConfigRequest {
	op := &aws.Operation{
		Name:       opUpdateUserPhoneConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/phone-config",
	}

	if input == nil {
		input = &UpdateUserPhoneConfigInput{}
	}

	req := c.newRequest(op, input, &UpdateUserPhoneConfigOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateUserPhoneConfigRequest{Request: req, Input: input, Copy: c.UpdateUserPhoneConfigRequest}
}

// UpdateUserPhoneConfigRequest is the request type for the
// UpdateUserPhoneConfig API operation.
type UpdateUserPhoneConfigRequest struct {
	*aws.Request
	Input *UpdateUserPhoneConfigInput
	Copy  func(*UpdateUserPhoneConfigInput) UpdateUserPhoneConfigRequest
}

// Send marshals and sends the UpdateUserPhoneConfig API request.
func (r UpdateUserPhoneConfigRequest) Send(ctx context.Context) (*UpdateUserPhoneConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateUserPhoneConfigResponse{
		UpdateUserPhoneConfigOutput: r.Request.Data.(*UpdateUserPhoneConfigOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateUserPhoneConfigResponse is the response type for the
// UpdateUserPhoneConfig API operation.
type UpdateUserPhoneConfigResponse struct {
	*UpdateUserPhoneConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateUserPhoneConfig request.
func (r *UpdateUserPhoneConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
