// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateEnrollmentStatusInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to enroll member accounts within the organization, if the
	// account is a master account of an organization.
	IncludeMemberAccounts *bool `locationName:"includeMemberAccounts" type:"boolean"`

	// The new enrollment status of the account.
	//
	// Accepted options are Active or Inactive. You will get an error if Pending
	// or Failed are specified.
	//
	// Status is a required field
	Status Status `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateEnrollmentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnrollmentStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEnrollmentStatusInput"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateEnrollmentStatusOutput struct {
	_ struct{} `type:"structure"`

	// The enrollment status of the account.
	Status Status `locationName:"status" type:"string" enum:"true"`

	// The reason for the enrollment status of the account. For example, an account
	// might show a status of Pending because member accounts of an organization
	// require more time to be enrolled in the service.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation
func (s UpdateEnrollmentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateEnrollmentStatus = "UpdateEnrollmentStatus"

// UpdateEnrollmentStatusRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Updates the enrollment (opt in) status of an account to the AWS Compute Optimizer
// service.
//
// If the account is a master account of an organization, this operation can
// also enroll member accounts within the organization.
//
//    // Example sending a request using UpdateEnrollmentStatusRequest.
//    req := client.UpdateEnrollmentStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/UpdateEnrollmentStatus
func (c *Client) UpdateEnrollmentStatusRequest(input *UpdateEnrollmentStatusInput) UpdateEnrollmentStatusRequest {
	op := &aws.Operation{
		Name:       opUpdateEnrollmentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnrollmentStatusInput{}
	}

	req := c.newRequest(op, input, &UpdateEnrollmentStatusOutput{})
	return UpdateEnrollmentStatusRequest{Request: req, Input: input, Copy: c.UpdateEnrollmentStatusRequest}
}

// UpdateEnrollmentStatusRequest is the request type for the
// UpdateEnrollmentStatus API operation.
type UpdateEnrollmentStatusRequest struct {
	*aws.Request
	Input *UpdateEnrollmentStatusInput
	Copy  func(*UpdateEnrollmentStatusInput) UpdateEnrollmentStatusRequest
}

// Send marshals and sends the UpdateEnrollmentStatus API request.
func (r UpdateEnrollmentStatusRequest) Send(ctx context.Context) (*UpdateEnrollmentStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEnrollmentStatusResponse{
		UpdateEnrollmentStatusOutput: r.Request.Data.(*UpdateEnrollmentStatusOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEnrollmentStatusResponse is the response type for the
// UpdateEnrollmentStatus API operation.
type UpdateEnrollmentStatusResponse struct {
	*UpdateEnrollmentStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEnrollmentStatus request.
func (r *UpdateEnrollmentStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
