// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEntitiesDetectionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopEntitiesDetectionJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopEntitiesDetectionJob operation.
	JobStatus JobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StopEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopEntitiesDetectionJob = "StopEntitiesDetectionJob"

// StopEntitiesDetectionJobRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Stops an entities detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
//    // Example sending a request using StopEntitiesDetectionJobRequest.
//    req := client.StopEntitiesDetectionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob
func (c *Client) StopEntitiesDetectionJobRequest(input *StopEntitiesDetectionJobInput) StopEntitiesDetectionJobRequest {
	op := &aws.Operation{
		Name:       opStopEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEntitiesDetectionJobInput{}
	}

	req := c.newRequest(op, input, &StopEntitiesDetectionJobOutput{})
	return StopEntitiesDetectionJobRequest{Request: req, Input: input, Copy: c.StopEntitiesDetectionJobRequest}
}

// StopEntitiesDetectionJobRequest is the request type for the
// StopEntitiesDetectionJob API operation.
type StopEntitiesDetectionJobRequest struct {
	*aws.Request
	Input *StopEntitiesDetectionJobInput
	Copy  func(*StopEntitiesDetectionJobInput) StopEntitiesDetectionJobRequest
}

// Send marshals and sends the StopEntitiesDetectionJob API request.
func (r StopEntitiesDetectionJobRequest) Send(ctx context.Context) (*StopEntitiesDetectionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopEntitiesDetectionJobResponse{
		StopEntitiesDetectionJobOutput: r.Request.Data.(*StopEntitiesDetectionJobOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopEntitiesDetectionJobResponse is the response type for the
// StopEntitiesDetectionJob API operation.
type StopEntitiesDetectionJobResponse struct {
	*StopEntitiesDetectionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopEntitiesDetectionJob request.
func (r *StopEntitiesDetectionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
