// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cognitoidentityiface provides an interface to enable mocking the Amazon Cognito Identity service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cognitoidentityiface

import (
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentity"
)

// ClientAPI provides an interface to enable mocking the
// cognitoidentity.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Cognito Identity.
//    func myFunc(svc cognitoidentityiface.ClientAPI) bool {
//        // Make svc.CreateIdentityPool request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := cognitoidentity.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        cognitoidentityiface.ClientPI
//    }
//    func (m *mockClientClient) CreateIdentityPool(input *cognitoidentity.CreateIdentityPoolInput) (*cognitoidentity.CreateIdentityPoolOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateIdentityPoolRequest(*cognitoidentity.CreateIdentityPoolInput) cognitoidentity.CreateIdentityPoolRequest

	DeleteIdentitiesRequest(*cognitoidentity.DeleteIdentitiesInput) cognitoidentity.DeleteIdentitiesRequest

	DeleteIdentityPoolRequest(*cognitoidentity.DeleteIdentityPoolInput) cognitoidentity.DeleteIdentityPoolRequest

	DescribeIdentityRequest(*cognitoidentity.DescribeIdentityInput) cognitoidentity.DescribeIdentityRequest

	DescribeIdentityPoolRequest(*cognitoidentity.DescribeIdentityPoolInput) cognitoidentity.DescribeIdentityPoolRequest

	GetCredentialsForIdentityRequest(*cognitoidentity.GetCredentialsForIdentityInput) cognitoidentity.GetCredentialsForIdentityRequest

	GetIdRequest(*cognitoidentity.GetIdInput) cognitoidentity.GetIdRequest

	GetIdentityPoolRolesRequest(*cognitoidentity.GetIdentityPoolRolesInput) cognitoidentity.GetIdentityPoolRolesRequest

	GetOpenIdTokenRequest(*cognitoidentity.GetOpenIdTokenInput) cognitoidentity.GetOpenIdTokenRequest

	GetOpenIdTokenForDeveloperIdentityRequest(*cognitoidentity.GetOpenIdTokenForDeveloperIdentityInput) cognitoidentity.GetOpenIdTokenForDeveloperIdentityRequest

	ListIdentitiesRequest(*cognitoidentity.ListIdentitiesInput) cognitoidentity.ListIdentitiesRequest

	ListIdentityPoolsRequest(*cognitoidentity.ListIdentityPoolsInput) cognitoidentity.ListIdentityPoolsRequest

	ListTagsForResourceRequest(*cognitoidentity.ListTagsForResourceInput) cognitoidentity.ListTagsForResourceRequest

	LookupDeveloperIdentityRequest(*cognitoidentity.LookupDeveloperIdentityInput) cognitoidentity.LookupDeveloperIdentityRequest

	MergeDeveloperIdentitiesRequest(*cognitoidentity.MergeDeveloperIdentitiesInput) cognitoidentity.MergeDeveloperIdentitiesRequest

	SetIdentityPoolRolesRequest(*cognitoidentity.SetIdentityPoolRolesInput) cognitoidentity.SetIdentityPoolRolesRequest

	TagResourceRequest(*cognitoidentity.TagResourceInput) cognitoidentity.TagResourceRequest

	UnlinkDeveloperIdentityRequest(*cognitoidentity.UnlinkDeveloperIdentityInput) cognitoidentity.UnlinkDeveloperIdentityRequest

	UnlinkIdentityRequest(*cognitoidentity.UnlinkIdentityInput) cognitoidentity.UnlinkIdentityRequest

	UntagResourceRequest(*cognitoidentity.UntagResourceInput) cognitoidentity.UntagResourceRequest

	UpdateIdentityPoolRequest(*cognitoidentity.UpdateIdentityPoolInput) cognitoidentity.UpdateIdentityPoolRequest
}

var _ ClientAPI = (*cognitoidentity.Client)(nil)
