// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Input to the DeleteIdentityPool action.
type DeleteIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityPoolInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteIdentityPoolInput"}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteIdentityPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPoolOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteIdentityPool = "DeleteIdentityPool"

// DeleteIdentityPoolRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Deletes an identity pool. Once a pool is deleted, users will not be able
// to authenticate with the pool.
//
// You must use AWS Developer credentials to call this API.
//
//    // Example sending a request using DeleteIdentityPoolRequest.
//    req := client.DeleteIdentityPoolRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentityPool
func (c *Client) DeleteIdentityPoolRequest(input *DeleteIdentityPoolInput) DeleteIdentityPoolRequest {
	op := &aws.Operation{
		Name:       opDeleteIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityPoolInput{}
	}

	req := c.newRequest(op, input, &DeleteIdentityPoolOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteIdentityPoolRequest{Request: req, Input: input, Copy: c.DeleteIdentityPoolRequest}
}

// DeleteIdentityPoolRequest is the request type for the
// DeleteIdentityPool API operation.
type DeleteIdentityPoolRequest struct {
	*aws.Request
	Input *DeleteIdentityPoolInput
	Copy  func(*DeleteIdentityPoolInput) DeleteIdentityPoolRequest
}

// Send marshals and sends the DeleteIdentityPool API request.
func (r DeleteIdentityPoolRequest) Send(ctx context.Context) (*DeleteIdentityPoolResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteIdentityPoolResponse{
		DeleteIdentityPoolOutput: r.Request.Data.(*DeleteIdentityPoolOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteIdentityPoolResponse is the response type for the
// DeleteIdentityPool API operation.
type DeleteIdentityPoolResponse struct {
	*DeleteIdentityPoolOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteIdentityPool request.
func (r *DeleteIdentityPoolResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
