// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a ListPipelineExecutions action.
type ListPipelineExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. Pipeline
	// history is limited to the most recent 12 months, based on pipeline execution
	// start times. Default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token that was returned from the previous ListPipelineExecutions call,
	// which can be used to return the next set of pipeline executions in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the pipeline for which you want to get execution summary information.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPipelineExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelineExecutionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPipelineExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a ListPipelineExecutions action.
type ListPipelineExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used in the next ListPipelineExecutions call. To view
	// all items in the list, continue to call this operation with each subsequent
	// token until no more nextToken values are returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of executions in the history of a pipeline.
	PipelineExecutionSummaries []PipelineExecutionSummary `locationName:"pipelineExecutionSummaries" type:"list"`
}

// String returns the string representation
func (s ListPipelineExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPipelineExecutions = "ListPipelineExecutions"

// ListPipelineExecutionsRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Gets a summary of the most recent executions for a pipeline.
//
//    // Example sending a request using ListPipelineExecutionsRequest.
//    req := client.ListPipelineExecutionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions
func (c *Client) ListPipelineExecutionsRequest(input *ListPipelineExecutionsInput) ListPipelineExecutionsRequest {
	op := &aws.Operation{
		Name:       opListPipelineExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelineExecutionsInput{}
	}

	req := c.newRequest(op, input, &ListPipelineExecutionsOutput{})
	return ListPipelineExecutionsRequest{Request: req, Input: input, Copy: c.ListPipelineExecutionsRequest}
}

// ListPipelineExecutionsRequest is the request type for the
// ListPipelineExecutions API operation.
type ListPipelineExecutionsRequest struct {
	*aws.Request
	Input *ListPipelineExecutionsInput
	Copy  func(*ListPipelineExecutionsInput) ListPipelineExecutionsRequest
}

// Send marshals and sends the ListPipelineExecutions API request.
func (r ListPipelineExecutionsRequest) Send(ctx context.Context) (*ListPipelineExecutionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPipelineExecutionsResponse{
		ListPipelineExecutionsOutput: r.Request.Data.(*ListPipelineExecutionsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPipelineExecutionsRequestPaginator returns a paginator for ListPipelineExecutions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPipelineExecutionsRequest(input)
//   p := codepipeline.NewListPipelineExecutionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPipelineExecutionsPaginator(req ListPipelineExecutionsRequest) ListPipelineExecutionsPaginator {
	return ListPipelineExecutionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPipelineExecutionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPipelineExecutionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPipelineExecutionsPaginator struct {
	aws.Pager
}

func (p *ListPipelineExecutionsPaginator) CurrentPage() *ListPipelineExecutionsOutput {
	return p.Pager.CurrentPage().(*ListPipelineExecutionsOutput)
}

// ListPipelineExecutionsResponse is the response type for the
// ListPipelineExecutions API operation.
type ListPipelineExecutionsResponse struct {
	*ListPipelineExecutionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPipelineExecutions request.
func (r *ListPipelineExecutionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
