// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request for ListProfileTimes operation.
type ListProfileTimesInput struct {
	_ struct{} `type:"structure"`

	// The end time of the time range to list profiles until.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Upper bound on the number of results to list in a single call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Token for paginating results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The order (ascending or descending by start time of the profile) to list
	// the profiles by. Defaults to TIMESTAMP_DESCENDING.
	OrderBy OrderBy `location:"querystring" locationName:"orderBy" type:"string" enum:"true"`

	// The aggregation period to list the profiles for.
	//
	// Period is a required field
	Period AggregationPeriod `location:"querystring" locationName:"period" type:"string" required:"true" enum:"true"`

	// The name of the profiling group.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// The start time of the time range to list the profiles from.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListProfileTimesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileTimesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProfileTimesInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if len(s.Period) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Period"))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProfileTimesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Period) > 0 {
		v := s.Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "period", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	return nil
}

// Response for ListProfileTimes operation.
type ListProfileTimesOutput struct {
	_ struct{} `type:"structure"`

	// Token for paginating results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// List of start times of the available profiles for the aggregation period
	// in the specified time range.
	//
	// ProfileTimes is a required field
	ProfileTimes []ProfileTime `locationName:"profileTimes" type:"list" required:"true"`
}

// String returns the string representation
func (s ListProfileTimesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListProfileTimesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProfileTimes != nil {
		v := s.ProfileTimes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "profileTimes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListProfileTimes = "ListProfileTimes"

// ListProfileTimesRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// List the start times of the available aggregated profiles of a profiling
// group for an aggregation period within the specified time range.
//
//    // Example sending a request using ListProfileTimesRequest.
//    req := client.ListProfileTimesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes
func (c *Client) ListProfileTimesRequest(input *ListProfileTimesInput) ListProfileTimesRequest {
	op := &aws.Operation{
		Name:       opListProfileTimes,
		HTTPMethod: "GET",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/profileTimes",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfileTimesInput{}
	}

	req := c.newRequest(op, input, &ListProfileTimesOutput{})
	return ListProfileTimesRequest{Request: req, Input: input, Copy: c.ListProfileTimesRequest}
}

// ListProfileTimesRequest is the request type for the
// ListProfileTimes API operation.
type ListProfileTimesRequest struct {
	*aws.Request
	Input *ListProfileTimesInput
	Copy  func(*ListProfileTimesInput) ListProfileTimesRequest
}

// Send marshals and sends the ListProfileTimes API request.
func (r ListProfileTimesRequest) Send(ctx context.Context) (*ListProfileTimesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProfileTimesResponse{
		ListProfileTimesOutput: r.Request.Data.(*ListProfileTimesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProfileTimesRequestPaginator returns a paginator for ListProfileTimes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProfileTimesRequest(input)
//   p := codeguruprofiler.NewListProfileTimesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProfileTimesPaginator(req ListProfileTimesRequest) ListProfileTimesPaginator {
	return ListProfileTimesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProfileTimesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProfileTimesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProfileTimesPaginator struct {
	aws.Pager
}

func (p *ListProfileTimesPaginator) CurrentPage() *ListProfileTimesOutput {
	return p.Pager.CurrentPage().(*ListProfileTimesOutput)
}

// ListProfileTimesResponse is the response type for the
// ListProfileTimes API operation.
type ListProfileTimesResponse struct {
	*ListProfileTimesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProfileTimes request.
func (r *ListProfileTimesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
