// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input of a RegisterApplicationRevision operation.
type RegisterApplicationRevisionInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the IAM user or
	// AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// A comment about the revision.
	Description *string `locationName:"description" type:"string"`

	// Information about the application revision to register, including type and
	// location.
	//
	// Revision is a required field
	Revision *RevisionLocation `locationName:"revision" type:"structure" required:"true"`
}

// String returns the string representation
func (s RegisterApplicationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterApplicationRevisionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterApplicationRevisionInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.Revision == nil {
		invalidParams.Add(aws.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterApplicationRevisionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterApplicationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterApplicationRevision = "RegisterApplicationRevision"

// RegisterApplicationRevisionRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Registers with AWS CodeDeploy a revision for the specified application.
//
//    // Example sending a request using RegisterApplicationRevisionRequest.
//    req := client.RegisterApplicationRevisionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision
func (c *Client) RegisterApplicationRevisionRequest(input *RegisterApplicationRevisionInput) RegisterApplicationRevisionRequest {
	op := &aws.Operation{
		Name:       opRegisterApplicationRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterApplicationRevisionInput{}
	}

	req := c.newRequest(op, input, &RegisterApplicationRevisionOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RegisterApplicationRevisionRequest{Request: req, Input: input, Copy: c.RegisterApplicationRevisionRequest}
}

// RegisterApplicationRevisionRequest is the request type for the
// RegisterApplicationRevision API operation.
type RegisterApplicationRevisionRequest struct {
	*aws.Request
	Input *RegisterApplicationRevisionInput
	Copy  func(*RegisterApplicationRevisionInput) RegisterApplicationRevisionRequest
}

// Send marshals and sends the RegisterApplicationRevision API request.
func (r RegisterApplicationRevisionRequest) Send(ctx context.Context) (*RegisterApplicationRevisionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterApplicationRevisionResponse{
		RegisterApplicationRevisionOutput: r.Request.Data.(*RegisterApplicationRevisionOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterApplicationRevisionResponse is the response type for the
// RegisterApplicationRevision API operation.
type RegisterApplicationRevisionResponse struct {
	*RegisterApplicationRevisionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterApplicationRevision request.
func (r *RegisterApplicationRevisionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
