// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetLogEventsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time range, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than
	// this time are not included.
	EndTime *int64 `locationName:"endTime" type:"long"`

	// The maximum number of log events returned. If you don't specify a value,
	// the maximum is as many log events as can fit in a response size of 1 MB,
	// up to 10,000 log events.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The name of the log stream.
	//
	// LogStreamName is a required field
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	//
	// Using this token works only when you specify true for startFromHead.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// If the value is true, the earliest log events are returned first. If the
	// value is false, the latest log events are returned first. The default value
	// is false.
	//
	// If you are using nextToken in this operation, you must specify true for startFromHead.
	StartFromHead *bool `locationName:"startFromHead" type:"boolean"`

	// The start of the time range, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this time or later
	// than this time are included. Events with a timestamp earlier than this time
	// are not included.
	StartTime *int64 `locationName:"startTime" type:"long"`
}

// String returns the string representation
func (s GetLogEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLogEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLogEventsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.LogStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogStreamName"))
	}
	if s.LogStreamName != nil && len(*s.LogStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetLogEventsOutput struct {
	_ struct{} `type:"structure"`

	// The events.
	Events []OutputLogEvent `locationName:"events" type:"list"`

	// The token for the next set of items in the backward direction. The token
	// expires after 24 hours. This token will never be null. If you have reached
	// the end of the stream, it will return the same token you passed in.
	NextBackwardToken *string `locationName:"nextBackwardToken" min:"1" type:"string"`

	// The token for the next set of items in the forward direction. The token expires
	// after 24 hours. If you have reached the end of the stream, it will return
	// the same token you passed in.
	NextForwardToken *string `locationName:"nextForwardToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetLogEventsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetLogEvents = "GetLogEvents"

// GetLogEventsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists log events from the specified log stream. You can list all the log
// events or filter using a time range.
//
// By default, this operation returns as many log events as can fit in a response
// size of 1MB (up to 10,000 log events). You can get additional log events
// by specifying one of the tokens in a subsequent call.
//
//    // Example sending a request using GetLogEventsRequest.
//    req := client.GetLogEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEvents
func (c *Client) GetLogEventsRequest(input *GetLogEventsInput) GetLogEventsRequest {
	op := &aws.Operation{
		Name:       opGetLogEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextForwardToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLogEventsInput{}
	}

	req := c.newRequest(op, input, &GetLogEventsOutput{})
	return GetLogEventsRequest{Request: req, Input: input, Copy: c.GetLogEventsRequest}
}

// GetLogEventsRequest is the request type for the
// GetLogEvents API operation.
type GetLogEventsRequest struct {
	*aws.Request
	Input *GetLogEventsInput
	Copy  func(*GetLogEventsInput) GetLogEventsRequest
}

// Send marshals and sends the GetLogEvents API request.
func (r GetLogEventsRequest) Send(ctx context.Context) (*GetLogEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLogEventsResponse{
		GetLogEventsOutput: r.Request.Data.(*GetLogEventsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetLogEventsRequestPaginator returns a paginator for GetLogEvents.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetLogEventsRequest(input)
//   p := cloudwatchlogs.NewGetLogEventsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetLogEventsPaginator(req GetLogEventsRequest) GetLogEventsPaginator {
	return GetLogEventsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetLogEventsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetLogEventsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetLogEventsPaginator struct {
	aws.Pager
}

func (p *GetLogEventsPaginator) CurrentPage() *GetLogEventsOutput {
	return p.Pager.CurrentPage().(*GetLogEventsOutput)
}

// GetLogEventsResponse is the response type for the
// GetLogEvents API operation.
type GetLogEventsResponse struct {
	*GetLogEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLogEvents request.
func (r *GetLogEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
