// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreatePartnerEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the customer who is permitted to create a matching
	// partner event bus for this partner event source.
	//
	// Account is a required field
	Account *string `min:"12" type:"string" required:"true"`

	// The name of the partner event source. This name must be unique and must be
	// in the format partner_name/event_namespace/event_name . The AWS account that
	// wants to use this partner event source must create a partner event bus with
	// a name that matches the name of the partner event source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePartnerEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePartnerEventSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePartnerEventSourceInput"}

	if s.Account == nil {
		invalidParams.Add(aws.NewErrParamRequired("Account"))
	}
	if s.Account != nil && len(*s.Account) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("Account", 12))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreatePartnerEventSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the partner event source.
	EventSourceArn *string `type:"string"`
}

// String returns the string representation
func (s CreatePartnerEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreatePartnerEventSource = "CreatePartnerEventSource"

// CreatePartnerEventSourceRequest returns a request value for making API operation for
// Amazon CloudWatch Events.
//
// Called by an SaaS partner to create a partner event source.
//
// This operation is not used by AWS customers.
//
// Each partner event source can be used by one AWS account to create a matching
// partner event bus in that AWS account. A SaaS partner must create one partner
// event source for each AWS account that wants to receive those event types.
//
// A partner event source creates events based on resources in the SaaS partner's
// service or application.
//
// An AWS account that creates a partner event bus that matches the partner
// event source can use that event bus to receive events from the partner, and
// then process them using AWS Events rules and targets.
//
// Partner event source names follow this format:
//
// aws.partner/partner_name/event_namespace/event_name
//
//    * partner_name is determined during partner registration and identifies
//    the partner to AWS customers.
//
//    * For event_namespace, we recommend that partners use a string that identifies
//    the AWS customer within the partner's system. This should not be the customer's
//    AWS account ID.
//
//    * event_name is determined by the partner, and should uniquely identify
//    an event-generating resource within the partner system. This should help
//    AWS customers decide whether to create an event bus to receive these events.
//
//    // Example sending a request using CreatePartnerEventSourceRequest.
//    req := client.CreatePartnerEventSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/CreatePartnerEventSource
func (c *Client) CreatePartnerEventSourceRequest(input *CreatePartnerEventSourceInput) CreatePartnerEventSourceRequest {
	op := &aws.Operation{
		Name:       opCreatePartnerEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePartnerEventSourceInput{}
	}

	req := c.newRequest(op, input, &CreatePartnerEventSourceOutput{})
	return CreatePartnerEventSourceRequest{Request: req, Input: input, Copy: c.CreatePartnerEventSourceRequest}
}

// CreatePartnerEventSourceRequest is the request type for the
// CreatePartnerEventSource API operation.
type CreatePartnerEventSourceRequest struct {
	*aws.Request
	Input *CreatePartnerEventSourceInput
	Copy  func(*CreatePartnerEventSourceInput) CreatePartnerEventSourceRequest
}

// Send marshals and sends the CreatePartnerEventSource API request.
func (r CreatePartnerEventSourceRequest) Send(ctx context.Context) (*CreatePartnerEventSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePartnerEventSourceResponse{
		CreatePartnerEventSourceOutput: r.Request.Data.(*CreatePartnerEventSourceOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePartnerEventSourceResponse is the response type for the
// CreatePartnerEventSource API operation.
type CreatePartnerEventSourceResponse struct {
	*CreatePartnerEventSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePartnerEventSource request.
func (r *CreatePartnerEventSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
