// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The time stamp indicating the latest data to be returned.
	//
	// The value specified is exclusive; results include data points up to the specified
	// time stamp.
	//
	// For better performance, specify StartTime and EndTime values that align with
	// the value of the metric's Period and sync up with the beginning and end of
	// an hour. For example, if the Period of a metric is 5 minutes, specifying
	// 12:05 or 12:30 as EndTime can get a faster response from CloudWatch than
	// setting 12:07 or 12:29 as the EndTime.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The maximum number of data points the request should return before paginating.
	// If you omit this, the default of 100,800 is used.
	MaxDatapoints *int64 `type:"integer"`

	// The metric queries to be returned. A single GetMetricData call can include
	// as many as 100 MetricDataQuery structures. Each of these structures can specify
	// either a metric to retrieve, or a math expression to perform on retrieved
	// data.
	//
	// MetricDataQueries is a required field
	MetricDataQueries []MetricDataQuery `type:"list" required:"true"`

	// Include this value, if it was returned by the previous call, to get the next
	// set of data points.
	NextToken *string `type:"string"`

	// The order in which data points should be returned. TimestampDescending returns
	// the newest data first and paginates when the MaxDatapoints limit is reached.
	// TimestampAscending returns the oldest data first and paginates when the MaxDatapoints
	// limit is reached.
	ScanBy ScanBy `type:"string" enum:"true"`

	// The time stamp indicating the earliest data to be returned.
	//
	// The value specified is inclusive; results include data points with the specified
	// time stamp.
	//
	// CloudWatch rounds the specified time stamp as follows:
	//
	//    * Start time less than 15 days ago - Round down to the nearest whole minute.
	//    For example, 12:32:34 is rounded down to 12:32:00.
	//
	//    * Start time between 15 and 63 days ago - Round down to the nearest 5-minute
	//    clock interval. For example, 12:32:34 is rounded down to 12:30:00.
	//
	//    * Start time greater than 63 days ago - Round down to the nearest 1-hour
	//    clock interval. For example, 12:32:34 is rounded down to 12:00:00.
	//
	// If you set Period to 5, 10, or 30, the start time of your request is rounded
	// down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions
	// of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for
	// the previous 10-second period, the start time of your request is rounded
	// down and you receive data from 01:05:10 to 01:05:20. If you make a query
	// at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds,
	// you receive data timestamped between 15:02:15 and 15:07:15.
	//
	// For better performance, specify StartTime and EndTime values that align with
	// the value of the metric's Period and sync up with the beginning and end of
	// an hour. For example, if the Period of a metric is 5 minutes, specifying
	// 12:05 or 12:30 as StartTime can get a faster response from CloudWatch than
	// setting 12:07 or 12:29 as the StartTime.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMetricDataInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.MetricDataQueries == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricDataQueries"))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// Contains a message about this GetMetricData operation, if the operation results
	// in such a message. An example of a message that may be returned is Maximum
	// number of allowed metrics exceeded. If there is a message, as much of the
	// operation as possible is still executed.
	//
	// A message appears here only if it is related to the global GetMetricData
	// operation. Any message about a specific metric returned by the operation
	// appears in the MetricDataResult object returned for that metric.
	Messages []MessageData `type:"list"`

	// The metrics that are returned, including the metric name, namespace, and
	// dimensions.
	MetricDataResults []MetricDataResult `type:"list"`

	// A token that marks the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// You can use the GetMetricData API to retrieve as many as 100 different metrics
// in a single request, with a total of as many as 100,800 data points. You
// can also optionally perform math expressions on the values of the returned
// statistics, to create new time series that represent new insights into your
// data. For example, using Lambda metrics, you could divide the Errors metric
// by the Invocations metric to get an error rate time series. For more information
// about metric math expressions, see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
// in the Amazon CloudWatch User Guide.
//
// Calls to the GetMetricData API have a different pricing structure than calls
// to GetMetricStatistics. For more information about pricing, see Amazon CloudWatch
// Pricing (https://aws.amazon.com/cloudwatch/pricing/).
//
// Amazon CloudWatch retains metric data as follows:
//
//    * Data points with a period of less than 60 seconds are available for
//    3 hours. These data points are high-resolution metrics and are available
//    only for custom metrics that have been defined with a StorageResolution
//    of 1.
//
//    * Data points with a period of 60 seconds (1-minute) are available for
//    15 days.
//
//    * Data points with a period of 300 seconds (5-minute) are available for
//    63 days.
//
//    * Data points with a period of 3600 seconds (1 hour) are available for
//    455 days (15 months).
//
// Data points that are initially published with a shorter period are aggregated
// together for long-term storage. For example, if you collect data using a
// period of 1 minute, the data remains available for 15 days with 1-minute
// resolution. After 15 days, this data is still available, but is aggregated
// and retrievable only with a resolution of 5 minutes. After 63 days, the data
// is further aggregated and is available with a resolution of 1 hour.
//
// If you omit Unit in your request, all data that was collected with any unit
// is returned, along with the corresponding units that were specified when
// the data was reported to CloudWatch. If you specify a unit, the operation
// returns only data data that was collected with that unit specified. If you
// specify a unit that does not match the data collected, the results of the
// operation are null. CloudWatch does not perform unit conversions.
//
//    // Example sending a request using GetMetricDataRequest.
//    req := client.GetMetricDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricData
func (c *Client) GetMetricDataRequest(input *GetMetricDataInput) GetMetricDataRequest {
	op := &aws.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxDatapoints",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	req := c.newRequest(op, input, &GetMetricDataOutput{})
	return GetMetricDataRequest{Request: req, Input: input, Copy: c.GetMetricDataRequest}
}

// GetMetricDataRequest is the request type for the
// GetMetricData API operation.
type GetMetricDataRequest struct {
	*aws.Request
	Input *GetMetricDataInput
	Copy  func(*GetMetricDataInput) GetMetricDataRequest
}

// Send marshals and sends the GetMetricData API request.
func (r GetMetricDataRequest) Send(ctx context.Context) (*GetMetricDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMetricDataResponse{
		GetMetricDataOutput: r.Request.Data.(*GetMetricDataOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetMetricDataRequestPaginator returns a paginator for GetMetricData.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetMetricDataRequest(input)
//   p := cloudwatch.NewGetMetricDataRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetMetricDataPaginator(req GetMetricDataRequest) GetMetricDataPaginator {
	return GetMetricDataPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetMetricDataInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetMetricDataPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetMetricDataPaginator struct {
	aws.Pager
}

func (p *GetMetricDataPaginator) CurrentPage() *GetMetricDataOutput {
	return p.Pager.CurrentPage().(*GetMetricDataOutput)
}

// GetMetricDataResponse is the response type for the
// GetMetricData API operation.
type GetMetricDataResponse struct {
	*GetMetricDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMetricData request.
func (r *GetMetricDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
