// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetConfigInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`

	// The client version.
	//
	// ClientVersion is a required field
	ClientVersion Version `type:"string" required:"true" enum:"true"`

	// A list of ARNs that identify the high-availability partition groups that
	// are associated with the client.
	//
	// HapgList is a required field
	HapgList []string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetConfigInput"}

	if s.ClientArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientArn"))
	}
	if len(s.ClientVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ClientVersion"))
	}

	if s.HapgList == nil {
		invalidParams.Add(aws.NewErrParamRequired("HapgList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetConfigOutput struct {
	_ struct{} `type:"structure"`

	// The certificate file containing the server.pem files of the HSMs.
	ConfigCred *string `type:"string"`

	// The chrystoki.conf configuration file.
	ConfigFile *string `type:"string"`

	// The type of credentials.
	ConfigType *string `type:"string"`
}

// String returns the string representation
func (s GetConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetConfig = "GetConfig"

// GetConfigRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Gets the configuration files necessary to connect to all high availability
// partition groups the client is associated with.
//
//    // Example sending a request using GetConfigRequest.
//    req := client.GetConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfig
func (c *Client) GetConfigRequest(input *GetConfigInput) GetConfigRequest {
	op := &aws.Operation{
		Name:       opGetConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConfigInput{}
	}

	req := c.newRequest(op, input, &GetConfigOutput{})
	return GetConfigRequest{Request: req, Input: input, Copy: c.GetConfigRequest}
}

// GetConfigRequest is the request type for the
// GetConfig API operation.
type GetConfigRequest struct {
	*aws.Request
	Input *GetConfigInput
	Copy  func(*GetConfigInput) GetConfigRequest
}

// Send marshals and sends the GetConfig API request.
func (r GetConfigRequest) Send(ctx context.Context) (*GetConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetConfigResponse{
		GetConfigOutput: r.Request.Data.(*GetConfigOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetConfigResponse is the response type for the
// GetConfig API operation.
type GetConfigResponse struct {
	*GetConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetConfig request.
func (r *GetConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
