// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package backupiface provides an interface to enable mocking the AWS Backup service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package backupiface

import (
	"github.com/aws/aws-sdk-go-v2/service/backup"
)

// ClientAPI provides an interface to enable mocking the
// backup.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Backup.
//    func myFunc(svc backupiface.ClientAPI) bool {
//        // Make svc.CreateBackupPlan request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := backup.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        backupiface.ClientPI
//    }
//    func (m *mockClientClient) CreateBackupPlan(input *backup.CreateBackupPlanInput) (*backup.CreateBackupPlanOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateBackupPlanRequest(*backup.CreateBackupPlanInput) backup.CreateBackupPlanRequest

	CreateBackupSelectionRequest(*backup.CreateBackupSelectionInput) backup.CreateBackupSelectionRequest

	CreateBackupVaultRequest(*backup.CreateBackupVaultInput) backup.CreateBackupVaultRequest

	DeleteBackupPlanRequest(*backup.DeleteBackupPlanInput) backup.DeleteBackupPlanRequest

	DeleteBackupSelectionRequest(*backup.DeleteBackupSelectionInput) backup.DeleteBackupSelectionRequest

	DeleteBackupVaultRequest(*backup.DeleteBackupVaultInput) backup.DeleteBackupVaultRequest

	DeleteBackupVaultAccessPolicyRequest(*backup.DeleteBackupVaultAccessPolicyInput) backup.DeleteBackupVaultAccessPolicyRequest

	DeleteBackupVaultNotificationsRequest(*backup.DeleteBackupVaultNotificationsInput) backup.DeleteBackupVaultNotificationsRequest

	DeleteRecoveryPointRequest(*backup.DeleteRecoveryPointInput) backup.DeleteRecoveryPointRequest

	DescribeBackupJobRequest(*backup.DescribeBackupJobInput) backup.DescribeBackupJobRequest

	DescribeBackupVaultRequest(*backup.DescribeBackupVaultInput) backup.DescribeBackupVaultRequest

	DescribeProtectedResourceRequest(*backup.DescribeProtectedResourceInput) backup.DescribeProtectedResourceRequest

	DescribeRecoveryPointRequest(*backup.DescribeRecoveryPointInput) backup.DescribeRecoveryPointRequest

	DescribeRestoreJobRequest(*backup.DescribeRestoreJobInput) backup.DescribeRestoreJobRequest

	ExportBackupPlanTemplateRequest(*backup.ExportBackupPlanTemplateInput) backup.ExportBackupPlanTemplateRequest

	GetBackupPlanRequest(*backup.GetBackupPlanInput) backup.GetBackupPlanRequest

	GetBackupPlanFromJSONRequest(*backup.GetBackupPlanFromJSONInput) backup.GetBackupPlanFromJSONRequest

	GetBackupPlanFromTemplateRequest(*backup.GetBackupPlanFromTemplateInput) backup.GetBackupPlanFromTemplateRequest

	GetBackupSelectionRequest(*backup.GetBackupSelectionInput) backup.GetBackupSelectionRequest

	GetBackupVaultAccessPolicyRequest(*backup.GetBackupVaultAccessPolicyInput) backup.GetBackupVaultAccessPolicyRequest

	GetBackupVaultNotificationsRequest(*backup.GetBackupVaultNotificationsInput) backup.GetBackupVaultNotificationsRequest

	GetRecoveryPointRestoreMetadataRequest(*backup.GetRecoveryPointRestoreMetadataInput) backup.GetRecoveryPointRestoreMetadataRequest

	GetSupportedResourceTypesRequest(*backup.GetSupportedResourceTypesInput) backup.GetSupportedResourceTypesRequest

	ListBackupJobsRequest(*backup.ListBackupJobsInput) backup.ListBackupJobsRequest

	ListBackupPlanTemplatesRequest(*backup.ListBackupPlanTemplatesInput) backup.ListBackupPlanTemplatesRequest

	ListBackupPlanVersionsRequest(*backup.ListBackupPlanVersionsInput) backup.ListBackupPlanVersionsRequest

	ListBackupPlansRequest(*backup.ListBackupPlansInput) backup.ListBackupPlansRequest

	ListBackupSelectionsRequest(*backup.ListBackupSelectionsInput) backup.ListBackupSelectionsRequest

	ListBackupVaultsRequest(*backup.ListBackupVaultsInput) backup.ListBackupVaultsRequest

	ListProtectedResourcesRequest(*backup.ListProtectedResourcesInput) backup.ListProtectedResourcesRequest

	ListRecoveryPointsByBackupVaultRequest(*backup.ListRecoveryPointsByBackupVaultInput) backup.ListRecoveryPointsByBackupVaultRequest

	ListRecoveryPointsByResourceRequest(*backup.ListRecoveryPointsByResourceInput) backup.ListRecoveryPointsByResourceRequest

	ListRestoreJobsRequest(*backup.ListRestoreJobsInput) backup.ListRestoreJobsRequest

	ListTagsRequest(*backup.ListTagsInput) backup.ListTagsRequest

	PutBackupVaultAccessPolicyRequest(*backup.PutBackupVaultAccessPolicyInput) backup.PutBackupVaultAccessPolicyRequest

	PutBackupVaultNotificationsRequest(*backup.PutBackupVaultNotificationsInput) backup.PutBackupVaultNotificationsRequest

	StartBackupJobRequest(*backup.StartBackupJobInput) backup.StartBackupJobRequest

	StartRestoreJobRequest(*backup.StartRestoreJobInput) backup.StartRestoreJobRequest

	StopBackupJobRequest(*backup.StopBackupJobInput) backup.StopBackupJobRequest

	TagResourceRequest(*backup.TagResourceInput) backup.TagResourceRequest

	UntagResourceRequest(*backup.UntagResourceInput) backup.UntagResourceRequest

	UpdateBackupPlanRequest(*backup.UpdateBackupPlanInput) backup.UpdateBackupPlanRequest

	UpdateRecoveryPointLifecycleRequest(*backup.UpdateRecoveryPointLifecycleInput) backup.UpdateRecoveryPointLifecycleRequest
}

var _ ClientAPI = (*backup.Client)(nil)
