// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the public, private, and shared images to describe.
	Arns []string `type:"list"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The names of the public or private images to describe.
	Names []string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The type of image (public, private, or shared) to describe.
	Type VisibilityType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImagesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeImagesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the images.
	Images []Image `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves a list that describes one or more specified images, if the image
// names or image ARNs are provided. Otherwise, all images in the account are
// described.
//
//    // Example sending a request using DescribeImagesRequest.
//    req := client.DescribeImagesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages
func (c *Client) DescribeImagesRequest(input *DescribeImagesInput) DescribeImagesRequest {
	op := &aws.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	req := c.newRequest(op, input, &DescribeImagesOutput{})
	return DescribeImagesRequest{Request: req, Input: input, Copy: c.DescribeImagesRequest}
}

// DescribeImagesRequest is the request type for the
// DescribeImages API operation.
type DescribeImagesRequest struct {
	*aws.Request
	Input *DescribeImagesInput
	Copy  func(*DescribeImagesInput) DescribeImagesRequest
}

// Send marshals and sends the DescribeImages API request.
func (r DescribeImagesRequest) Send(ctx context.Context) (*DescribeImagesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeImagesResponse{
		DescribeImagesOutput: r.Request.Data.(*DescribeImagesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeImagesRequestPaginator returns a paginator for DescribeImages.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeImagesRequest(input)
//   p := appstream.NewDescribeImagesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeImagesPaginator(req DescribeImagesRequest) DescribeImagesPaginator {
	return DescribeImagesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeImagesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeImagesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeImagesPaginator struct {
	aws.Pager
}

func (p *DescribeImagesPaginator) CurrentPage() *DescribeImagesOutput {
	return p.Pager.CurrentPage().(*DescribeImagesOutput)
}

// DescribeImagesResponse is the response type for the
// DescribeImages API operation.
type DescribeImagesResponse struct {
	*DescribeImagesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeImages request.
func (r *DescribeImagesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
