// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartDataCollectionByAgentIdsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the agents or connectors from which to start collecting data.
	// If you send a request to an agent/connector ID that you do not have permission
	// to contact, according to your AWS account, the service does not throw an
	// exception. Instead, it returns the error in the Description field. If you
	// send a request to multiple agents/connectors and you do not have permission
	// to contact some of those agents/connectors, the system does not throw an
	// exception. Instead, the system shows Failed in the Description field.
	//
	// AgentIds is a required field
	AgentIds []string `locationName:"agentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataCollectionByAgentIdsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartDataCollectionByAgentIdsInput"}

	if s.AgentIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AgentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartDataCollectionByAgentIdsOutput struct {
	_ struct{} `type:"structure"`

	// Information about agents or the connector that were instructed to start collecting
	// data. Information includes the agent/connector ID, a description of the operation
	// performed, and whether the agent/connector configuration was updated.
	AgentsConfigurationStatus []AgentConfigurationStatus `locationName:"agentsConfigurationStatus" type:"list"`
}

// String returns the string representation
func (s StartDataCollectionByAgentIdsOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartDataCollectionByAgentIds = "StartDataCollectionByAgentIds"

// StartDataCollectionByAgentIdsRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Instructs the specified agents or connectors to start collecting data.
//
//    // Example sending a request using StartDataCollectionByAgentIdsRequest.
//    req := client.StartDataCollectionByAgentIdsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartDataCollectionByAgentIds
func (c *Client) StartDataCollectionByAgentIdsRequest(input *StartDataCollectionByAgentIdsInput) StartDataCollectionByAgentIdsRequest {
	op := &aws.Operation{
		Name:       opStartDataCollectionByAgentIds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataCollectionByAgentIdsInput{}
	}

	req := c.newRequest(op, input, &StartDataCollectionByAgentIdsOutput{})
	return StartDataCollectionByAgentIdsRequest{Request: req, Input: input, Copy: c.StartDataCollectionByAgentIdsRequest}
}

// StartDataCollectionByAgentIdsRequest is the request type for the
// StartDataCollectionByAgentIds API operation.
type StartDataCollectionByAgentIdsRequest struct {
	*aws.Request
	Input *StartDataCollectionByAgentIdsInput
	Copy  func(*StartDataCollectionByAgentIdsInput) StartDataCollectionByAgentIdsRequest
}

// Send marshals and sends the StartDataCollectionByAgentIds API request.
func (r StartDataCollectionByAgentIdsRequest) Send(ctx context.Context) (*StartDataCollectionByAgentIdsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartDataCollectionByAgentIdsResponse{
		StartDataCollectionByAgentIdsOutput: r.Request.Data.(*StartDataCollectionByAgentIdsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartDataCollectionByAgentIdsResponse is the response type for the
// StartDataCollectionByAgentIds API operation.
type StartDataCollectionByAgentIdsResponse struct {
	*StartDataCollectionByAgentIdsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartDataCollectionByAgentIds request.
func (r *StartDataCollectionByAgentIdsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
