// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application to be deleted.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApplicationsInput"}

	if s.ConfigurationIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteApplicationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteApplications = "DeleteApplications"

// DeleteApplicationsRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Deletes a list of applications and their associations with configuration
// items.
//
//    // Example sending a request using DeleteApplicationsRequest.
//    req := client.DeleteApplicationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DeleteApplications
func (c *Client) DeleteApplicationsRequest(input *DeleteApplicationsInput) DeleteApplicationsRequest {
	op := &aws.Operation{
		Name:       opDeleteApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationsInput{}
	}

	req := c.newRequest(op, input, &DeleteApplicationsOutput{})
	return DeleteApplicationsRequest{Request: req, Input: input, Copy: c.DeleteApplicationsRequest}
}

// DeleteApplicationsRequest is the request type for the
// DeleteApplications API operation.
type DeleteApplicationsRequest struct {
	*aws.Request
	Input *DeleteApplicationsInput
	Copy  func(*DeleteApplicationsInput) DeleteApplicationsRequest
}

// Send marshals and sends the DeleteApplications API request.
func (r DeleteApplicationsRequest) Send(ctx context.Context) (*DeleteApplicationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApplicationsResponse{
		DeleteApplicationsOutput: r.Request.Data.(*DeleteApplicationsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApplicationsResponse is the response type for the
// DeleteApplications API operation.
type DeleteApplicationsResponse struct {
	*DeleteApplicationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApplications request.
func (r *DeleteApplicationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
