// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request to describe an existing Authorizers resource.
type GetAuthorizersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAuthorizersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAuthorizersInput"}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAuthorizersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a collection of Authorizer resources.
//
// Use Lambda Function as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html)
// Use Cognito User Pool as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html)
type GetAuthorizersOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []Authorizer `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetAuthorizersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAuthorizersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetAuthorizers = "GetAuthorizers"

// GetAuthorizersRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Describe an existing Authorizers resource.
//
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html)
//
//    // Example sending a request using GetAuthorizersRequest.
//    req := client.GetAuthorizersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetAuthorizersRequest(input *GetAuthorizersInput) GetAuthorizersRequest {
	op := &aws.Operation{
		Name:       opGetAuthorizers,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/authorizers",
	}

	if input == nil {
		input = &GetAuthorizersInput{}
	}

	req := c.newRequest(op, input, &GetAuthorizersOutput{})
	return GetAuthorizersRequest{Request: req, Input: input, Copy: c.GetAuthorizersRequest}
}

// GetAuthorizersRequest is the request type for the
// GetAuthorizers API operation.
type GetAuthorizersRequest struct {
	*aws.Request
	Input *GetAuthorizersInput
	Copy  func(*GetAuthorizersInput) GetAuthorizersRequest
}

// Send marshals and sends the GetAuthorizers API request.
func (r GetAuthorizersRequest) Send(ctx context.Context) (*GetAuthorizersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAuthorizersResponse{
		GetAuthorizersOutput: r.Request.Data.(*GetAuthorizersOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAuthorizersResponse is the response type for the
// GetAuthorizers API operation.
type GetAuthorizersResponse struct {
	*GetAuthorizersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAuthorizers request.
func (r *GetAuthorizersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
