// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package acmpcaiface provides an interface to enable mocking the AWS Certificate Manager Private Certificate Authority service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package acmpcaiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/acmpca"
)

// ClientAPI provides an interface to enable mocking the
// acmpca.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // ACM-PCA.
//    func myFunc(svc acmpcaiface.ClientAPI) bool {
//        // Make svc.CreateCertificateAuthority request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := acmpca.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        acmpcaiface.ClientPI
//    }
//    func (m *mockClientClient) CreateCertificateAuthority(input *acmpca.CreateCertificateAuthorityInput) (*acmpca.CreateCertificateAuthorityOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateCertificateAuthorityRequest(*acmpca.CreateCertificateAuthorityInput) acmpca.CreateCertificateAuthorityRequest

	CreateCertificateAuthorityAuditReportRequest(*acmpca.CreateCertificateAuthorityAuditReportInput) acmpca.CreateCertificateAuthorityAuditReportRequest

	CreatePermissionRequest(*acmpca.CreatePermissionInput) acmpca.CreatePermissionRequest

	DeleteCertificateAuthorityRequest(*acmpca.DeleteCertificateAuthorityInput) acmpca.DeleteCertificateAuthorityRequest

	DeletePermissionRequest(*acmpca.DeletePermissionInput) acmpca.DeletePermissionRequest

	DescribeCertificateAuthorityRequest(*acmpca.DescribeCertificateAuthorityInput) acmpca.DescribeCertificateAuthorityRequest

	DescribeCertificateAuthorityAuditReportRequest(*acmpca.DescribeCertificateAuthorityAuditReportInput) acmpca.DescribeCertificateAuthorityAuditReportRequest

	GetCertificateRequest(*acmpca.GetCertificateInput) acmpca.GetCertificateRequest

	GetCertificateAuthorityCertificateRequest(*acmpca.GetCertificateAuthorityCertificateInput) acmpca.GetCertificateAuthorityCertificateRequest

	GetCertificateAuthorityCsrRequest(*acmpca.GetCertificateAuthorityCsrInput) acmpca.GetCertificateAuthorityCsrRequest

	ImportCertificateAuthorityCertificateRequest(*acmpca.ImportCertificateAuthorityCertificateInput) acmpca.ImportCertificateAuthorityCertificateRequest

	IssueCertificateRequest(*acmpca.IssueCertificateInput) acmpca.IssueCertificateRequest

	ListCertificateAuthoritiesRequest(*acmpca.ListCertificateAuthoritiesInput) acmpca.ListCertificateAuthoritiesRequest

	ListPermissionsRequest(*acmpca.ListPermissionsInput) acmpca.ListPermissionsRequest

	ListTagsRequest(*acmpca.ListTagsInput) acmpca.ListTagsRequest

	RestoreCertificateAuthorityRequest(*acmpca.RestoreCertificateAuthorityInput) acmpca.RestoreCertificateAuthorityRequest

	RevokeCertificateRequest(*acmpca.RevokeCertificateInput) acmpca.RevokeCertificateRequest

	TagCertificateAuthorityRequest(*acmpca.TagCertificateAuthorityInput) acmpca.TagCertificateAuthorityRequest

	UntagCertificateAuthorityRequest(*acmpca.UntagCertificateAuthorityInput) acmpca.UntagCertificateAuthorityRequest

	UpdateCertificateAuthorityRequest(*acmpca.UpdateCertificateAuthorityInput) acmpca.UpdateCertificateAuthorityRequest

	WaitUntilAuditReportCreated(context.Context, *acmpca.DescribeCertificateAuthorityAuditReportInput, ...aws.WaiterOption) error

	WaitUntilCertificateAuthorityCSRCreated(context.Context, *acmpca.GetCertificateAuthorityCsrInput, ...aws.WaiterOption) error

	WaitUntilCertificateIssued(context.Context, *acmpca.GetCertificateInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*acmpca.Client)(nil)
