/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package resources

import (
	networkingv1alpha1 "knative.dev/networking/pkg/apis/networking/v1alpha1"
	"knative.dev/pkg/kmeta"
	"knative.dev/serving/pkg/apis/serving"
	"knative.dev/serving/pkg/apis/serving/v1alpha1"
	routeresources "knative.dev/serving/pkg/reconciler/route/resources"
)

// MakeCertificate creates a Certificate for the DomainMapping.
//
// This function delegates entirely to routeresources.MakeCertificate,
// but we keep it here to hide the `certName`, and `dnsName` logic
// from the caller.
func MakeCertificate(dm *v1alpha1.DomainMapping, certClass string) *networkingv1alpha1.Certificate {
	certName := kmeta.ChildName(dm.GetName(), "")
	return routeresources.MakeCertificate(
		dm, serving.DomainMappingUIDLabelKey, dm.Name, certName, certClass)
}
