package secrets

import (
	"testing"
)

func TestSecureStringGenerator(t *testing.T) {
	secretSize := 20
	uniqueSecrets := make(map[string]bool)
	for count := 0; count < 5; count++ {
		secretKey, err := GenerateString(secretSize)
		if len(secretKey) != 20 {
			t.Errorf("The given secret is not of length %v", secretSize)
		}
		if err == nil {
			uniqueSecrets[secretKey] = true
		}
	}
	if l := len(uniqueSecrets); l != 5 {
		t.Errorf("The secrets generated by GenerateString() arent unique, got %d unique secrets", l)
	}
}
