package version100

const JsonSchema100 = `{
    "meta:license": [
        " Copyright (c) 2012-2019 Red Hat, Inc.",
        " This program and the accompanying materials are made",
        " available under the terms of the Eclipse Public License 2.0",
        " which is available at https://www.eclipse.org/legal/epl-2.0/",
        " SPDX-License-Identifier: EPL-2.0",
        " Contributors:",
        " Red Hat, Inc. - initial API and implementation"
    ],
    "$schema": "http://json-schema.org/draft-07/schema#",
    "type": "object",
    "title": "Devfile object",
    "description": "This schema describes the structure of the devfile object",
    "definitions": {
        "attributes": {
            "type": "object",
            "additionalProperties": {
                "type": "string"
            }
        },
        "selector": {
            "type": "object",
            "additionalProperties": {
                "type": "string"
            }
        }
    },
    "required": [
        "apiVersion",
        "metadata"
    ],
    "additionalProperties": false,
    "properties": {
        "apiVersion": {
            "const": "1.0.0",
            "title": "Devfile API Version"
        },
        "metadata": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string",
                    "minLength": 1,
                    "title": "Devfile Name",
                    "description": "The name of the devfile. Workspaces created from devfile, will inherit this name",
                    "examples": [
                        "petclinic-dev-environment"
                    ]
                },
                "generateName": {
                    "type": "string",
                    "minLength": 1,
                    "title": "Devfile Generate Name",
                    "description": "Workspaces created from devfile, will use it as base and append random suffix. It's used when name is not defined.",
                    "examples": [
                        "petclinic-"
                    ]
                }
            },
            "additionalProperties": false,
            "anyOf": [
                {
                    "required": [
                        "name"
                    ]
                },
                {
                    "required": [
                        "generateName"
                    ]
                }
            ]
        },
        "projects": {
            "type": "array",
            "title": "The Projects List",
            "description": "Description of the projects, containing names and sources locations",
            "items": {
                "type": "object",
                "required": [
                    "name",
                    "source"
                ],
                "additionalProperties": false,
                "properties": {
                    "name": {
                        "type": "string",
                        "title": "The Project Name",
                        "examples": [
                            "petclinic"
                        ]
                    },
                    "source": {
                        "type": "object",
                        "title": "The Project Source object",
                        "description": "Describes the project's source - type and location",
                        "required": [
                            "type",
                            "location"
                        ],
                        "properties": {
                            "type": {
                                "type": "string",
                                "description": "Project's source type.",
                                "examples": [
                                    "git",
                                    "github",
                                    "zip"
                                ]
                            },
                            "location": {
                                "type": "string",
                                "description": "Project's source location address. Should be URL for git and github located projects",
                                "examples": [
                                    "git@github.com:spring-projects/spring-petclinic.git"
                                ]
                            },
                            "branch": {
                                "type": "string",
                                "description": "The name of the of the branch to check out after obtaining the source from the location. The branch has to already exist in the source otherwise the default branch is used. In case of git, this is also the name of the remote branch to push to.",
                                "examples": [
                                    "master",
                                    "feature-42"
                                ]
                            },
                            "startPoint": {
                                "type": "string",
                                "description": "The tag or commit id to reset the checked out branch to.",
                                "examples": [
                                    "release/4.2",
                                    "349d3ad",
                                    "v4.2.0"
                                ]
                            },
                            "tag": {
                                "type": "string",
                                "description": "The name of the tag to reset the checked out branch to. Note that this is equivalent to 'startPoint' and provided for convenience.",
                                "examples": [
                                    "v4.2.0"
                                ]
                            },
                            "commitId": {
                                "type": "string",
                                "description": "The id of the commit to reset the checked out branch to. Note that this is equivalent to 'startPoint' and provided for convenience.",
                                "examples": [
                                    "349d3ad"
                                ]
                            },
                            "sparseCheckoutDir": {
                                "type": "string",
                                "description": "Part of project to populate in the working directory.",
                                "examples": [
                                    "/core/",
                                    "core/",
                                    "core",
                                    "/wsmaster/che-core-api-workspace/",
                                    "/d*"
                                ]
                            }
                        }
                    },
                    "clonePath": {
                        "type": "string",
                        "description": "The path relative to the root of the projects to which this project should be cloned into. This is a unix-style relative path (i.e. uses forward slashes). The path is invalid if it is absolute or tries to escape the project root through the usage of '..'. If not specified, defaults to the project name."
                    }
                }
            }
        },
        "components": {
            "type": "array",
            "title": "The Components List",
            "description": "Description of the workspace components, such as editor and plugins",
            "items": {
                "type": "object",
                "required": [
                    "type"
                ],
                "if": {
                    "properties": {
                        "type": {
                            "type": "string"
                        }
                    },
                    "required": [
                        "type"
                    ]
                },
                "then": {
                    "allOf": [
                        {
                            "if": {
                                "properties": {
                                    "type": {
                                        "enum": [
                                            "cheEditor",
                                            "chePlugin"
                                        ]
                                    }
                                }
                            },
                            "then": {
                                "oneOf": [
                                    {
                                        "required": [
                                            "id"
                                        ],
                                        "not": {
                                            "required": [
                                                "reference"
                                            ]
                                        }
                                    },
                                    {
                                        "required": [
                                            "reference"
                                        ],
                                        "not": {
                                            "required": [
                                                "id"
                                            ]
                                        }
                                    }
                                ],
                                "properties": {
                                    "type": {},
                                    "alias": {},
                                    "id": {
                                        "type": "string",
                                        "description": "Describes the component id. It has the following format: {plugin/editor PUBLISHER}/{plugin/editor NAME}/{plugin/editor VERSION}",
                                        "pattern": "[a-z0-9_\\-.]+/[a-z0-9_\\-.]+/[a-z0-9_\\-.]+$",
                                        "examples": [
                                            "eclipse/maven-jdk8/1.0.0"
                                        ]
                                    },
                                    "reference": {
                                        "description": "Describes raw location of plugin yaml file.",
                                        "type": "string",
                                        "examples": [
                                            "https://pastebin.com/raw/kYprWiNB"
                                        ]
                                    },
                                    "registryUrl": {
                                        "description": "Describes URL of custom plugin registry.",
                                        "type": "string",
                                        "pattern": "^(https?://)[a-zA-Z0-9_\\-./]+",
                                        "examples": [
                                            "https://che-plugin-registry.openshift.io/v3/"
                                        ]
                                    },
                                    "memoryLimit": {
                                        "type": "string",
                                        "description": "Describes memory limit for the component. You can express memory as a plain integer or as a fixed-point integer using one of these suffixes: E, P, T, G, M, K. You can also use the power-of-two equivalents: Ei, Pi, Ti, Gi, Mi, Ki",
                                        "examples": [
                                            "128974848",
                                            "129e6",
                                            "129M",
                                            "123Mi"
                                        ]
                                    }
                                }
                            }
                        },
                        {
                            "if": {
                                "properties": {
                                    "type": {
                                        "enum": [
                                            "cheEditor"
                                        ]
                                    }
                                }
                            },
                            "then": {
                                "additionalProperties": false,
                                "properties": {
                                    "type": {},
                                    "alias": {},
                                    "id": {},
                                    "env": {},
                                    "reference": {},
                                    "registryUrl": {},
                                    "memoryLimit": {}
                                }
                            }
                        },
                        {
                            "if": {
                                "properties": {
                                    "type": {
                                        "enum": [
                                            "chePlugin"
                                        ]
                                    }
                                }
                            },
                            "then": {
                                "additionalProperties": false,
                                "properties": {
                                    "type": {},
                                    "alias": {},
                                    "id": {},
                                    "env": {},
                                    "memoryLimit": {},
                                    "reference": {},
                                    "registryUrl": {},
                                    "preferences": {
                                        "type": "object",
                                        "description": "Additional plugin preferences",
                                        "examples": [
                                            "{\"java.home\": \"/home/user/jdk11\", \"java.jdt.ls.vmargs\": \"-Xmx1G\"}"
                                        ],
                                        "additionalProperties": {
                                            "type": [
                                                "boolean",
                                                "string",
                                                "number"
                                            ]
                                        }
                                    }
                                }
                            }
                        },
                        {
                            "if": {
                                "properties": {
                                    "type": {
                                        "enum": [
                                            "kubernetes",
                                            "openshift"
                                        ]
                                    }
                                }
                            },
                            "then": {
                                "anyOf": [
                                    {
                                        "required": [
                                            "reference"
                                        ],
                                        "additionalProperties": true
                                    },
                                    {
                                        "required": [
                                            "referenceContent"
                                        ],
                                        "additionalProperties": true
                                    }
                                ],
                                "additionalProperties": false,
                                "properties": {
                                    "type": {},
                                    "alias": {},
                                    "mountSources": {},
                                    "env": {},
                                    "reference": {
                                        "description": "Describes absolute or devfile-relative location of Kubernetes list yaml file. Applicable only for 'kubernetes' and 'openshift' type components",
                                        "type": "string",
                                        "examples": [
                                            "petclinic-app.yaml"
                                        ]
                                    },
                                    "referenceContent": {
                                        "description": "Inlined content of a file specified in field 'reference'",
                                        "type": "string",
                                        "examples": [
                                            "{\"kind\":\"List\",\"items\":[{\"apiVersion\":\"v1\",\"kind\":\"Pod\",\"metadata\":{\"name\":\"ws\"},\"spec\":{\"containers\":[{\"image\":\"eclipse/che-dev:nightly\"}]}}]}"
                                        ]
                                    },
                                    "selector": {
                                        "$ref": "#/definitions/selector",
                                        "description": "Describes the objects selector for the recipe type components. Allows to pick-up only selected items from k8s/openshift list",
                                        "examples": [
                                            "{\n   \"app.kubernetes.io/name\" : \"mysql\", \n   \"app.kubernetes.io/component\" : \"database\", \n   \"app.kubernetes.io/part-of\" : \"petclinic\" \n}"
                                        ]
                                    },
                                    "entrypoints": {
                                        "type": "array",
                                        "items": {
                                            "type": "object",
                                            "properties": {
                                                "parentName": {
                                                    "type": "string",
                                                    "description": "The name of the top level object in the referenced object list in which to search for containers. If not specified, the objects to search through can have any name."
                                                },
                                                "containerName": {
                                                    "type": "string",
                                                    "description": "The name of the container to apply the entrypoint to. If not specified, the entrypoint is modified on all matching containers."
                                                },
                                                "parentSelector": {
                                                    "$ref": "#/definitions/selector",
                                                    "description": "The selector on labels of the top level objects in the referenced list in which to search for containers. If not specified, the objects to search through can have any labels."
                                                },
                                                "command": {
                                                    "type": "array",
                                                    "items": {
                                                        "type": "string"
                                                    },
                                                    "default": null,
                                                    "description": "The command to run in the component instead of the default one provided in the image of the container. Defaults to null, meaning use whatever is defined in the image.",
                                                    "examples": [
                                                        "['/bin/sh', '-c']"
                                                    ]
                                                },
                                                "args": {
                                                    "type": "array",
                                                    "items": {
                                                        "type": "string"
                                                    },
                                                    "default": null,
                                                    "description": "The arguments to supply to the command running the component. The arguments are supplied either to the default command provided in the image of the container or to the overridden command. Defaults to null, meaning use whatever is defined in the image.",
                                                    "examples": [
                                                        "['-R', '-f']"
                                                    ]
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        },
                        {
                            "if": {
                                "properties": {
                                    "type": {
                                        "enum": [
                                            "dockerimage"
                                        ]
                                    }
                                }
                            },
                            "then": {
                                "required": [
                                    "image",
                                    "memoryLimit"
                                ],
                                "additionalProperties": false,
                                "properties": {
                                    "type": {},
                                    "alias": {},
                                    "mountSources": {},
                                    "env": {},
                                    "image": {
                                        "type": "string",
                                        "description": "Specifies the docker image that should be used for component",
                                        "examples": [
                                            "eclipse/maven-jdk8:1.0.0"
                                        ]
                                    },
                                    "memoryLimit": {
                                        "type": "string",
                                        "description": "Describes memory limit for the component. You can express memory as a plain integer or as a fixed-point integer using one of these suffixes: E, P, T, G, M, K. You can also use the power-of-two equivalents: Ei, Pi, Ti, Gi, Mi, Ki",
                                        "examples": [
                                            "128974848",
                                            "129e6",
                                            "129M",
                                            "123Mi"
                                        ]
                                    },
                                    "command": {
                                        "type": "array",
                                        "items": {
                                            "type": "string"
                                        },
                                        "default": null,
                                        "description": "The command to run in the dockerimage component instead of the default one provided in the image. Defaults to null, meaning use whatever is defined in the image.",
                                        "examples": [
                                            "['/bin/sh', '-c']"
                                        ]
                                    },
                                    "args": {
                                        "type": "array",
                                        "items": {
                                            "type": "string"
                                        },
                                        "default": null,
                                        "description": "The arguments to supply to the command running the dockerimage component. The arguments are supplied either to the default command provided in the image or to the overridden command. Defaults to null, meaning use whatever is defined in the image.",
                                        "examples": [
                                            "['-R', '-f']"
                                        ]
                                    },
                                    "volumes": {
                                        "type": "array",
                                        "description": "Describes volumes which should be mount to component",
                                        "items": {
                                            "type": "object",
                                            "description": "Describe volume that should be mount to component",
                                            "required": [
                                                "name",
                                                "containerPath"
                                            ],
                                            "properties": {
                                                "name": {
                                                    "type": "string",
                                                    "title": "The Volume Name",
                                                    "description": "The volume name. If several components mount the same volume then they will reuse the volume and will be able to access to the same files",
                                                    "examples": [
                                                        "my-data"
                                                    ]
                                                },
                                                "containerPath": {
                                                    "type": "string",
                                                    "title": "The path where volume should be mount to container",
                                                    "examples": [
                                                        "/home/user/data"
                                                    ]
                                                }
                                            }
                                        }
                                    },
                                    "endpoints": {
                                        "type": "array",
                                        "description": "Describes dockerimage component endpoints",
                                        "items": {
                                            "name": "object",
                                            "description": "Describes dockerimage component endpoint",
                                            "required": [
                                                "name",
                                                "port"
                                            ],
                                            "properties": {
                                                "name": {
                                                    "type": "string",
                                                    "title": "The Endpoint Name",
                                                    "description": "The Endpoint name"
                                                },
                                                "port": {
                                                    "type": "integer",
                                                    "title": "The Endpoint Port",
                                                    "description": "The container port that should be used as endpoint"
                                                },
                                                "attributes": {
                                                    "type": "object",
                                                    "public": {
                                                        "type": "boolean",
                                                        "description": "Identifies endpoint as workspace internally or externally accessible.",
                                                        "default": "true"
                                                    },
                                                    "secure": {
                                                        "type": "boolean",
                                                        "description": "Identifies server as secure or non-secure. Requests to secure servers will be authenticated and must contain machine token",
                                                        "default": "false"
                                                    },
                                                    "discoverable": {
                                                        "type": "boolean",
                                                        "description": "Identifies endpoint as accessible by its name.",
                                                        "default": "false"
                                                    },
                                                    "protocol": {
                                                        "type": "boolean",
                                                        "description": "Defines protocol that should be used for communication with endpoint. Is used for endpoint URL evaluation"
                                                    },
                                                    "additionalProperties": {
                                                        "type": "string"
                                                    },
                                                    "javaType": "java.util.Map<String, String>"
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    ]
                },
                "properties": {
                    "alias": {
                        "description": "The name using which other places of this devfile (like commands) can refer to this component. This attribute is optional but must be unique in the devfile if specified.",
                        "type": "string",
                        "examples": [
                            "mvn-stack"
                        ]
                    },
                    "type": {
                        "description": "Describes type of the component, e.g. whether it is an plugin or editor or other type",
                        "enum": [
                            "cheEditor",
                            "chePlugin",
                            "kubernetes",
                            "openshift",
                            "dockerimage"
                        ],
                        "examples": [
                            "chePlugin",
                            "cheEditor",
                            "kubernetes",
                            "openshift",
                            "dockerimage"
                        ]
                    },
                    "mountSources": {
                        "type": "boolean",
                        "description": "Describes whether projects sources should be mount to the component. CHE_PROJECTS_ROOT environment variable should contains a path where projects sources are mount",
                        "default": "false"
                    },
                    "env": {
                        "type": "array",
                        "description": "The environment variables list that should be set to docker container",
                        "items": {
                            "type": "object",
                            "description": "Describes environment variable",
                            "required": [
                                "name",
                                "value"
                            ],
                            "properties": {
                                "name": {
                                    "type": "string",
                                    "title": "The Environment Variable Name",
                                    "description": "The environment variable name"
                                },
                                "value": {
                                    "type": "string",
                                    "title": "The Environment Variable Value",
                                    "description": "The environment variable value"
                                }
                            }
                        }
                    }
                },
                "additionalProperties": true
            }
        },
        "commands": {
            "type": "array",
            "title": "The Commands List",
            "description": "Description of the predefined commands to be available in workspace",
            "items": {
                "type": "object",
                "additionalProperties": false,
                "required": [
                    "name",
                    "actions"
                ],
                "properties": {
                    "name": {
                        "description": "Describes the name of the command. Should be unique per commands set.",
                        "type": "string",
                        "examples": [
                            "build"
                        ]
                    },
                    "attributes": {
                        "description": "Additional command attributes",
                        "$ref": "#/definitions/attributes"
                    },
                    "actions": {
                        "type": "array",
                        "description": "List of the actions of given command. Now the only one command must be specified in list but there are plans to implement supporting multiple actions commands.",
                        "title": "The Command Actions List",
                        "minItems": 1,
                        "maxItems": 1,
                        "items": {
                            "oneOf": [
                                {
                                    "properties": {
                                        "type": {},
                                        "component": {},
                                        "command": {},
                                        "workdir": {}
                                    },
                                    "required": [
                                        "type",
                                        "component",
                                        "command"
                                    ],
                                    "additionalProperties": false
                                },
                                {
                                    "properties": {
                                        "type": {},
                                        "reference": {},
                                        "referenceContent": {}
                                    },
                                    "anyOf": [
                                        {
                                            "required": [
                                                "type",
                                                "reference"
                                            ],
                                            "additionalProperties": true
                                        },
                                        {
                                            "required": [
                                                "type",
                                                "referenceContent"
                                            ],
                                            "additionalProperties": true
                                        }
                                    ],
                                    "additionalProperties": false
                                }
                            ],
                            "type": "object",
                            "properties": {
                                "type": {
                                    "description": "Describes action type",
                                    "type": "string",
                                    "examples": [
                                        "exec"
                                    ]
                                },
                                "component": {
                                    "type": "string",
                                    "description": "Describes component to which given action relates",
                                    "examples": [
                                        "mvn-stack"
                                    ]
                                },
                                "command": {
                                    "type": "string",
                                    "description": "The actual action command-line string",
                                    "examples": [
                                        "mvn package"
                                    ]
                                },
                                "workdir": {
                                    "type": "string",
                                    "description": "Working directory where the command should be executed",
                                    "examples": [
                                        "/projects/spring-petclinic"
                                    ]
                                },
                                "reference": {
                                    "type": "string",
                                    "description": "the path relative to the location of the devfile to the configuration file defining one or more actions in the editor-specific format",
                                    "examples": [
                                        "../ide-config/launch.json"
                                    ]
                                },
                                "referenceContent": {
                                    "type": "string",
                                    "description": "The content of the referenced configuration file that defines one or more actions in the editor-specific format",
                                    "examples": [
                                        "{\"version\": \"2.0.0\",\n    \"tasks\": [\n        {\n            \"type\": \"typescript\",\n            \"tsconfig\": \"tsconfig.json\",\n            \"problemMatcher\": [\n                \"$tsc\"\n            ],\n            \"group\": {\n                \"kind\": \"build\",\n                \"isDefault\": true\n            }\n        }\n    ]}"
                                    ]
                                }
                            }
                        }
                    },
                    "previewUrl": {
                        "type": "object",
                        "required": [
                            "port"
                        ],
                        "properties": {
                            "port": {
                                "type": "number",
                                "minimum": 0,
                                "maximum": 65535
                            },
                            "path": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "attributes": {
            "type": "object",
            "editorFree": {
                "type": "boolean",
                "description": "Defines that no editor is needed and default one should not be provisioned. Defaults to false.",
                "default": "false"
            },
            "persistVolumes": {
                "type": "boolean",
                "description": "Defines whether volumes should be stored or not. Defaults to true. In case of false workspace volumes will be created as emptyDir. The data in the emptyDir volume is deleted forever when a workspace Pod is removed for any reason(pod is crashed, workspace is restarted).",
                "default": "true"
            },
            "additionalProperties": {
                "type": "string"
            },
            "javaType": "java.util.Map<String, String>"
        }
    }
}`
