package securityinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AlertRuleKind enumerates the values for alert rule kind.
type AlertRuleKind string

const (
	// Fusion ...
	Fusion AlertRuleKind = "Fusion"
	// MicrosoftSecurityIncidentCreation ...
	MicrosoftSecurityIncidentCreation AlertRuleKind = "MicrosoftSecurityIncidentCreation"
	// Scheduled ...
	Scheduled AlertRuleKind = "Scheduled"
)

// PossibleAlertRuleKindValues returns an array of possible values for the AlertRuleKind const type.
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return []AlertRuleKind{Fusion, MicrosoftSecurityIncidentCreation, Scheduled}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// High High severity
	High AlertSeverity = "High"
	// Informational Informational severity
	Informational AlertSeverity = "Informational"
	// Low Low severity
	Low AlertSeverity = "Low"
	// Medium Medium severity
	Medium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{High, Informational, Low, Medium}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// AlertStatusDismissed Alert dismissed as false positive
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusInProgress Alert is being handled
	AlertStatusInProgress AlertStatus = "InProgress"
	// AlertStatusNew New alert
	AlertStatusNew AlertStatus = "New"
	// AlertStatusResolved Alert closed after handling
	AlertStatusResolved AlertStatus = "Resolved"
	// AlertStatusUnknown Unknown value
	AlertStatusUnknown AlertStatus = "Unknown"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{AlertStatusDismissed, AlertStatusInProgress, AlertStatusNew, AlertStatusResolved, AlertStatusUnknown}
}

// AttackTactic enumerates the values for attack tactic.
type AttackTactic string

const (
	// Collection ...
	Collection AttackTactic = "Collection"
	// CommandAndControl ...
	CommandAndControl AttackTactic = "CommandAndControl"
	// CredentialAccess ...
	CredentialAccess AttackTactic = "CredentialAccess"
	// DefenseEvasion ...
	DefenseEvasion AttackTactic = "DefenseEvasion"
	// Discovery ...
	Discovery AttackTactic = "Discovery"
	// Execution ...
	Execution AttackTactic = "Execution"
	// Exfiltration ...
	Exfiltration AttackTactic = "Exfiltration"
	// Impact ...
	Impact AttackTactic = "Impact"
	// InitialAccess ...
	InitialAccess AttackTactic = "InitialAccess"
	// LateralMovement ...
	LateralMovement AttackTactic = "LateralMovement"
	// Persistence ...
	Persistence AttackTactic = "Persistence"
	// PreAttack ...
	PreAttack AttackTactic = "PreAttack"
	// PrivilegeEscalation ...
	PrivilegeEscalation AttackTactic = "PrivilegeEscalation"
)

// PossibleAttackTacticValues returns an array of possible values for the AttackTactic const type.
func PossibleAttackTacticValues() []AttackTactic {
	return []AttackTactic{Collection, CommandAndControl, CredentialAccess, DefenseEvasion, Discovery, Execution, Exfiltration, Impact, InitialAccess, LateralMovement, Persistence, PreAttack, PrivilegeEscalation}
}

// CaseSeverity enumerates the values for case severity.
type CaseSeverity string

const (
	// CaseSeverityCritical Critical severity
	CaseSeverityCritical CaseSeverity = "Critical"
	// CaseSeverityHigh High severity
	CaseSeverityHigh CaseSeverity = "High"
	// CaseSeverityInformational Informational severity
	CaseSeverityInformational CaseSeverity = "Informational"
	// CaseSeverityLow Low severity
	CaseSeverityLow CaseSeverity = "Low"
	// CaseSeverityMedium Medium severity
	CaseSeverityMedium CaseSeverity = "Medium"
)

// PossibleCaseSeverityValues returns an array of possible values for the CaseSeverity const type.
func PossibleCaseSeverityValues() []CaseSeverity {
	return []CaseSeverity{CaseSeverityCritical, CaseSeverityHigh, CaseSeverityInformational, CaseSeverityLow, CaseSeverityMedium}
}

// CaseStatus enumerates the values for case status.
type CaseStatus string

const (
	// CaseStatusClosed A non active case
	CaseStatusClosed CaseStatus = "Closed"
	// CaseStatusDraft Case that wasn't promoted yet to active
	CaseStatusDraft CaseStatus = "Draft"
	// CaseStatusInProgress An active case which is handled
	CaseStatusInProgress CaseStatus = "InProgress"
	// CaseStatusNew An active case which isn't handled currently
	CaseStatusNew CaseStatus = "New"
)

// PossibleCaseStatusValues returns an array of possible values for the CaseStatus const type.
func PossibleCaseStatusValues() []CaseStatus {
	return []CaseStatus{CaseStatusClosed, CaseStatusDraft, CaseStatusInProgress, CaseStatusNew}
}

// CloseReason enumerates the values for close reason.
type CloseReason string

const (
	// Dismissed Case was dismissed
	Dismissed CloseReason = "Dismissed"
	// FalsePositive Case was false positive
	FalsePositive CloseReason = "FalsePositive"
	// Other Case was closed for another reason
	Other CloseReason = "Other"
	// Resolved Case was resolved
	Resolved CloseReason = "Resolved"
	// TruePositive Case was true positive
	TruePositive CloseReason = "TruePositive"
)

// PossibleCloseReasonValues returns an array of possible values for the CloseReason const type.
func PossibleCloseReasonValues() []CloseReason {
	return []CloseReason{Dismissed, FalsePositive, Other, Resolved, TruePositive}
}

// ConfidenceLevel enumerates the values for confidence level.
type ConfidenceLevel string

const (
	// ConfidenceLevelHigh High confidence that the alert is true positive malicious
	ConfidenceLevelHigh ConfidenceLevel = "High"
	// ConfidenceLevelLow Low confidence, meaning we have some doubts this is indeed malicious or part of an
	// attack
	ConfidenceLevelLow ConfidenceLevel = "Low"
	// ConfidenceLevelUnknown Unknown confidence, the is the default value
	ConfidenceLevelUnknown ConfidenceLevel = "Unknown"
)

// PossibleConfidenceLevelValues returns an array of possible values for the ConfidenceLevel const type.
func PossibleConfidenceLevelValues() []ConfidenceLevel {
	return []ConfidenceLevel{ConfidenceLevelHigh, ConfidenceLevelLow, ConfidenceLevelUnknown}
}

// ConfidenceScoreStatus enumerates the values for confidence score status.
type ConfidenceScoreStatus string

const (
	// Final Final score was calculated and available
	Final ConfidenceScoreStatus = "Final"
	// InProcess No score was set yet and calculation is in progress
	InProcess ConfidenceScoreStatus = "InProcess"
	// NotApplicable Score will not be calculated for this alert as it is not supported by virtual analyst
	NotApplicable ConfidenceScoreStatus = "NotApplicable"
	// NotFinal Score is calculated and shown as part of the alert, but may be updated again at a later time
	// following the processing of additional data
	NotFinal ConfidenceScoreStatus = "NotFinal"
)

// PossibleConfidenceScoreStatusValues returns an array of possible values for the ConfidenceScoreStatus const type.
func PossibleConfidenceScoreStatusValues() []ConfidenceScoreStatus {
	return []ConfidenceScoreStatus{Final, InProcess, NotApplicable, NotFinal}
}

// DataConnectorAuthorizationState enumerates the values for data connector authorization state.
type DataConnectorAuthorizationState string

const (
	// Invalid ...
	Invalid DataConnectorAuthorizationState = "Invalid"
	// Valid ...
	Valid DataConnectorAuthorizationState = "Valid"
)

// PossibleDataConnectorAuthorizationStateValues returns an array of possible values for the DataConnectorAuthorizationState const type.
func PossibleDataConnectorAuthorizationStateValues() []DataConnectorAuthorizationState {
	return []DataConnectorAuthorizationState{Invalid, Valid}
}

// DataConnectorKind enumerates the values for data connector kind.
type DataConnectorKind string

const (
	// DataConnectorKindAmazonWebServicesCloudTrail ...
	DataConnectorKindAmazonWebServicesCloudTrail DataConnectorKind = "AmazonWebServicesCloudTrail"
	// DataConnectorKindAzureActiveDirectory ...
	DataConnectorKindAzureActiveDirectory DataConnectorKind = "AzureActiveDirectory"
	// DataConnectorKindAzureAdvancedThreatProtection ...
	DataConnectorKindAzureAdvancedThreatProtection DataConnectorKind = "AzureAdvancedThreatProtection"
	// DataConnectorKindAzureSecurityCenter ...
	DataConnectorKindAzureSecurityCenter DataConnectorKind = "AzureSecurityCenter"
	// DataConnectorKindMicrosoftCloudAppSecurity ...
	DataConnectorKindMicrosoftCloudAppSecurity DataConnectorKind = "MicrosoftCloudAppSecurity"
	// DataConnectorKindMicrosoftDefenderAdvancedThreatProtection ...
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = "MicrosoftDefenderAdvancedThreatProtection"
	// DataConnectorKindOffice365 ...
	DataConnectorKindOffice365 DataConnectorKind = "Office365"
	// DataConnectorKindOfficeATP ...
	DataConnectorKindOfficeATP DataConnectorKind = "OfficeATP"
	// DataConnectorKindThreatIntelligence ...
	DataConnectorKindThreatIntelligence DataConnectorKind = "ThreatIntelligence"
	// DataConnectorKindThreatIntelligenceTaxii ...
	DataConnectorKindThreatIntelligenceTaxii DataConnectorKind = "ThreatIntelligenceTaxii"
)

// PossibleDataConnectorKindValues returns an array of possible values for the DataConnectorKind const type.
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return []DataConnectorKind{DataConnectorKindAmazonWebServicesCloudTrail, DataConnectorKindAzureActiveDirectory, DataConnectorKindAzureAdvancedThreatProtection, DataConnectorKindAzureSecurityCenter, DataConnectorKindMicrosoftCloudAppSecurity, DataConnectorKindMicrosoftDefenderAdvancedThreatProtection, DataConnectorKindOffice365, DataConnectorKindOfficeATP, DataConnectorKindThreatIntelligence, DataConnectorKindThreatIntelligenceTaxii}
}

// DataConnectorLicenseState enumerates the values for data connector license state.
type DataConnectorLicenseState string

const (
	// DataConnectorLicenseStateInvalid ...
	DataConnectorLicenseStateInvalid DataConnectorLicenseState = "Invalid"
	// DataConnectorLicenseStateUnknown ...
	DataConnectorLicenseStateUnknown DataConnectorLicenseState = "Unknown"
	// DataConnectorLicenseStateValid ...
	DataConnectorLicenseStateValid DataConnectorLicenseState = "Valid"
)

// PossibleDataConnectorLicenseStateValues returns an array of possible values for the DataConnectorLicenseState const type.
func PossibleDataConnectorLicenseStateValues() []DataConnectorLicenseState {
	return []DataConnectorLicenseState{DataConnectorLicenseStateInvalid, DataConnectorLicenseStateUnknown, DataConnectorLicenseStateValid}
}

// DataTypeState enumerates the values for data type state.
type DataTypeState string

const (
	// Disabled ...
	Disabled DataTypeState = "Disabled"
	// Enabled ...
	Enabled DataTypeState = "Enabled"
)

// PossibleDataTypeStateValues returns an array of possible values for the DataTypeState const type.
func PossibleDataTypeStateValues() []DataTypeState {
	return []DataTypeState{Disabled, Enabled}
}

// ElevationToken enumerates the values for elevation token.
type ElevationToken string

const (
	// Default Default elevation token
	Default ElevationToken = "Default"
	// Full Full elevation token
	Full ElevationToken = "Full"
	// Limited Limited elevation token
	Limited ElevationToken = "Limited"
)

// PossibleElevationTokenValues returns an array of possible values for the ElevationToken const type.
func PossibleElevationTokenValues() []ElevationToken {
	return []ElevationToken{Default, Full, Limited}
}

// EntitiesMatchingMethod enumerates the values for entities matching method.
type EntitiesMatchingMethod string

const (
	// All Grouping alerts into a single incident if all the entities match
	All EntitiesMatchingMethod = "All"
	// Custom Grouping alerts into a single incident if the selected entities match
	Custom EntitiesMatchingMethod = "Custom"
	// None Grouping all alerts triggered by this rule into a single incident
	None EntitiesMatchingMethod = "None"
)

// PossibleEntitiesMatchingMethodValues returns an array of possible values for the EntitiesMatchingMethod const type.
func PossibleEntitiesMatchingMethodValues() []EntitiesMatchingMethod {
	return []EntitiesMatchingMethod{All, Custom, None}
}

// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// EntityKindAccount Entity represents account in the system.
	EntityKindAccount EntityKind = "Account"
	// EntityKindAzureResource Entity represents azure resource in the system.
	EntityKindAzureResource EntityKind = "AzureResource"
	// EntityKindBookmark Entity represents bookmark in the system.
	EntityKindBookmark EntityKind = "Bookmark"
	// EntityKindCloudApplication Entity represents cloud application in the system.
	EntityKindCloudApplication EntityKind = "CloudApplication"
	// EntityKindDNSResolution Entity represents dns resolution in the system.
	EntityKindDNSResolution EntityKind = "DnsResolution"
	// EntityKindFile Entity represents file in the system.
	EntityKindFile EntityKind = "File"
	// EntityKindFileHash Entity represents file hash in the system.
	EntityKindFileHash EntityKind = "FileHash"
	// EntityKindHost Entity represents host in the system.
	EntityKindHost EntityKind = "Host"
	// EntityKindIoTDevice Entity represents IoT device in the system.
	EntityKindIoTDevice EntityKind = "IoTDevice"
	// EntityKindIP Entity represents ip in the system.
	EntityKindIP EntityKind = "Ip"
	// EntityKindMalware Entity represents malware in the system.
	EntityKindMalware EntityKind = "Malware"
	// EntityKindProcess Entity represents process in the system.
	EntityKindProcess EntityKind = "Process"
	// EntityKindRegistryKey Entity represents registry key in the system.
	EntityKindRegistryKey EntityKind = "RegistryKey"
	// EntityKindRegistryValue Entity represents registry value in the system.
	EntityKindRegistryValue EntityKind = "RegistryValue"
	// EntityKindSecurityAlert Entity represents security alert in the system.
	EntityKindSecurityAlert EntityKind = "SecurityAlert"
	// EntityKindSecurityGroup Entity represents security group in the system.
	EntityKindSecurityGroup EntityKind = "SecurityGroup"
	// EntityKindURL Entity represents url in the system.
	EntityKindURL EntityKind = "Url"
)

// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{EntityKindAccount, EntityKindAzureResource, EntityKindBookmark, EntityKindCloudApplication, EntityKindDNSResolution, EntityKindFile, EntityKindFileHash, EntityKindHost, EntityKindIoTDevice, EntityKindIP, EntityKindMalware, EntityKindProcess, EntityKindRegistryKey, EntityKindRegistryValue, EntityKindSecurityAlert, EntityKindSecurityGroup, EntityKindURL}
}

// EntityTimelineKind enumerates the values for entity timeline kind.
type EntityTimelineKind string

const (
	// EntityTimelineKindActivity activity
	EntityTimelineKindActivity EntityTimelineKind = "Activity"
	// EntityTimelineKindBookmark bookmarks
	EntityTimelineKindBookmark EntityTimelineKind = "Bookmark"
	// EntityTimelineKindSecurityAlert security alerts
	EntityTimelineKindSecurityAlert EntityTimelineKind = "SecurityAlert"
)

// PossibleEntityTimelineKindValues returns an array of possible values for the EntityTimelineKind const type.
func PossibleEntityTimelineKindValues() []EntityTimelineKind {
	return []EntityTimelineKind{EntityTimelineKindActivity, EntityTimelineKindBookmark, EntityTimelineKindSecurityAlert}
}

// EntityType enumerates the values for entity type.
type EntityType string

const (
	// EntityTypeAccount Entity represents account in the system.
	EntityTypeAccount EntityType = "Account"
	// EntityTypeAzureResource Entity represents azure resource in the system.
	EntityTypeAzureResource EntityType = "AzureResource"
	// EntityTypeCloudApplication Entity represents cloud application in the system.
	EntityTypeCloudApplication EntityType = "CloudApplication"
	// EntityTypeDNS Entity represents dns in the system.
	EntityTypeDNS EntityType = "DNS"
	// EntityTypeFile Entity represents file in the system.
	EntityTypeFile EntityType = "File"
	// EntityTypeFileHash Entity represents file hash in the system.
	EntityTypeFileHash EntityType = "FileHash"
	// EntityTypeHost Entity represents host in the system.
	EntityTypeHost EntityType = "Host"
	// EntityTypeHuntingBookmark Entity represents HuntingBookmark in the system.
	EntityTypeHuntingBookmark EntityType = "HuntingBookmark"
	// EntityTypeIoTDevice Entity represents IoT device in the system.
	EntityTypeIoTDevice EntityType = "IoTDevice"
	// EntityTypeIP Entity represents ip in the system.
	EntityTypeIP EntityType = "IP"
	// EntityTypeMalware Entity represents malware in the system.
	EntityTypeMalware EntityType = "Malware"
	// EntityTypeProcess Entity represents process in the system.
	EntityTypeProcess EntityType = "Process"
	// EntityTypeRegistryKey Entity represents registry key in the system.
	EntityTypeRegistryKey EntityType = "RegistryKey"
	// EntityTypeRegistryValue Entity represents registry value in the system.
	EntityTypeRegistryValue EntityType = "RegistryValue"
	// EntityTypeSecurityAlert Entity represents security alert in the system.
	EntityTypeSecurityAlert EntityType = "SecurityAlert"
	// EntityTypeSecurityGroup Entity represents security group in the system.
	EntityTypeSecurityGroup EntityType = "SecurityGroup"
	// EntityTypeURL Entity represents url in the system.
	EntityTypeURL EntityType = "URL"
)

// PossibleEntityTypeValues returns an array of possible values for the EntityType const type.
func PossibleEntityTypeValues() []EntityType {
	return []EntityType{EntityTypeAccount, EntityTypeAzureResource, EntityTypeCloudApplication, EntityTypeDNS, EntityTypeFile, EntityTypeFileHash, EntityTypeHost, EntityTypeHuntingBookmark, EntityTypeIoTDevice, EntityTypeIP, EntityTypeMalware, EntityTypeProcess, EntityTypeRegistryKey, EntityTypeRegistryValue, EntityTypeSecurityAlert, EntityTypeSecurityGroup, EntityTypeURL}
}

// EventGroupingAggregationKind enumerates the values for event grouping aggregation kind.
type EventGroupingAggregationKind string

const (
	// AlertPerResult ...
	AlertPerResult EventGroupingAggregationKind = "AlertPerResult"
	// SingleAlert ...
	SingleAlert EventGroupingAggregationKind = "SingleAlert"
)

// PossibleEventGroupingAggregationKindValues returns an array of possible values for the EventGroupingAggregationKind const type.
func PossibleEventGroupingAggregationKindValues() []EventGroupingAggregationKind {
	return []EventGroupingAggregationKind{AlertPerResult, SingleAlert}
}

// FileHashAlgorithm enumerates the values for file hash algorithm.
type FileHashAlgorithm string

const (
	// MD5 MD5 hash type
	MD5 FileHashAlgorithm = "MD5"
	// SHA1 SHA1 hash type
	SHA1 FileHashAlgorithm = "SHA1"
	// SHA256 SHA256 hash type
	SHA256 FileHashAlgorithm = "SHA256"
	// SHA256AC SHA256 Authenticode hash type
	SHA256AC FileHashAlgorithm = "SHA256AC"
	// Unknown Unknown hash algorithm
	Unknown FileHashAlgorithm = "Unknown"
)

// PossibleFileHashAlgorithmValues returns an array of possible values for the FileHashAlgorithm const type.
func PossibleFileHashAlgorithmValues() []FileHashAlgorithm {
	return []FileHashAlgorithm{MD5, SHA1, SHA256, SHA256AC, Unknown}
}

// GroupingEntityType enumerates the values for grouping entity type.
type GroupingEntityType string

const (
	// Account Account entity
	Account GroupingEntityType = "Account"
	// Host Host entity
	Host GroupingEntityType = "Host"
	// IP Ip entity
	IP GroupingEntityType = "Ip"
	// URL Url entity
	URL GroupingEntityType = "Url"
)

// PossibleGroupingEntityTypeValues returns an array of possible values for the GroupingEntityType const type.
func PossibleGroupingEntityTypeValues() []GroupingEntityType {
	return []GroupingEntityType{Account, Host, IP, URL}
}

// IncidentClassification enumerates the values for incident classification.
type IncidentClassification string

const (
	// IncidentClassificationBenignPositive Incident was benign positive
	IncidentClassificationBenignPositive IncidentClassification = "BenignPositive"
	// IncidentClassificationFalsePositive Incident was false positive
	IncidentClassificationFalsePositive IncidentClassification = "FalsePositive"
	// IncidentClassificationTruePositive Incident was true positive
	IncidentClassificationTruePositive IncidentClassification = "TruePositive"
	// IncidentClassificationUndetermined Incident classification was undetermined
	IncidentClassificationUndetermined IncidentClassification = "Undetermined"
)

// PossibleIncidentClassificationValues returns an array of possible values for the IncidentClassification const type.
func PossibleIncidentClassificationValues() []IncidentClassification {
	return []IncidentClassification{IncidentClassificationBenignPositive, IncidentClassificationFalsePositive, IncidentClassificationTruePositive, IncidentClassificationUndetermined}
}

// IncidentClassificationReason enumerates the values for incident classification reason.
type IncidentClassificationReason string

const (
	// InaccurateData Classification reason was inaccurate data
	InaccurateData IncidentClassificationReason = "InaccurateData"
	// IncorrectAlertLogic Classification reason was incorrect alert logic
	IncorrectAlertLogic IncidentClassificationReason = "IncorrectAlertLogic"
	// SuspiciousActivity Classification reason was suspicious activity
	SuspiciousActivity IncidentClassificationReason = "SuspiciousActivity"
	// SuspiciousButExpected Classification reason was suspicious but expected
	SuspiciousButExpected IncidentClassificationReason = "SuspiciousButExpected"
)

// PossibleIncidentClassificationReasonValues returns an array of possible values for the IncidentClassificationReason const type.
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return []IncidentClassificationReason{InaccurateData, IncorrectAlertLogic, SuspiciousActivity, SuspiciousButExpected}
}

// IncidentLabelType enumerates the values for incident label type.
type IncidentLabelType string

const (
	// System Label automatically created by the system
	System IncidentLabelType = "System"
	// User Label manually created by a user
	User IncidentLabelType = "User"
)

// PossibleIncidentLabelTypeValues returns an array of possible values for the IncidentLabelType const type.
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return []IncidentLabelType{System, User}
}

// IncidentSeverity enumerates the values for incident severity.
type IncidentSeverity string

const (
	// IncidentSeverityHigh High severity
	IncidentSeverityHigh IncidentSeverity = "High"
	// IncidentSeverityInformational Informational severity
	IncidentSeverityInformational IncidentSeverity = "Informational"
	// IncidentSeverityLow Low severity
	IncidentSeverityLow IncidentSeverity = "Low"
	// IncidentSeverityMedium Medium severity
	IncidentSeverityMedium IncidentSeverity = "Medium"
)

// PossibleIncidentSeverityValues returns an array of possible values for the IncidentSeverity const type.
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return []IncidentSeverity{IncidentSeverityHigh, IncidentSeverityInformational, IncidentSeverityLow, IncidentSeverityMedium}
}

// IncidentStatus enumerates the values for incident status.
type IncidentStatus string

const (
	// IncidentStatusActive An active incident which is being handled
	IncidentStatusActive IncidentStatus = "Active"
	// IncidentStatusClosed A non-active incident
	IncidentStatusClosed IncidentStatus = "Closed"
	// IncidentStatusNew An active incident which isn't being handled currently
	IncidentStatusNew IncidentStatus = "New"
)

// PossibleIncidentStatusValues returns an array of possible values for the IncidentStatus const type.
func PossibleIncidentStatusValues() []IncidentStatus {
	return []IncidentStatus{IncidentStatusActive, IncidentStatusClosed, IncidentStatusNew}
}

// KillChainIntent enumerates the values for kill chain intent.
type KillChainIntent string

const (
	// KillChainIntentCollection Collection consists of techniques used to identify and gather information,
	// such as sensitive files, from a target network prior to exfiltration. This category also covers
	// locations on a system or network where the adversary may look for information to exfiltrate.
	KillChainIntentCollection KillChainIntent = "Collection"
	// KillChainIntentCommandAndControl The command and control tactic represents how adversaries communicate
	// with systems under their control within a target network.
	KillChainIntentCommandAndControl KillChainIntent = "CommandAndControl"
	// KillChainIntentCredentialAccess Credential access represents techniques resulting in access to or
	// control over system, domain, or service credentials that are used within an enterprise environment.
	// Adversaries will likely attempt to obtain legitimate credentials from users or administrator accounts
	// (local system administrator or domain users with administrator access) to use within the network. With
	// sufficient access within a network, an adversary can create accounts for later use within the
	// environment.
	KillChainIntentCredentialAccess KillChainIntent = "CredentialAccess"
	// KillChainIntentDefenseEvasion Defense evasion consists of techniques an adversary may use to evade
	// detection or avoid other defenses. Sometimes these actions are the same as or variations of techniques
	// in other categories that have the added benefit of subverting a particular defense or mitigation.
	KillChainIntentDefenseEvasion KillChainIntent = "DefenseEvasion"
	// KillChainIntentDiscovery Discovery consists of techniques that allow the adversary to gain knowledge
	// about the system and internal network. When adversaries gain access to a new system, they must orient
	// themselves to what they now have control of and what benefits operating from that system give to their
	// current objective or overall goals during the intrusion. The operating system provides many native tools
	// that aid in this post-compromise information-gathering phase.
	KillChainIntentDiscovery KillChainIntent = "Discovery"
	// KillChainIntentExecution The execution tactic represents techniques that result in execution of
	// adversary-controlled code on a local or remote system. This tactic is often used in conjunction with
	// lateral movement to expand access to remote systems on a network.
	KillChainIntentExecution KillChainIntent = "Execution"
	// KillChainIntentExfiltration Exfiltration refers to techniques and attributes that result or aid in the
	// adversary removing files and information from a target network. This category also covers locations on a
	// system or network where the adversary may look for information to exfiltrate.
	KillChainIntentExfiltration KillChainIntent = "Exfiltration"
	// KillChainIntentExploitation Exploitation is the stage where an attacker manage to get foothold on the
	// attacked resource. This stage is applicable not only for compute hosts, but also for resources such as
	// user accounts, certificates etc. Adversaries will often be able to control the resource after this
	// stage.
	KillChainIntentExploitation KillChainIntent = "Exploitation"
	// KillChainIntentImpact The impact intent primary objective is to directly reduce the availability or
	// integrity of a system, service, or network; including manipulation of data to impact a business or
	// operational process. This would often refer to techniques such as ransom-ware, defacement, data
	// manipulation and others.
	KillChainIntentImpact KillChainIntent = "Impact"
	// KillChainIntentLateralMovement Lateral movement consists of techniques that enable an adversary to
	// access and control remote systems on a network and could, but does not necessarily, include execution of
	// tools on remote systems. The lateral movement techniques could allow an adversary to gather information
	// from a system without needing additional tools, such as a remote access tool. An adversary can use
	// lateral movement for many purposes, including remote Execution of tools, pivoting to additional systems,
	// access to specific information or files, access to additional credentials, or to cause an effect.
	KillChainIntentLateralMovement KillChainIntent = "LateralMovement"
	// KillChainIntentPersistence Persistence is any access, action, or configuration change to a system that
	// gives an adversary a persistent presence on that system. Adversaries will often need to maintain access
	// to systems through interruptions such as system restarts, loss of credentials, or other failures that
	// would require a remote access tool to restart or alternate backdoor for them to regain access.
	KillChainIntentPersistence KillChainIntent = "Persistence"
	// KillChainIntentPrivilegeEscalation Privilege escalation is the result of actions that allow an adversary
	// to obtain a higher level of permissions on a system or network. Certain tools or actions require a
	// higher level of privilege to work and are likely necessary at many points throughout an operation. User
	// accounts with permissions to access specific systems or perform specific functions necessary for
	// adversaries to achieve their objective may also be considered an escalation of privilege.
	KillChainIntentPrivilegeEscalation KillChainIntent = "PrivilegeEscalation"
	// KillChainIntentProbing Probing could be an attempt to access a certain resource regardless of a
	// malicious intent or a failed attempt to gain access to a target system to gather information prior to
	// exploitation. This step is usually detected as an attempt originating from outside the network in
	// attempt to scan the target system and find a way in.
	KillChainIntentProbing KillChainIntent = "Probing"
	// KillChainIntentUnknown The default value.
	KillChainIntentUnknown KillChainIntent = "Unknown"
)

// PossibleKillChainIntentValues returns an array of possible values for the KillChainIntent const type.
func PossibleKillChainIntentValues() []KillChainIntent {
	return []KillChainIntent{KillChainIntentCollection, KillChainIntentCommandAndControl, KillChainIntentCredentialAccess, KillChainIntentDefenseEvasion, KillChainIntentDiscovery, KillChainIntentExecution, KillChainIntentExfiltration, KillChainIntentExploitation, KillChainIntentImpact, KillChainIntentLateralMovement, KillChainIntentPersistence, KillChainIntentPrivilegeEscalation, KillChainIntentProbing, KillChainIntentUnknown}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindAggregations ...
	KindAggregations Kind = "Aggregations"
	// KindCasesAggregation ...
	KindCasesAggregation Kind = "CasesAggregation"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindAggregations, KindCasesAggregation}
}

// KindBasicAlertRule enumerates the values for kind basic alert rule.
type KindBasicAlertRule string

const (
	// KindAlertRule ...
	KindAlertRule KindBasicAlertRule = "AlertRule"
	// KindFusion ...
	KindFusion KindBasicAlertRule = "Fusion"
	// KindMicrosoftSecurityIncidentCreation ...
	KindMicrosoftSecurityIncidentCreation KindBasicAlertRule = "MicrosoftSecurityIncidentCreation"
	// KindScheduled ...
	KindScheduled KindBasicAlertRule = "Scheduled"
)

// PossibleKindBasicAlertRuleValues returns an array of possible values for the KindBasicAlertRule const type.
func PossibleKindBasicAlertRuleValues() []KindBasicAlertRule {
	return []KindBasicAlertRule{KindAlertRule, KindFusion, KindMicrosoftSecurityIncidentCreation, KindScheduled}
}

// KindBasicAlertRuleTemplate enumerates the values for kind basic alert rule template.
type KindBasicAlertRuleTemplate string

const (
	// KindBasicAlertRuleTemplateKindAlertRuleTemplate ...
	KindBasicAlertRuleTemplateKindAlertRuleTemplate KindBasicAlertRuleTemplate = "AlertRuleTemplate"
	// KindBasicAlertRuleTemplateKindFusion ...
	KindBasicAlertRuleTemplateKindFusion KindBasicAlertRuleTemplate = "Fusion"
	// KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation ...
	KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation KindBasicAlertRuleTemplate = "MicrosoftSecurityIncidentCreation"
	// KindBasicAlertRuleTemplateKindScheduled ...
	KindBasicAlertRuleTemplateKindScheduled KindBasicAlertRuleTemplate = "Scheduled"
)

// PossibleKindBasicAlertRuleTemplateValues returns an array of possible values for the KindBasicAlertRuleTemplate const type.
func PossibleKindBasicAlertRuleTemplateValues() []KindBasicAlertRuleTemplate {
	return []KindBasicAlertRuleTemplate{KindBasicAlertRuleTemplateKindAlertRuleTemplate, KindBasicAlertRuleTemplateKindFusion, KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation, KindBasicAlertRuleTemplateKindScheduled}
}

// KindBasicDataConnector enumerates the values for kind basic data connector.
type KindBasicDataConnector string

const (
	// KindAmazonWebServicesCloudTrail ...
	KindAmazonWebServicesCloudTrail KindBasicDataConnector = "AmazonWebServicesCloudTrail"
	// KindAzureActiveDirectory ...
	KindAzureActiveDirectory KindBasicDataConnector = "AzureActiveDirectory"
	// KindAzureAdvancedThreatProtection ...
	KindAzureAdvancedThreatProtection KindBasicDataConnector = "AzureAdvancedThreatProtection"
	// KindAzureSecurityCenter ...
	KindAzureSecurityCenter KindBasicDataConnector = "AzureSecurityCenter"
	// KindDataConnector ...
	KindDataConnector KindBasicDataConnector = "DataConnector"
	// KindMicrosoftCloudAppSecurity ...
	KindMicrosoftCloudAppSecurity KindBasicDataConnector = "MicrosoftCloudAppSecurity"
	// KindMicrosoftDefenderAdvancedThreatProtection ...
	KindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnector = "MicrosoftDefenderAdvancedThreatProtection"
	// KindOffice365 ...
	KindOffice365 KindBasicDataConnector = "Office365"
	// KindOfficeATP ...
	KindOfficeATP KindBasicDataConnector = "OfficeATP"
	// KindThreatIntelligence ...
	KindThreatIntelligence KindBasicDataConnector = "ThreatIntelligence"
	// KindThreatIntelligenceTaxii ...
	KindThreatIntelligenceTaxii KindBasicDataConnector = "ThreatIntelligenceTaxii"
)

// PossibleKindBasicDataConnectorValues returns an array of possible values for the KindBasicDataConnector const type.
func PossibleKindBasicDataConnectorValues() []KindBasicDataConnector {
	return []KindBasicDataConnector{KindAmazonWebServicesCloudTrail, KindAzureActiveDirectory, KindAzureAdvancedThreatProtection, KindAzureSecurityCenter, KindDataConnector, KindMicrosoftCloudAppSecurity, KindMicrosoftDefenderAdvancedThreatProtection, KindOffice365, KindOfficeATP, KindThreatIntelligence, KindThreatIntelligenceTaxii}
}

// KindBasicDataConnectorsCheckRequirements enumerates the values for kind basic data connectors check
// requirements.
type KindBasicDataConnectorsCheckRequirements string

const (
	// KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail ...
	KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail KindBasicDataConnectorsCheckRequirements = "AmazonWebServicesCloudTrail"
	// KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory ...
	KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory KindBasicDataConnectorsCheckRequirements = "AzureActiveDirectory"
	// KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection ...
	KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = "AzureAdvancedThreatProtection"
	// KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter ...
	KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter KindBasicDataConnectorsCheckRequirements = "AzureSecurityCenter"
	// KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements ...
	KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements KindBasicDataConnectorsCheckRequirements = "DataConnectorsCheckRequirements"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity KindBasicDataConnectorsCheckRequirements = "MicrosoftCloudAppSecurity"
	// KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection ...
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = "MicrosoftDefenderAdvancedThreatProtection"
	// KindBasicDataConnectorsCheckRequirementsKindOfficeATP ...
	KindBasicDataConnectorsCheckRequirementsKindOfficeATP KindBasicDataConnectorsCheckRequirements = "OfficeATP"
	// KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence ...
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence KindBasicDataConnectorsCheckRequirements = "ThreatIntelligence"
	// KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii ...
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii KindBasicDataConnectorsCheckRequirements = "ThreatIntelligenceTaxii"
)

// PossibleKindBasicDataConnectorsCheckRequirementsValues returns an array of possible values for the KindBasicDataConnectorsCheckRequirements const type.
func PossibleKindBasicDataConnectorsCheckRequirementsValues() []KindBasicDataConnectorsCheckRequirements {
	return []KindBasicDataConnectorsCheckRequirements{KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail, KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory, KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection, KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter, KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements, KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity, KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection, KindBasicDataConnectorsCheckRequirementsKindOfficeATP, KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence, KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii}
}

// KindBasicEntity enumerates the values for kind basic entity.
type KindBasicEntity string

const (
	// KindAccount ...
	KindAccount KindBasicEntity = "Account"
	// KindAzureResource ...
	KindAzureResource KindBasicEntity = "AzureResource"
	// KindBookmark ...
	KindBookmark KindBasicEntity = "Bookmark"
	// KindCloudApplication ...
	KindCloudApplication KindBasicEntity = "CloudApplication"
	// KindDNSResolution ...
	KindDNSResolution KindBasicEntity = "DnsResolution"
	// KindEntity ...
	KindEntity KindBasicEntity = "Entity"
	// KindFile ...
	KindFile KindBasicEntity = "File"
	// KindFileHash ...
	KindFileHash KindBasicEntity = "FileHash"
	// KindHost ...
	KindHost KindBasicEntity = "Host"
	// KindIoTDevice ...
	KindIoTDevice KindBasicEntity = "IoTDevice"
	// KindIP ...
	KindIP KindBasicEntity = "Ip"
	// KindMalware ...
	KindMalware KindBasicEntity = "Malware"
	// KindProcess ...
	KindProcess KindBasicEntity = "Process"
	// KindRegistryKey ...
	KindRegistryKey KindBasicEntity = "RegistryKey"
	// KindRegistryValue ...
	KindRegistryValue KindBasicEntity = "RegistryValue"
	// KindSecurityAlert ...
	KindSecurityAlert KindBasicEntity = "SecurityAlert"
	// KindSecurityGroup ...
	KindSecurityGroup KindBasicEntity = "SecurityGroup"
	// KindURL ...
	KindURL KindBasicEntity = "Url"
)

// PossibleKindBasicEntityValues returns an array of possible values for the KindBasicEntity const type.
func PossibleKindBasicEntityValues() []KindBasicEntity {
	return []KindBasicEntity{KindAccount, KindAzureResource, KindBookmark, KindCloudApplication, KindDNSResolution, KindEntity, KindFile, KindFileHash, KindHost, KindIoTDevice, KindIP, KindMalware, KindProcess, KindRegistryKey, KindRegistryValue, KindSecurityAlert, KindSecurityGroup, KindURL}
}

// KindBasicEntityTimelineItem enumerates the values for kind basic entity timeline item.
type KindBasicEntityTimelineItem string

const (
	// KindBasicEntityTimelineItemKindActivity ...
	KindBasicEntityTimelineItemKindActivity KindBasicEntityTimelineItem = "Activity"
	// KindBasicEntityTimelineItemKindBookmark ...
	KindBasicEntityTimelineItemKindBookmark KindBasicEntityTimelineItem = "Bookmark"
	// KindBasicEntityTimelineItemKindEntityTimelineItem ...
	KindBasicEntityTimelineItemKindEntityTimelineItem KindBasicEntityTimelineItem = "EntityTimelineItem"
	// KindBasicEntityTimelineItemKindSecurityAlert ...
	KindBasicEntityTimelineItemKindSecurityAlert KindBasicEntityTimelineItem = "SecurityAlert"
)

// PossibleKindBasicEntityTimelineItemValues returns an array of possible values for the KindBasicEntityTimelineItem const type.
func PossibleKindBasicEntityTimelineItemValues() []KindBasicEntityTimelineItem {
	return []KindBasicEntityTimelineItem{KindBasicEntityTimelineItemKindActivity, KindBasicEntityTimelineItemKindBookmark, KindBasicEntityTimelineItemKindEntityTimelineItem, KindBasicEntityTimelineItemKindSecurityAlert}
}

// KindBasicSettings enumerates the values for kind basic settings.
type KindBasicSettings string

const (
	// KindEntityAnalytics ...
	KindEntityAnalytics KindBasicSettings = "EntityAnalytics"
	// KindEyesOn ...
	KindEyesOn KindBasicSettings = "EyesOn"
	// KindSettings ...
	KindSettings KindBasicSettings = "Settings"
	// KindUeba ...
	KindUeba KindBasicSettings = "Ueba"
)

// PossibleKindBasicSettingsValues returns an array of possible values for the KindBasicSettings const type.
func PossibleKindBasicSettingsValues() []KindBasicSettings {
	return []KindBasicSettings{KindEntityAnalytics, KindEyesOn, KindSettings, KindUeba}
}

// KindBasicThreatIntelligenceInformation enumerates the values for kind basic threat intelligence information.
type KindBasicThreatIntelligenceInformation string

const (
	// KindIndicator ...
	KindIndicator KindBasicThreatIntelligenceInformation = "indicator"
	// KindThreatIntelligenceInformation ...
	KindThreatIntelligenceInformation KindBasicThreatIntelligenceInformation = "ThreatIntelligenceInformation"
)

// PossibleKindBasicThreatIntelligenceInformationValues returns an array of possible values for the KindBasicThreatIntelligenceInformation const type.
func PossibleKindBasicThreatIntelligenceInformationValues() []KindBasicThreatIntelligenceInformation {
	return []KindBasicThreatIntelligenceInformation{KindIndicator, KindThreatIntelligenceInformation}
}

// MicrosoftSecurityProductName enumerates the values for microsoft security product name.
type MicrosoftSecurityProductName string

const (
	// AzureActiveDirectoryIdentityProtection ...
	AzureActiveDirectoryIdentityProtection MicrosoftSecurityProductName = "Azure Active Directory Identity Protection"
	// AzureAdvancedThreatProtection ...
	AzureAdvancedThreatProtection MicrosoftSecurityProductName = "Azure Advanced Threat Protection"
	// AzureSecurityCenter ...
	AzureSecurityCenter MicrosoftSecurityProductName = "Azure Security Center"
	// AzureSecurityCenterforIoT ...
	AzureSecurityCenterforIoT MicrosoftSecurityProductName = "Azure Security Center for IoT"
	// MicrosoftCloudAppSecurity ...
	MicrosoftCloudAppSecurity MicrosoftSecurityProductName = "Microsoft Cloud App Security"
	// MicrosoftDefenderAdvancedThreatProtection ...
	MicrosoftDefenderAdvancedThreatProtection MicrosoftSecurityProductName = "Microsoft Defender Advanced Threat Protection"
	// Office365AdvancedThreatProtection ...
	Office365AdvancedThreatProtection MicrosoftSecurityProductName = "Office 365 Advanced Threat Protection"
)

// PossibleMicrosoftSecurityProductNameValues returns an array of possible values for the MicrosoftSecurityProductName const type.
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return []MicrosoftSecurityProductName{AzureActiveDirectoryIdentityProtection, AzureAdvancedThreatProtection, AzureSecurityCenter, AzureSecurityCenterforIoT, MicrosoftCloudAppSecurity, MicrosoftDefenderAdvancedThreatProtection, Office365AdvancedThreatProtection}
}

// OSFamily enumerates the values for os family.
type OSFamily string

const (
	// Android Host with Android operating system.
	Android OSFamily = "Android"
	// IOS Host with IOS operating system.
	IOS OSFamily = "IOS"
	// Linux Host with Linux operating system.
	Linux OSFamily = "Linux"
	// Windows Host with Windows operating system.
	Windows OSFamily = "Windows"
)

// PossibleOSFamilyValues returns an array of possible values for the OSFamily const type.
func PossibleOSFamilyValues() []OSFamily {
	return []OSFamily{Android, IOS, Linux, Windows}
}

// RegistryHive enumerates the values for registry hive.
type RegistryHive string

const (
	// HKEYA HKEY_A
	HKEYA RegistryHive = "HKEY_A"
	// HKEYCLASSESROOT HKEY_CLASSES_ROOT
	HKEYCLASSESROOT RegistryHive = "HKEY_CLASSES_ROOT"
	// HKEYCURRENTCONFIG HKEY_CURRENT_CONFIG
	HKEYCURRENTCONFIG RegistryHive = "HKEY_CURRENT_CONFIG"
	// HKEYCURRENTUSER HKEY_CURRENT_USER
	HKEYCURRENTUSER RegistryHive = "HKEY_CURRENT_USER"
	// HKEYCURRENTUSERLOCALSETTINGS HKEY_CURRENT_USER_LOCAL_SETTINGS
	HKEYCURRENTUSERLOCALSETTINGS RegistryHive = "HKEY_CURRENT_USER_LOCAL_SETTINGS"
	// HKEYLOCALMACHINE HKEY_LOCAL_MACHINE
	HKEYLOCALMACHINE RegistryHive = "HKEY_LOCAL_MACHINE"
	// HKEYPERFORMANCEDATA HKEY_PERFORMANCE_DATA
	HKEYPERFORMANCEDATA RegistryHive = "HKEY_PERFORMANCE_DATA"
	// HKEYPERFORMANCENLSTEXT HKEY_PERFORMANCE_NLSTEXT
	HKEYPERFORMANCENLSTEXT RegistryHive = "HKEY_PERFORMANCE_NLSTEXT"
	// HKEYPERFORMANCETEXT HKEY_PERFORMANCE_TEXT
	HKEYPERFORMANCETEXT RegistryHive = "HKEY_PERFORMANCE_TEXT"
	// HKEYUSERS HKEY_USERS
	HKEYUSERS RegistryHive = "HKEY_USERS"
)

// PossibleRegistryHiveValues returns an array of possible values for the RegistryHive const type.
func PossibleRegistryHiveValues() []RegistryHive {
	return []RegistryHive{HKEYA, HKEYCLASSESROOT, HKEYCURRENTCONFIG, HKEYCURRENTUSER, HKEYCURRENTUSERLOCALSETTINGS, HKEYLOCALMACHINE, HKEYPERFORMANCEDATA, HKEYPERFORMANCENLSTEXT, HKEYPERFORMANCETEXT, HKEYUSERS}
}

// RegistryValueKind enumerates the values for registry value kind.
type RegistryValueKind string

const (
	// RegistryValueKindBinary Binary value type
	RegistryValueKindBinary RegistryValueKind = "Binary"
	// RegistryValueKindDWord DWord value type
	RegistryValueKindDWord RegistryValueKind = "DWord"
	// RegistryValueKindExpandString ExpandString value type
	RegistryValueKindExpandString RegistryValueKind = "ExpandString"
	// RegistryValueKindMultiString MultiString value type
	RegistryValueKindMultiString RegistryValueKind = "MultiString"
	// RegistryValueKindNone None
	RegistryValueKindNone RegistryValueKind = "None"
	// RegistryValueKindQWord QWord value type
	RegistryValueKindQWord RegistryValueKind = "QWord"
	// RegistryValueKindString String value type
	RegistryValueKindString RegistryValueKind = "String"
	// RegistryValueKindUnknown Unknown value type
	RegistryValueKindUnknown RegistryValueKind = "Unknown"
)

// PossibleRegistryValueKindValues returns an array of possible values for the RegistryValueKind const type.
func PossibleRegistryValueKindValues() []RegistryValueKind {
	return []RegistryValueKind{RegistryValueKindBinary, RegistryValueKindDWord, RegistryValueKindExpandString, RegistryValueKindMultiString, RegistryValueKindNone, RegistryValueKindQWord, RegistryValueKindString, RegistryValueKindUnknown}
}

// RelationNodeKind enumerates the values for relation node kind.
type RelationNodeKind string

const (
	// RelationNodeKindBookmark Bookmark node part of the relation
	RelationNodeKindBookmark RelationNodeKind = "Bookmark"
	// RelationNodeKindCase Case node part of the relation
	RelationNodeKindCase RelationNodeKind = "Case"
)

// PossibleRelationNodeKindValues returns an array of possible values for the RelationNodeKind const type.
func PossibleRelationNodeKindValues() []RelationNodeKind {
	return []RelationNodeKind{RelationNodeKindBookmark, RelationNodeKindCase}
}

// RelationTypes enumerates the values for relation types.
type RelationTypes string

const (
	// CasesToBookmarks Relations between cases and bookmarks
	CasesToBookmarks RelationTypes = "CasesToBookmarks"
)

// PossibleRelationTypesValues returns an array of possible values for the RelationTypes const type.
func PossibleRelationTypesValues() []RelationTypes {
	return []RelationTypes{CasesToBookmarks}
}

// SettingKind enumerates the values for setting kind.
type SettingKind string

const (
	// SettingKindEntityAnalytics ...
	SettingKindEntityAnalytics SettingKind = "EntityAnalytics"
	// SettingKindEyesOn ...
	SettingKindEyesOn SettingKind = "EyesOn"
	// SettingKindUeba ...
	SettingKindUeba SettingKind = "Ueba"
)

// PossibleSettingKindValues returns an array of possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{SettingKindEntityAnalytics, SettingKindEyesOn, SettingKindUeba}
}

// Source enumerates the values for source.
type Source string

const (
	// Localfile ...
	Localfile Source = "Local file"
	// Remotestorage ...
	Remotestorage Source = "Remote storage"
)

// PossibleSourceValues returns an array of possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{Localfile, Remotestorage}
}

// TemplateStatus enumerates the values for template status.
type TemplateStatus string

const (
	// Available Alert rule template is available.
	Available TemplateStatus = "Available"
	// Installed Alert rule template installed. and can not use more then once
	Installed TemplateStatus = "Installed"
	// NotAvailable Alert rule template is not available
	NotAvailable TemplateStatus = "NotAvailable"
)

// PossibleTemplateStatusValues returns an array of possible values for the TemplateStatus const type.
func PossibleTemplateStatusValues() []TemplateStatus {
	return []TemplateStatus{Available, Installed, NotAvailable}
}

// ThreatIntelligenceResourceKind enumerates the values for threat intelligence resource kind.
type ThreatIntelligenceResourceKind string

const (
	// Indicator Entity represents threat intelligence indicator in the system.
	Indicator ThreatIntelligenceResourceKind = "indicator"
)

// PossibleThreatIntelligenceResourceKindValues returns an array of possible values for the ThreatIntelligenceResourceKind const type.
func PossibleThreatIntelligenceResourceKindValues() []ThreatIntelligenceResourceKind {
	return []ThreatIntelligenceResourceKind{Indicator}
}

// ThreatIntelligenceSortingCriteria enumerates the values for threat intelligence sorting criteria.
type ThreatIntelligenceSortingCriteria string

const (
	// Ascending ...
	Ascending ThreatIntelligenceSortingCriteria = "ascending"
	// Descending ...
	Descending ThreatIntelligenceSortingCriteria = "descending"
	// Unsorted ...
	Unsorted ThreatIntelligenceSortingCriteria = "unsorted"
)

// PossibleThreatIntelligenceSortingCriteriaValues returns an array of possible values for the ThreatIntelligenceSortingCriteria const type.
func PossibleThreatIntelligenceSortingCriteriaValues() []ThreatIntelligenceSortingCriteria {
	return []ThreatIntelligenceSortingCriteria{Ascending, Descending, Unsorted}
}

// TriggerOperator enumerates the values for trigger operator.
type TriggerOperator string

const (
	// Equal ...
	Equal TriggerOperator = "Equal"
	// GreaterThan ...
	GreaterThan TriggerOperator = "GreaterThan"
	// LessThan ...
	LessThan TriggerOperator = "LessThan"
	// NotEqual ...
	NotEqual TriggerOperator = "NotEqual"
)

// PossibleTriggerOperatorValues returns an array of possible values for the TriggerOperator const type.
func PossibleTriggerOperatorValues() []TriggerOperator {
	return []TriggerOperator{Equal, GreaterThan, LessThan, NotEqual}
}

// UebaDataSources enumerates the values for ueba data sources.
type UebaDataSources string

const (
	// AuditLogs ...
	AuditLogs UebaDataSources = "AuditLogs"
	// AzureActivity ...
	AzureActivity UebaDataSources = "AzureActivity"
	// SecurityEvent ...
	SecurityEvent UebaDataSources = "SecurityEvent"
	// SigninLogs ...
	SigninLogs UebaDataSources = "SigninLogs"
)

// PossibleUebaDataSourcesValues returns an array of possible values for the UebaDataSources const type.
func PossibleUebaDataSourcesValues() []UebaDataSources {
	return []UebaDataSources{AuditLogs, AzureActivity, SecurityEvent, SigninLogs}
}
