package templatespecsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2019-06-01-preview/templatespecs"
	"github.com/Azure/go-autorest/autorest"
)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpec templatespecs.TemplateSpec) (result templatespecs.TemplateSpec, err error)
	Delete(ctx context.Context, resourceGroupName string, templateSpecName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, templateSpecName string, expand templatespecs.TemplateSpecExpandKind) (result templatespecs.TemplateSpec, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, expand templatespecs.TemplateSpecExpandKind) (result templatespecs.ListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, expand templatespecs.TemplateSpecExpandKind) (result templatespecs.ListResultIterator, err error)
	ListBySubscription(ctx context.Context, expand templatespecs.TemplateSpecExpandKind) (result templatespecs.ListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context, expand templatespecs.TemplateSpecExpandKind) (result templatespecs.ListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpec *templatespecs.UpdateModel) (result templatespecs.TemplateSpec, err error)
}

var _ ClientAPI = (*templatespecs.Client)(nil)

// VersionsClientAPI contains the set of methods on the VersionsClient type.
type VersionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string, templateSpecVersionModel templatespecs.VersionTemplatespecs) (result templatespecs.VersionTemplatespecs, err error)
	Delete(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string) (result templatespecs.VersionTemplatespecs, err error)
	List(ctx context.Context, resourceGroupName string, templateSpecName string) (result templatespecs.VersionsListResultPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, templateSpecName string) (result templatespecs.VersionsListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string, templateSpecVersionUpdateModel *templatespecs.VersionUpdateModel) (result templatespecs.VersionTemplatespecs, err error)
}

var _ VersionsClientAPI = (*templatespecs.VersionsClient)(nil)
