package digitaltwins

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// EndpointProvisioningState enumerates the values for endpoint provisioning state.
type EndpointProvisioningState string

const (
	// Canceled ...
	Canceled EndpointProvisioningState = "Canceled"
	// Deleting ...
	Deleting EndpointProvisioningState = "Deleting"
	// Failed ...
	Failed EndpointProvisioningState = "Failed"
	// Provisioning ...
	Provisioning EndpointProvisioningState = "Provisioning"
	// Succeeded ...
	Succeeded EndpointProvisioningState = "Succeeded"
)

// PossibleEndpointProvisioningStateValues returns an array of possible values for the EndpointProvisioningState const type.
func PossibleEndpointProvisioningStateValues() []EndpointProvisioningState {
	return []EndpointProvisioningState{Canceled, Deleting, Failed, Provisioning, Succeeded}
}

// EndpointType enumerates the values for endpoint type.
type EndpointType string

const (
	// EndpointTypeDigitalTwinsEndpointResourceProperties ...
	EndpointTypeDigitalTwinsEndpointResourceProperties EndpointType = "DigitalTwinsEndpointResourceProperties"
	// EndpointTypeEventGrid ...
	EndpointTypeEventGrid EndpointType = "EventGrid"
	// EndpointTypeEventHub ...
	EndpointTypeEventHub EndpointType = "EventHub"
	// EndpointTypeServiceBus ...
	EndpointTypeServiceBus EndpointType = "ServiceBus"
)

// PossibleEndpointTypeValues returns an array of possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{EndpointTypeDigitalTwinsEndpointResourceProperties, EndpointTypeEventGrid, EndpointTypeEventHub, EndpointTypeServiceBus}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning ...
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateSucceeded}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// AlreadyExists ...
	AlreadyExists Reason = "AlreadyExists"
	// Invalid ...
	Invalid Reason = "Invalid"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{AlreadyExists, Invalid}
}
