package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ValidateClient is the cdn Management Client
type ValidateClient struct {
	BaseClient
}

// NewValidateClient creates an instance of the ValidateClient client.
func NewValidateClient(subscriptionID string, subscriptionID1 string) ValidateClient {
	return NewValidateClientWithBaseURI(DefaultBaseURI, subscriptionID, subscriptionID1)
}

// NewValidateClientWithBaseURI creates an instance of the ValidateClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewValidateClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) ValidateClient {
	return ValidateClient{NewWithBaseURI(baseURI, subscriptionID, subscriptionID1)}
}

// SecretMethod validate a Secret in the profile.
// Parameters:
// validateSecretInput - the Secret source.
func (client ValidateClient) SecretMethod(ctx context.Context, validateSecretInput ValidateSecretInput) (result ValidateSecretOutput, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ValidateClient.SecretMethod")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: validateSecretInput,
			Constraints: []validation.Constraint{{Target: "validateSecretInput.SecretSource", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.ValidateClient", "SecretMethod", err.Error())
	}

	req, err := client.SecretMethodPreparer(ctx, validateSecretInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ValidateClient", "SecretMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.SecretMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.ValidateClient", "SecretMethod", resp, "Failure sending request")
		return
	}

	result, err = client.SecretMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ValidateClient", "SecretMethod", resp, "Failure responding to request")
		return
	}

	return
}

// SecretMethodPreparer prepares the SecretMethod request.
func (client ValidateClient) SecretMethodPreparer(ctx context.Context, validateSecretInput ValidateSecretInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateSecret", pathParameters),
		autorest.WithJSON(validateSecretInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SecretMethodSender sends the SecretMethod request. The method will close the
// http.Response Body if it receives an error.
func (client ValidateClient) SecretMethodSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SecretMethodResponder handles the response to the SecretMethod request. The method always
// closes the http.Response Body.
func (client ValidateClient) SecretMethodResponder(resp *http.Response) (result ValidateSecretOutput, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
