package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AFDOriginsClient is the cdn Management Client
type AFDOriginsClient struct {
	BaseClient
}

// NewAFDOriginsClient creates an instance of the AFDOriginsClient client.
func NewAFDOriginsClient(subscriptionID string, subscriptionID1 string) AFDOriginsClient {
	return NewAFDOriginsClientWithBaseURI(DefaultBaseURI, subscriptionID, subscriptionID1)
}

// NewAFDOriginsClientWithBaseURI creates an instance of the AFDOriginsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewAFDOriginsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) AFDOriginsClient {
	return AFDOriginsClient{NewWithBaseURI(baseURI, subscriptionID, subscriptionID1)}
}

// Create creates a new origin within the specified origin group.
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the CDN profile which is unique within the resource group.
// originGroupName - name of the origin group which is unique within the profile.
// originName - name of the origin that is unique within the profile.
// origin - origin properties
func (client AFDOriginsClient) Create(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, origin AFDOrigin) (result AFDOriginsCreateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginsClient.Create")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: origin,
			Constraints: []validation.Constraint{{Target: "origin.AFDOriginProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "origin.AFDOriginProperties.HostName", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "origin.AFDOriginProperties.HTTPPort", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "origin.AFDOriginProperties.HTTPPort", Name: validation.InclusiveMaximum, Rule: int64(65535), Chain: nil},
							{Target: "origin.AFDOriginProperties.HTTPPort", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
						}},
					{Target: "origin.AFDOriginProperties.HTTPSPort", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "origin.AFDOriginProperties.HTTPSPort", Name: validation.InclusiveMaximum, Rule: int64(65535), Chain: nil},
							{Target: "origin.AFDOriginProperties.HTTPSPort", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
						}},
					{Target: "origin.AFDOriginProperties.Priority", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "origin.AFDOriginProperties.Priority", Name: validation.InclusiveMaximum, Rule: int64(5), Chain: nil},
							{Target: "origin.AFDOriginProperties.Priority", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
						}},
					{Target: "origin.AFDOriginProperties.Weight", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "origin.AFDOriginProperties.Weight", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
							{Target: "origin.AFDOriginProperties.Weight", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("cdn.AFDOriginsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, profileName, originGroupName, originName, origin)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Create", nil, "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client AFDOriginsClient) CreatePreparer(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, origin AFDOrigin) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"originGroupName":   autorest.Encode("path", originGroupName),
		"originName":        autorest.Encode("path", originName),
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", pathParameters),
		autorest.WithJSON(origin),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client AFDOriginsClient) CreateSender(req *http.Request) (future AFDOriginsCreateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client AFDOriginsClient) (ao AFDOrigin, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDOriginsCreateFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginsCreateFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		if ao.Response.Response, err = future.GetResult(sender); err == nil && ao.Response.Response.StatusCode != http.StatusNoContent {
			ao, err = client.CreateResponder(ao.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "cdn.AFDOriginsCreateFuture", "Result", ao.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client AFDOriginsClient) CreateResponder(resp *http.Response) (result AFDOrigin, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an existing origin within an origin group.
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the CDN profile which is unique within the resource group.
// originGroupName - name of the origin group which is unique within the profile.
// originName - name of the origin which is unique within the profile.
func (client AFDOriginsClient) Delete(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string) (result AFDOriginsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginsClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.AFDOriginsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, profileName, originGroupName, originName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Delete", nil, "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AFDOriginsClient) DeletePreparer(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"originGroupName":   autorest.Encode("path", originGroupName),
		"originName":        autorest.Encode("path", originName),
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AFDOriginsClient) DeleteSender(req *http.Request) (future AFDOriginsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client AFDOriginsClient) (ar autorest.Response, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDOriginsDeleteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginsDeleteFuture")
			return
		}
		ar.Response = future.Response()
		return
	}
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AFDOriginsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets an existing origin within an origin group.
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the CDN profile which is unique within the resource group.
// originGroupName - name of the origin group which is unique within the profile.
// originName - name of the origin which is unique within the profile.
func (client AFDOriginsClient) Get(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string) (result AFDOrigin, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.AFDOriginsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, profileName, originGroupName, originName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client AFDOriginsClient) GetPreparer(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"originGroupName":   autorest.Encode("path", originGroupName),
		"originName":        autorest.Encode("path", originName),
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AFDOriginsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AFDOriginsClient) GetResponder(resp *http.Response) (result AFDOrigin, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByOriginGroup lists all of the existing origins within an origin group.
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the CDN profile which is unique within the resource group.
// originGroupName - name of the origin group which is unique within the profile.
func (client AFDOriginsClient) ListByOriginGroup(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result AFDOriginListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginsClient.ListByOriginGroup")
		defer func() {
			sc := -1
			if result.aolr.Response.Response != nil {
				sc = result.aolr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.AFDOriginsClient", "ListByOriginGroup", err.Error())
	}

	result.fn = client.listByOriginGroupNextResults
	req, err := client.ListByOriginGroupPreparer(ctx, resourceGroupName, profileName, originGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "ListByOriginGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByOriginGroupSender(req)
	if err != nil {
		result.aolr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "ListByOriginGroup", resp, "Failure sending request")
		return
	}

	result.aolr, err = client.ListByOriginGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "ListByOriginGroup", resp, "Failure responding to request")
		return
	}
	if result.aolr.hasNextLink() && result.aolr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByOriginGroupPreparer prepares the ListByOriginGroup request.
func (client AFDOriginsClient) ListByOriginGroupPreparer(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"originGroupName":   autorest.Encode("path", originGroupName),
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByOriginGroupSender sends the ListByOriginGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AFDOriginsClient) ListByOriginGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByOriginGroupResponder handles the response to the ListByOriginGroup request. The method always
// closes the http.Response Body.
func (client AFDOriginsClient) ListByOriginGroupResponder(resp *http.Response) (result AFDOriginListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByOriginGroupNextResults retrieves the next set of results, if any.
func (client AFDOriginsClient) listByOriginGroupNextResults(ctx context.Context, lastResults AFDOriginListResult) (result AFDOriginListResult, err error) {
	req, err := lastResults.aFDOriginListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "listByOriginGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByOriginGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "listByOriginGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByOriginGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "listByOriginGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByOriginGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client AFDOriginsClient) ListByOriginGroupComplete(ctx context.Context, resourceGroupName string, profileName string, originGroupName string) (result AFDOriginListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginsClient.ListByOriginGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByOriginGroup(ctx, resourceGroupName, profileName, originGroupName)
	return
}

// Update updates an existing origin within an origin group.
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the CDN profile which is unique within the resource group.
// originGroupName - name of the origin group which is unique within the profile.
// originName - name of the origin which is unique within the profile.
// originUpdateProperties - origin properties
func (client AFDOriginsClient) Update(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, originUpdateProperties AFDOriginUpdateParameters) (result AFDOriginsUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginsClient.Update")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.AFDOriginsClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, profileName, originGroupName, originName, originUpdateProperties)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsClient", "Update", nil, "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AFDOriginsClient) UpdatePreparer(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, originUpdateProperties AFDOriginUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"originGroupName":   autorest.Encode("path", originGroupName),
		"originName":        autorest.Encode("path", originName),
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", pathParameters),
		autorest.WithJSON(originUpdateProperties),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AFDOriginsClient) UpdateSender(req *http.Request) (future AFDOriginsUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client AFDOriginsClient) (ao AFDOrigin, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDOriginsUpdateFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginsUpdateFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		if ao.Response.Response, err = future.GetResult(sender); err == nil && ao.Response.Response.StatusCode != http.StatusNoContent {
			ao, err = client.UpdateResponder(ao.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "cdn.AFDOriginsUpdateFuture", "Result", ao.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AFDOriginsClient) UpdateResponder(resp *http.Response) (result AFDOrigin, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
