package azurestackhciapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/azurestackhci/mgmt/2020-10-01/azurestackhci"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result azurestackhci.AvailableOperations, err error)
}

var _ OperationsClientAPI = (*azurestackhci.OperationsClient)(nil)

// ClustersClientAPI contains the set of methods on the ClustersClient type.
type ClustersClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, clusterName string, cluster azurestackhci.Cluster) (result azurestackhci.Cluster, err error)
	Delete(ctx context.Context, resourceGroupName string, clusterName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, clusterName string) (result azurestackhci.Cluster, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result azurestackhci.ClusterListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result azurestackhci.ClusterListIterator, err error)
	ListBySubscription(ctx context.Context) (result azurestackhci.ClusterListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result azurestackhci.ClusterListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, clusterName string, cluster azurestackhci.ClusterUpdate) (result azurestackhci.Cluster, err error)
}

var _ ClustersClientAPI = (*azurestackhci.ClustersClient)(nil)
