// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package mysqlflexibleservers

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/mysql/mgmt/2020-07-01-preview/mysqlflexibleservers"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CreateMode = original.CreateMode

const (
	Default            CreateMode = original.Default
	PointInTimeRestore CreateMode = original.PointInTimeRestore
	Replica            CreateMode = original.Replica
)

type HaEnabledEnum = original.HaEnabledEnum

const (
	Disabled HaEnabledEnum = original.Disabled
	Enabled  HaEnabledEnum = original.Enabled
)

type InfrastructureEncryptionEnum = original.InfrastructureEncryptionEnum

const (
	InfrastructureEncryptionEnumDisabled InfrastructureEncryptionEnum = original.InfrastructureEncryptionEnumDisabled
	InfrastructureEncryptionEnumEnabled  InfrastructureEncryptionEnum = original.InfrastructureEncryptionEnumEnabled
)

type IsConfigPendingRestart = original.IsConfigPendingRestart

const (
	False IsConfigPendingRestart = original.False
	True  IsConfigPendingRestart = original.True
)

type IsDynamicConfig = original.IsDynamicConfig

const (
	IsDynamicConfigFalse IsDynamicConfig = original.IsDynamicConfigFalse
	IsDynamicConfigTrue  IsDynamicConfig = original.IsDynamicConfigTrue
)

type IsReadOnly = original.IsReadOnly

const (
	IsReadOnlyFalse IsReadOnly = original.IsReadOnlyFalse
	IsReadOnlyTrue  IsReadOnly = original.IsReadOnlyTrue
)

type OperationOrigin = original.OperationOrigin

const (
	NotSpecified OperationOrigin = original.NotSpecified
	System       OperationOrigin = original.System
	User         OperationOrigin = original.User
)

type PublicNetworkAccessEnum = original.PublicNetworkAccessEnum

const (
	PublicNetworkAccessEnumDisabled PublicNetworkAccessEnum = original.PublicNetworkAccessEnumDisabled
	PublicNetworkAccessEnumEnabled  PublicNetworkAccessEnum = original.PublicNetworkAccessEnumEnabled
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	SystemAssigned ResourceIdentityType = original.SystemAssigned
)

type ServerHAState = original.ServerHAState

const (
	CreatingStandby ServerHAState = original.CreatingStandby
	FailingOver     ServerHAState = original.FailingOver
	Healthy         ServerHAState = original.Healthy
	NotEnabled      ServerHAState = original.NotEnabled
	RemovingStandby ServerHAState = original.RemovingStandby
	ReplicatingData ServerHAState = original.ReplicatingData
)

type ServerState = original.ServerState

const (
	ServerStateDisabled ServerState = original.ServerStateDisabled
	ServerStateDropping ServerState = original.ServerStateDropping
	ServerStateReady    ServerState = original.ServerStateReady
	ServerStateStarting ServerState = original.ServerStateStarting
	ServerStateStopped  ServerState = original.ServerStateStopped
	ServerStateStopping ServerState = original.ServerStateStopping
	ServerStateUpdating ServerState = original.ServerStateUpdating
)

type ServerVersion = original.ServerVersion

const (
	FiveFullStopSeven ServerVersion = original.FiveFullStopSeven
)

type SkuTier = original.SkuTier

const (
	Burstable       SkuTier = original.Burstable
	GeneralPurpose  SkuTier = original.GeneralPurpose
	MemoryOptimized SkuTier = original.MemoryOptimized
)

type SslEnforcementEnum = original.SslEnforcementEnum

const (
	SslEnforcementEnumDisabled SslEnforcementEnum = original.SslEnforcementEnumDisabled
	SslEnforcementEnumEnabled  SslEnforcementEnum = original.SslEnforcementEnumEnabled
)

type StorageAutogrow = original.StorageAutogrow

const (
	StorageAutogrowDisabled StorageAutogrow = original.StorageAutogrowDisabled
	StorageAutogrowEnabled  StorageAutogrow = original.StorageAutogrowEnabled
)

type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type CapabilitiesListResult = original.CapabilitiesListResult
type CapabilitiesListResultIterator = original.CapabilitiesListResultIterator
type CapabilitiesListResultPage = original.CapabilitiesListResultPage
type CapabilityProperties = original.CapabilityProperties
type CheckNameAvailabilityClient = original.CheckNameAvailabilityClient
type CheckVirtualNetworkSubnetUsageClient = original.CheckVirtualNetworkSubnetUsageClient
type CloudError = original.CloudError
type Configuration = original.Configuration
type ConfigurationListResult = original.ConfigurationListResult
type ConfigurationListResultIterator = original.ConfigurationListResultIterator
type ConfigurationListResultPage = original.ConfigurationListResultPage
type ConfigurationProperties = original.ConfigurationProperties
type ConfigurationsClient = original.ConfigurationsClient
type ConfigurationsUpdateFuture = original.ConfigurationsUpdateFuture
type Database = original.Database
type DatabaseListResult = original.DatabaseListResult
type DatabaseListResultIterator = original.DatabaseListResultIterator
type DatabaseListResultPage = original.DatabaseListResultPage
type DatabaseProperties = original.DatabaseProperties
type DatabasesClient = original.DatabasesClient
type DatabasesCreateOrUpdateFuture = original.DatabasesCreateOrUpdateFuture
type DatabasesDeleteFuture = original.DatabasesDeleteFuture
type DelegatedSubnetArguments = original.DelegatedSubnetArguments
type DelegatedSubnetUsage = original.DelegatedSubnetUsage
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorResponse = original.ErrorResponse
type FirewallRule = original.FirewallRule
type FirewallRuleListResult = original.FirewallRuleListResult
type FirewallRuleListResultIterator = original.FirewallRuleListResultIterator
type FirewallRuleListResultPage = original.FirewallRuleListResultPage
type FirewallRuleProperties = original.FirewallRuleProperties
type FirewallRulesClient = original.FirewallRulesClient
type FirewallRulesCreateOrUpdateFuture = original.FirewallRulesCreateOrUpdateFuture
type FirewallRulesDeleteFuture = original.FirewallRulesDeleteFuture
type Identity = original.Identity
type LocationBasedCapabilitiesClient = original.LocationBasedCapabilitiesClient
type MaintenanceWindow = original.MaintenanceWindow
type NameAvailability = original.NameAvailability
type NameAvailabilityRequest = original.NameAvailabilityRequest
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type Plan = original.Plan
type ProxyResource = original.ProxyResource
type ReplicasClient = original.ReplicasClient
type Resource = original.Resource
type ResourceModelWithAllowedPropertySet = original.ResourceModelWithAllowedPropertySet
type ResourceModelWithAllowedPropertySetIdentity = original.ResourceModelWithAllowedPropertySetIdentity
type ResourceModelWithAllowedPropertySetPlan = original.ResourceModelWithAllowedPropertySetPlan
type ResourceModelWithAllowedPropertySetSku = original.ResourceModelWithAllowedPropertySetSku
type Server = original.Server
type ServerEditionCapability = original.ServerEditionCapability
type ServerForUpdate = original.ServerForUpdate
type ServerKey = original.ServerKey
type ServerKeyListResult = original.ServerKeyListResult
type ServerKeyListResultIterator = original.ServerKeyListResultIterator
type ServerKeyListResultPage = original.ServerKeyListResultPage
type ServerKeyProperties = original.ServerKeyProperties
type ServerKeysClient = original.ServerKeysClient
type ServerKeysCreateOrUpdateFuture = original.ServerKeysCreateOrUpdateFuture
type ServerKeysDeleteFuture = original.ServerKeysDeleteFuture
type ServerListResult = original.ServerListResult
type ServerListResultIterator = original.ServerListResultIterator
type ServerListResultPage = original.ServerListResultPage
type ServerProperties = original.ServerProperties
type ServerPropertiesForUpdate = original.ServerPropertiesForUpdate
type ServerVersionCapability = original.ServerVersionCapability
type ServersClient = original.ServersClient
type ServersCreateFuture = original.ServersCreateFuture
type ServersDeleteFuture = original.ServersDeleteFuture
type ServersRestartFuture = original.ServersRestartFuture
type ServersStartFuture = original.ServersStartFuture
type ServersStopFuture = original.ServersStopFuture
type ServersUpdateFuture = original.ServersUpdateFuture
type Sku = original.Sku
type StorageEditionCapability = original.StorageEditionCapability
type StorageMBCapability = original.StorageMBCapability
type StorageProfile = original.StorageProfile
type TrackedResource = original.TrackedResource
type VcoreCapability = original.VcoreCapability
type VirtualNetworkSubnetUsageParameter = original.VirtualNetworkSubnetUsageParameter
type VirtualNetworkSubnetUsageResult = original.VirtualNetworkSubnetUsageResult

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewCapabilitiesListResultIterator(page CapabilitiesListResultPage) CapabilitiesListResultIterator {
	return original.NewCapabilitiesListResultIterator(page)
}
func NewCapabilitiesListResultPage(cur CapabilitiesListResult, getNextPage func(context.Context, CapabilitiesListResult) (CapabilitiesListResult, error)) CapabilitiesListResultPage {
	return original.NewCapabilitiesListResultPage(cur, getNextPage)
}
func NewCheckNameAvailabilityClient(subscriptionID string) CheckNameAvailabilityClient {
	return original.NewCheckNameAvailabilityClient(subscriptionID)
}
func NewCheckNameAvailabilityClientWithBaseURI(baseURI string, subscriptionID string) CheckNameAvailabilityClient {
	return original.NewCheckNameAvailabilityClientWithBaseURI(baseURI, subscriptionID)
}
func NewCheckVirtualNetworkSubnetUsageClient(subscriptionID string) CheckVirtualNetworkSubnetUsageClient {
	return original.NewCheckVirtualNetworkSubnetUsageClient(subscriptionID)
}
func NewCheckVirtualNetworkSubnetUsageClientWithBaseURI(baseURI string, subscriptionID string) CheckVirtualNetworkSubnetUsageClient {
	return original.NewCheckVirtualNetworkSubnetUsageClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationListResultIterator(page ConfigurationListResultPage) ConfigurationListResultIterator {
	return original.NewConfigurationListResultIterator(page)
}
func NewConfigurationListResultPage(cur ConfigurationListResult, getNextPage func(context.Context, ConfigurationListResult) (ConfigurationListResult, error)) ConfigurationListResultPage {
	return original.NewConfigurationListResultPage(cur, getNextPage)
}
func NewConfigurationsClient(subscriptionID string) ConfigurationsClient {
	return original.NewConfigurationsClient(subscriptionID)
}
func NewConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationsClient {
	return original.NewConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDatabaseListResultIterator(page DatabaseListResultPage) DatabaseListResultIterator {
	return original.NewDatabaseListResultIterator(page)
}
func NewDatabaseListResultPage(cur DatabaseListResult, getNextPage func(context.Context, DatabaseListResult) (DatabaseListResult, error)) DatabaseListResultPage {
	return original.NewDatabaseListResultPage(cur, getNextPage)
}
func NewDatabasesClient(subscriptionID string) DatabasesClient {
	return original.NewDatabasesClient(subscriptionID)
}
func NewDatabasesClientWithBaseURI(baseURI string, subscriptionID string) DatabasesClient {
	return original.NewDatabasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return original.NewFirewallRuleListResultIterator(page)
}
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return original.NewFirewallRuleListResultPage(cur, getNextPage)
}
func NewFirewallRulesClient(subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClient(subscriptionID)
}
func NewFirewallRulesClientWithBaseURI(baseURI string, subscriptionID string) FirewallRulesClient {
	return original.NewFirewallRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationBasedCapabilitiesClient(subscriptionID string) LocationBasedCapabilitiesClient {
	return original.NewLocationBasedCapabilitiesClient(subscriptionID)
}
func NewLocationBasedCapabilitiesClientWithBaseURI(baseURI string, subscriptionID string) LocationBasedCapabilitiesClient {
	return original.NewLocationBasedCapabilitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewReplicasClient(subscriptionID string) ReplicasClient {
	return original.NewReplicasClient(subscriptionID)
}
func NewReplicasClientWithBaseURI(baseURI string, subscriptionID string) ReplicasClient {
	return original.NewReplicasClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerKeyListResultIterator(page ServerKeyListResultPage) ServerKeyListResultIterator {
	return original.NewServerKeyListResultIterator(page)
}
func NewServerKeyListResultPage(cur ServerKeyListResult, getNextPage func(context.Context, ServerKeyListResult) (ServerKeyListResult, error)) ServerKeyListResultPage {
	return original.NewServerKeyListResultPage(cur, getNextPage)
}
func NewServerKeysClient(subscriptionID string) ServerKeysClient {
	return original.NewServerKeysClient(subscriptionID)
}
func NewServerKeysClientWithBaseURI(baseURI string, subscriptionID string) ServerKeysClient {
	return original.NewServerKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewServerListResultIterator(page ServerListResultPage) ServerListResultIterator {
	return original.NewServerListResultIterator(page)
}
func NewServerListResultPage(cur ServerListResult, getNextPage func(context.Context, ServerListResult) (ServerListResult, error)) ServerListResultPage {
	return original.NewServerListResultPage(cur, getNextPage)
}
func NewServersClient(subscriptionID string) ServersClient {
	return original.NewServersClient(subscriptionID)
}
func NewServersClientWithBaseURI(baseURI string, subscriptionID string) ServersClient {
	return original.NewServersClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleCreateModeValues() []CreateMode {
	return original.PossibleCreateModeValues()
}
func PossibleHaEnabledEnumValues() []HaEnabledEnum {
	return original.PossibleHaEnabledEnumValues()
}
func PossibleInfrastructureEncryptionEnumValues() []InfrastructureEncryptionEnum {
	return original.PossibleInfrastructureEncryptionEnumValues()
}
func PossibleIsConfigPendingRestartValues() []IsConfigPendingRestart {
	return original.PossibleIsConfigPendingRestartValues()
}
func PossibleIsDynamicConfigValues() []IsDynamicConfig {
	return original.PossibleIsDynamicConfigValues()
}
func PossibleIsReadOnlyValues() []IsReadOnly {
	return original.PossibleIsReadOnlyValues()
}
func PossibleOperationOriginValues() []OperationOrigin {
	return original.PossibleOperationOriginValues()
}
func PossiblePublicNetworkAccessEnumValues() []PublicNetworkAccessEnum {
	return original.PossiblePublicNetworkAccessEnumValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleServerHAStateValues() []ServerHAState {
	return original.PossibleServerHAStateValues()
}
func PossibleServerStateValues() []ServerState {
	return original.PossibleServerStateValues()
}
func PossibleServerVersionValues() []ServerVersion {
	return original.PossibleServerVersionValues()
}
func PossibleSkuTierValues() []SkuTier {
	return original.PossibleSkuTierValues()
}
func PossibleSslEnforcementEnumValues() []SslEnforcementEnum {
	return original.PossibleSslEnforcementEnumValues()
}
func PossibleStorageAutogrowValues() []StorageAutogrow {
	return original.PossibleStorageAutogrowValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
