// Code generated by entc, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/dexidp/dex/storage/ent/db/oauth2client"
)

// OAuth2ClientCreate is the builder for creating a OAuth2Client entity.
type OAuth2ClientCreate struct {
	config
	mutation *OAuth2ClientMutation
	hooks    []Hook
}

// SetSecret sets the "secret" field.
func (oc *OAuth2ClientCreate) SetSecret(s string) *OAuth2ClientCreate {
	oc.mutation.SetSecret(s)
	return oc
}

// SetRedirectUris sets the "redirect_uris" field.
func (oc *OAuth2ClientCreate) SetRedirectUris(s []string) *OAuth2ClientCreate {
	oc.mutation.SetRedirectUris(s)
	return oc
}

// SetTrustedPeers sets the "trusted_peers" field.
func (oc *OAuth2ClientCreate) SetTrustedPeers(s []string) *OAuth2ClientCreate {
	oc.mutation.SetTrustedPeers(s)
	return oc
}

// SetPublic sets the "public" field.
func (oc *OAuth2ClientCreate) SetPublic(b bool) *OAuth2ClientCreate {
	oc.mutation.SetPublic(b)
	return oc
}

// SetName sets the "name" field.
func (oc *OAuth2ClientCreate) SetName(s string) *OAuth2ClientCreate {
	oc.mutation.SetName(s)
	return oc
}

// SetLogoURL sets the "logo_url" field.
func (oc *OAuth2ClientCreate) SetLogoURL(s string) *OAuth2ClientCreate {
	oc.mutation.SetLogoURL(s)
	return oc
}

// SetID sets the "id" field.
func (oc *OAuth2ClientCreate) SetID(s string) *OAuth2ClientCreate {
	oc.mutation.SetID(s)
	return oc
}

// Mutation returns the OAuth2ClientMutation object of the builder.
func (oc *OAuth2ClientCreate) Mutation() *OAuth2ClientMutation {
	return oc.mutation
}

// Save creates the OAuth2Client in the database.
func (oc *OAuth2ClientCreate) Save(ctx context.Context) (*OAuth2Client, error) {
	var (
		err  error
		node *OAuth2Client
	)
	if len(oc.hooks) == 0 {
		if err = oc.check(); err != nil {
			return nil, err
		}
		node, err = oc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*OAuth2ClientMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = oc.check(); err != nil {
				return nil, err
			}
			oc.mutation = mutation
			node, err = oc.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(oc.hooks) - 1; i >= 0; i-- {
			mut = oc.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, oc.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (oc *OAuth2ClientCreate) SaveX(ctx context.Context) *OAuth2Client {
	v, err := oc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// check runs all checks and user-defined validators on the builder.
func (oc *OAuth2ClientCreate) check() error {
	if _, ok := oc.mutation.Secret(); !ok {
		return &ValidationError{Name: "secret", err: errors.New("db: missing required field \"secret\"")}
	}
	if v, ok := oc.mutation.Secret(); ok {
		if err := oauth2client.SecretValidator(v); err != nil {
			return &ValidationError{Name: "secret", err: fmt.Errorf("db: validator failed for field \"secret\": %w", err)}
		}
	}
	if _, ok := oc.mutation.Public(); !ok {
		return &ValidationError{Name: "public", err: errors.New("db: missing required field \"public\"")}
	}
	if _, ok := oc.mutation.Name(); !ok {
		return &ValidationError{Name: "name", err: errors.New("db: missing required field \"name\"")}
	}
	if v, ok := oc.mutation.Name(); ok {
		if err := oauth2client.NameValidator(v); err != nil {
			return &ValidationError{Name: "name", err: fmt.Errorf("db: validator failed for field \"name\": %w", err)}
		}
	}
	if _, ok := oc.mutation.LogoURL(); !ok {
		return &ValidationError{Name: "logo_url", err: errors.New("db: missing required field \"logo_url\"")}
	}
	if v, ok := oc.mutation.LogoURL(); ok {
		if err := oauth2client.LogoURLValidator(v); err != nil {
			return &ValidationError{Name: "logo_url", err: fmt.Errorf("db: validator failed for field \"logo_url\": %w", err)}
		}
	}
	if v, ok := oc.mutation.ID(); ok {
		if err := oauth2client.IDValidator(v); err != nil {
			return &ValidationError{Name: "id", err: fmt.Errorf("db: validator failed for field \"id\": %w", err)}
		}
	}
	return nil
}

func (oc *OAuth2ClientCreate) sqlSave(ctx context.Context) (*OAuth2Client, error) {
	_node, _spec := oc.createSpec()
	if err := sqlgraph.CreateNode(ctx, oc.driver, _spec); err != nil {
		if cerr, ok := isSQLConstraintError(err); ok {
			err = cerr
		}
		return nil, err
	}
	return _node, nil
}

func (oc *OAuth2ClientCreate) createSpec() (*OAuth2Client, *sqlgraph.CreateSpec) {
	var (
		_node = &OAuth2Client{config: oc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: oauth2client.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: oauth2client.FieldID,
			},
		}
	)
	if id, ok := oc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = id
	}
	if value, ok := oc.mutation.Secret(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: oauth2client.FieldSecret,
		})
		_node.Secret = value
	}
	if value, ok := oc.mutation.RedirectUris(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeJSON,
			Value:  value,
			Column: oauth2client.FieldRedirectUris,
		})
		_node.RedirectUris = value
	}
	if value, ok := oc.mutation.TrustedPeers(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeJSON,
			Value:  value,
			Column: oauth2client.FieldTrustedPeers,
		})
		_node.TrustedPeers = value
	}
	if value, ok := oc.mutation.Public(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: oauth2client.FieldPublic,
		})
		_node.Public = value
	}
	if value, ok := oc.mutation.Name(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: oauth2client.FieldName,
		})
		_node.Name = value
	}
	if value, ok := oc.mutation.LogoURL(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: oauth2client.FieldLogoURL,
		})
		_node.LogoURL = value
	}
	return _node, _spec
}

// OAuth2ClientCreateBulk is the builder for creating many OAuth2Client entities in bulk.
type OAuth2ClientCreateBulk struct {
	config
	builders []*OAuth2ClientCreate
}

// Save creates the OAuth2Client entities in the database.
func (ocb *OAuth2ClientCreateBulk) Save(ctx context.Context) ([]*OAuth2Client, error) {
	specs := make([]*sqlgraph.CreateSpec, len(ocb.builders))
	nodes := make([]*OAuth2Client, len(ocb.builders))
	mutators := make([]Mutator, len(ocb.builders))
	for i := range ocb.builders {
		func(i int, root context.Context) {
			builder := ocb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*OAuth2ClientMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ocb.builders[i+1].mutation)
				} else {
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ocb.driver, &sqlgraph.BatchCreateSpec{Nodes: specs}); err != nil {
						if cerr, ok := isSQLConstraintError(err); ok {
							err = cerr
						}
					}
				}
				mutation.done = true
				if err != nil {
					return nil, err
				}
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ocb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ocb *OAuth2ClientCreateBulk) SaveX(ctx context.Context) []*OAuth2Client {
	v, err := ocb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}
