// Code generated by entc, DO NOT EDIT.

package db

import (
	"context"
	"fmt"
	"sync"
	"time"

	"github.com/dexidp/dex/storage"
	"github.com/dexidp/dex/storage/ent/db/authcode"
	"github.com/dexidp/dex/storage/ent/db/authrequest"
	"github.com/dexidp/dex/storage/ent/db/connector"
	"github.com/dexidp/dex/storage/ent/db/devicerequest"
	"github.com/dexidp/dex/storage/ent/db/devicetoken"
	"github.com/dexidp/dex/storage/ent/db/keys"
	"github.com/dexidp/dex/storage/ent/db/oauth2client"
	"github.com/dexidp/dex/storage/ent/db/offlinesession"
	"github.com/dexidp/dex/storage/ent/db/password"
	"github.com/dexidp/dex/storage/ent/db/predicate"
	"github.com/dexidp/dex/storage/ent/db/refreshtoken"
	"gopkg.in/square/go-jose.v2"

	"entgo.io/ent"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeAuthCode       = "AuthCode"
	TypeAuthRequest    = "AuthRequest"
	TypeConnector      = "Connector"
	TypeDeviceRequest  = "DeviceRequest"
	TypeDeviceToken    = "DeviceToken"
	TypeKeys           = "Keys"
	TypeOAuth2Client   = "OAuth2Client"
	TypeOfflineSession = "OfflineSession"
	TypePassword       = "Password"
	TypeRefreshToken   = "RefreshToken"
)

// AuthCodeMutation represents an operation that mutates the AuthCode nodes in the graph.
type AuthCodeMutation struct {
	config
	op                        Op
	typ                       string
	id                        *string
	client_id                 *string
	scopes                    *[]string
	nonce                     *string
	redirect_uri              *string
	claims_user_id            *string
	claims_username           *string
	claims_email              *string
	claims_email_verified     *bool
	claims_groups             *[]string
	claims_preferred_username *string
	connector_id              *string
	connector_data            *[]byte
	expiry                    *time.Time
	code_challenge            *string
	code_challenge_method     *string
	clearedFields             map[string]struct{}
	done                      bool
	oldValue                  func(context.Context) (*AuthCode, error)
	predicates                []predicate.AuthCode
}

var _ ent.Mutation = (*AuthCodeMutation)(nil)

// authcodeOption allows management of the mutation configuration using functional options.
type authcodeOption func(*AuthCodeMutation)

// newAuthCodeMutation creates new mutation for the AuthCode entity.
func newAuthCodeMutation(c config, op Op, opts ...authcodeOption) *AuthCodeMutation {
	m := &AuthCodeMutation{
		config:        c,
		op:            op,
		typ:           TypeAuthCode,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAuthCodeID sets the ID field of the mutation.
func withAuthCodeID(id string) authcodeOption {
	return func(m *AuthCodeMutation) {
		var (
			err   error
			once  sync.Once
			value *AuthCode
		)
		m.oldValue = func(ctx context.Context) (*AuthCode, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AuthCode.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAuthCode sets the old AuthCode of the mutation.
func withAuthCode(node *AuthCode) authcodeOption {
	return func(m *AuthCodeMutation) {
		m.oldValue = func(context.Context) (*AuthCode, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AuthCodeMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AuthCodeMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of AuthCode entities.
func (m *AuthCodeMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *AuthCodeMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetClientID sets the "client_id" field.
func (m *AuthCodeMutation) SetClientID(s string) {
	m.client_id = &s
}

// ClientID returns the value of the "client_id" field in the mutation.
func (m *AuthCodeMutation) ClientID() (r string, exists bool) {
	v := m.client_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClientID returns the old "client_id" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldClientID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClientID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClientID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientID: %w", err)
	}
	return oldValue.ClientID, nil
}

// ResetClientID resets all changes to the "client_id" field.
func (m *AuthCodeMutation) ResetClientID() {
	m.client_id = nil
}

// SetScopes sets the "scopes" field.
func (m *AuthCodeMutation) SetScopes(s []string) {
	m.scopes = &s
}

// Scopes returns the value of the "scopes" field in the mutation.
func (m *AuthCodeMutation) Scopes() (r []string, exists bool) {
	v := m.scopes
	if v == nil {
		return
	}
	return *v, true
}

// OldScopes returns the old "scopes" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldScopes(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldScopes is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldScopes requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScopes: %w", err)
	}
	return oldValue.Scopes, nil
}

// ClearScopes clears the value of the "scopes" field.
func (m *AuthCodeMutation) ClearScopes() {
	m.scopes = nil
	m.clearedFields[authcode.FieldScopes] = struct{}{}
}

// ScopesCleared returns if the "scopes" field was cleared in this mutation.
func (m *AuthCodeMutation) ScopesCleared() bool {
	_, ok := m.clearedFields[authcode.FieldScopes]
	return ok
}

// ResetScopes resets all changes to the "scopes" field.
func (m *AuthCodeMutation) ResetScopes() {
	m.scopes = nil
	delete(m.clearedFields, authcode.FieldScopes)
}

// SetNonce sets the "nonce" field.
func (m *AuthCodeMutation) SetNonce(s string) {
	m.nonce = &s
}

// Nonce returns the value of the "nonce" field in the mutation.
func (m *AuthCodeMutation) Nonce() (r string, exists bool) {
	v := m.nonce
	if v == nil {
		return
	}
	return *v, true
}

// OldNonce returns the old "nonce" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldNonce(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNonce is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNonce requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNonce: %w", err)
	}
	return oldValue.Nonce, nil
}

// ResetNonce resets all changes to the "nonce" field.
func (m *AuthCodeMutation) ResetNonce() {
	m.nonce = nil
}

// SetRedirectURI sets the "redirect_uri" field.
func (m *AuthCodeMutation) SetRedirectURI(s string) {
	m.redirect_uri = &s
}

// RedirectURI returns the value of the "redirect_uri" field in the mutation.
func (m *AuthCodeMutation) RedirectURI() (r string, exists bool) {
	v := m.redirect_uri
	if v == nil {
		return
	}
	return *v, true
}

// OldRedirectURI returns the old "redirect_uri" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldRedirectURI(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldRedirectURI is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldRedirectURI requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRedirectURI: %w", err)
	}
	return oldValue.RedirectURI, nil
}

// ResetRedirectURI resets all changes to the "redirect_uri" field.
func (m *AuthCodeMutation) ResetRedirectURI() {
	m.redirect_uri = nil
}

// SetClaimsUserID sets the "claims_user_id" field.
func (m *AuthCodeMutation) SetClaimsUserID(s string) {
	m.claims_user_id = &s
}

// ClaimsUserID returns the value of the "claims_user_id" field in the mutation.
func (m *AuthCodeMutation) ClaimsUserID() (r string, exists bool) {
	v := m.claims_user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsUserID returns the old "claims_user_id" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldClaimsUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsUserID: %w", err)
	}
	return oldValue.ClaimsUserID, nil
}

// ResetClaimsUserID resets all changes to the "claims_user_id" field.
func (m *AuthCodeMutation) ResetClaimsUserID() {
	m.claims_user_id = nil
}

// SetClaimsUsername sets the "claims_username" field.
func (m *AuthCodeMutation) SetClaimsUsername(s string) {
	m.claims_username = &s
}

// ClaimsUsername returns the value of the "claims_username" field in the mutation.
func (m *AuthCodeMutation) ClaimsUsername() (r string, exists bool) {
	v := m.claims_username
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsUsername returns the old "claims_username" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldClaimsUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsUsername: %w", err)
	}
	return oldValue.ClaimsUsername, nil
}

// ResetClaimsUsername resets all changes to the "claims_username" field.
func (m *AuthCodeMutation) ResetClaimsUsername() {
	m.claims_username = nil
}

// SetClaimsEmail sets the "claims_email" field.
func (m *AuthCodeMutation) SetClaimsEmail(s string) {
	m.claims_email = &s
}

// ClaimsEmail returns the value of the "claims_email" field in the mutation.
func (m *AuthCodeMutation) ClaimsEmail() (r string, exists bool) {
	v := m.claims_email
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsEmail returns the old "claims_email" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldClaimsEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsEmail: %w", err)
	}
	return oldValue.ClaimsEmail, nil
}

// ResetClaimsEmail resets all changes to the "claims_email" field.
func (m *AuthCodeMutation) ResetClaimsEmail() {
	m.claims_email = nil
}

// SetClaimsEmailVerified sets the "claims_email_verified" field.
func (m *AuthCodeMutation) SetClaimsEmailVerified(b bool) {
	m.claims_email_verified = &b
}

// ClaimsEmailVerified returns the value of the "claims_email_verified" field in the mutation.
func (m *AuthCodeMutation) ClaimsEmailVerified() (r bool, exists bool) {
	v := m.claims_email_verified
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsEmailVerified returns the old "claims_email_verified" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldClaimsEmailVerified(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsEmailVerified is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsEmailVerified requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsEmailVerified: %w", err)
	}
	return oldValue.ClaimsEmailVerified, nil
}

// ResetClaimsEmailVerified resets all changes to the "claims_email_verified" field.
func (m *AuthCodeMutation) ResetClaimsEmailVerified() {
	m.claims_email_verified = nil
}

// SetClaimsGroups sets the "claims_groups" field.
func (m *AuthCodeMutation) SetClaimsGroups(s []string) {
	m.claims_groups = &s
}

// ClaimsGroups returns the value of the "claims_groups" field in the mutation.
func (m *AuthCodeMutation) ClaimsGroups() (r []string, exists bool) {
	v := m.claims_groups
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsGroups returns the old "claims_groups" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldClaimsGroups(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsGroups is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsGroups requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsGroups: %w", err)
	}
	return oldValue.ClaimsGroups, nil
}

// ClearClaimsGroups clears the value of the "claims_groups" field.
func (m *AuthCodeMutation) ClearClaimsGroups() {
	m.claims_groups = nil
	m.clearedFields[authcode.FieldClaimsGroups] = struct{}{}
}

// ClaimsGroupsCleared returns if the "claims_groups" field was cleared in this mutation.
func (m *AuthCodeMutation) ClaimsGroupsCleared() bool {
	_, ok := m.clearedFields[authcode.FieldClaimsGroups]
	return ok
}

// ResetClaimsGroups resets all changes to the "claims_groups" field.
func (m *AuthCodeMutation) ResetClaimsGroups() {
	m.claims_groups = nil
	delete(m.clearedFields, authcode.FieldClaimsGroups)
}

// SetClaimsPreferredUsername sets the "claims_preferred_username" field.
func (m *AuthCodeMutation) SetClaimsPreferredUsername(s string) {
	m.claims_preferred_username = &s
}

// ClaimsPreferredUsername returns the value of the "claims_preferred_username" field in the mutation.
func (m *AuthCodeMutation) ClaimsPreferredUsername() (r string, exists bool) {
	v := m.claims_preferred_username
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsPreferredUsername returns the old "claims_preferred_username" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldClaimsPreferredUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsPreferredUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsPreferredUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsPreferredUsername: %w", err)
	}
	return oldValue.ClaimsPreferredUsername, nil
}

// ResetClaimsPreferredUsername resets all changes to the "claims_preferred_username" field.
func (m *AuthCodeMutation) ResetClaimsPreferredUsername() {
	m.claims_preferred_username = nil
}

// SetConnectorID sets the "connector_id" field.
func (m *AuthCodeMutation) SetConnectorID(s string) {
	m.connector_id = &s
}

// ConnectorID returns the value of the "connector_id" field in the mutation.
func (m *AuthCodeMutation) ConnectorID() (r string, exists bool) {
	v := m.connector_id
	if v == nil {
		return
	}
	return *v, true
}

// OldConnectorID returns the old "connector_id" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldConnectorID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnectorID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnectorID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnectorID: %w", err)
	}
	return oldValue.ConnectorID, nil
}

// ResetConnectorID resets all changes to the "connector_id" field.
func (m *AuthCodeMutation) ResetConnectorID() {
	m.connector_id = nil
}

// SetConnectorData sets the "connector_data" field.
func (m *AuthCodeMutation) SetConnectorData(b []byte) {
	m.connector_data = &b
}

// ConnectorData returns the value of the "connector_data" field in the mutation.
func (m *AuthCodeMutation) ConnectorData() (r []byte, exists bool) {
	v := m.connector_data
	if v == nil {
		return
	}
	return *v, true
}

// OldConnectorData returns the old "connector_data" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldConnectorData(ctx context.Context) (v *[]byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnectorData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnectorData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnectorData: %w", err)
	}
	return oldValue.ConnectorData, nil
}

// ClearConnectorData clears the value of the "connector_data" field.
func (m *AuthCodeMutation) ClearConnectorData() {
	m.connector_data = nil
	m.clearedFields[authcode.FieldConnectorData] = struct{}{}
}

// ConnectorDataCleared returns if the "connector_data" field was cleared in this mutation.
func (m *AuthCodeMutation) ConnectorDataCleared() bool {
	_, ok := m.clearedFields[authcode.FieldConnectorData]
	return ok
}

// ResetConnectorData resets all changes to the "connector_data" field.
func (m *AuthCodeMutation) ResetConnectorData() {
	m.connector_data = nil
	delete(m.clearedFields, authcode.FieldConnectorData)
}

// SetExpiry sets the "expiry" field.
func (m *AuthCodeMutation) SetExpiry(t time.Time) {
	m.expiry = &t
}

// Expiry returns the value of the "expiry" field in the mutation.
func (m *AuthCodeMutation) Expiry() (r time.Time, exists bool) {
	v := m.expiry
	if v == nil {
		return
	}
	return *v, true
}

// OldExpiry returns the old "expiry" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldExpiry(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldExpiry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldExpiry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpiry: %w", err)
	}
	return oldValue.Expiry, nil
}

// ResetExpiry resets all changes to the "expiry" field.
func (m *AuthCodeMutation) ResetExpiry() {
	m.expiry = nil
}

// SetCodeChallenge sets the "code_challenge" field.
func (m *AuthCodeMutation) SetCodeChallenge(s string) {
	m.code_challenge = &s
}

// CodeChallenge returns the value of the "code_challenge" field in the mutation.
func (m *AuthCodeMutation) CodeChallenge() (r string, exists bool) {
	v := m.code_challenge
	if v == nil {
		return
	}
	return *v, true
}

// OldCodeChallenge returns the old "code_challenge" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldCodeChallenge(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCodeChallenge is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCodeChallenge requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCodeChallenge: %w", err)
	}
	return oldValue.CodeChallenge, nil
}

// ResetCodeChallenge resets all changes to the "code_challenge" field.
func (m *AuthCodeMutation) ResetCodeChallenge() {
	m.code_challenge = nil
}

// SetCodeChallengeMethod sets the "code_challenge_method" field.
func (m *AuthCodeMutation) SetCodeChallengeMethod(s string) {
	m.code_challenge_method = &s
}

// CodeChallengeMethod returns the value of the "code_challenge_method" field in the mutation.
func (m *AuthCodeMutation) CodeChallengeMethod() (r string, exists bool) {
	v := m.code_challenge_method
	if v == nil {
		return
	}
	return *v, true
}

// OldCodeChallengeMethod returns the old "code_challenge_method" field's value of the AuthCode entity.
// If the AuthCode object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthCodeMutation) OldCodeChallengeMethod(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCodeChallengeMethod is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCodeChallengeMethod requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCodeChallengeMethod: %w", err)
	}
	return oldValue.CodeChallengeMethod, nil
}

// ResetCodeChallengeMethod resets all changes to the "code_challenge_method" field.
func (m *AuthCodeMutation) ResetCodeChallengeMethod() {
	m.code_challenge_method = nil
}

// Op returns the operation name.
func (m *AuthCodeMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (AuthCode).
func (m *AuthCodeMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AuthCodeMutation) Fields() []string {
	fields := make([]string, 0, 15)
	if m.client_id != nil {
		fields = append(fields, authcode.FieldClientID)
	}
	if m.scopes != nil {
		fields = append(fields, authcode.FieldScopes)
	}
	if m.nonce != nil {
		fields = append(fields, authcode.FieldNonce)
	}
	if m.redirect_uri != nil {
		fields = append(fields, authcode.FieldRedirectURI)
	}
	if m.claims_user_id != nil {
		fields = append(fields, authcode.FieldClaimsUserID)
	}
	if m.claims_username != nil {
		fields = append(fields, authcode.FieldClaimsUsername)
	}
	if m.claims_email != nil {
		fields = append(fields, authcode.FieldClaimsEmail)
	}
	if m.claims_email_verified != nil {
		fields = append(fields, authcode.FieldClaimsEmailVerified)
	}
	if m.claims_groups != nil {
		fields = append(fields, authcode.FieldClaimsGroups)
	}
	if m.claims_preferred_username != nil {
		fields = append(fields, authcode.FieldClaimsPreferredUsername)
	}
	if m.connector_id != nil {
		fields = append(fields, authcode.FieldConnectorID)
	}
	if m.connector_data != nil {
		fields = append(fields, authcode.FieldConnectorData)
	}
	if m.expiry != nil {
		fields = append(fields, authcode.FieldExpiry)
	}
	if m.code_challenge != nil {
		fields = append(fields, authcode.FieldCodeChallenge)
	}
	if m.code_challenge_method != nil {
		fields = append(fields, authcode.FieldCodeChallengeMethod)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AuthCodeMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case authcode.FieldClientID:
		return m.ClientID()
	case authcode.FieldScopes:
		return m.Scopes()
	case authcode.FieldNonce:
		return m.Nonce()
	case authcode.FieldRedirectURI:
		return m.RedirectURI()
	case authcode.FieldClaimsUserID:
		return m.ClaimsUserID()
	case authcode.FieldClaimsUsername:
		return m.ClaimsUsername()
	case authcode.FieldClaimsEmail:
		return m.ClaimsEmail()
	case authcode.FieldClaimsEmailVerified:
		return m.ClaimsEmailVerified()
	case authcode.FieldClaimsGroups:
		return m.ClaimsGroups()
	case authcode.FieldClaimsPreferredUsername:
		return m.ClaimsPreferredUsername()
	case authcode.FieldConnectorID:
		return m.ConnectorID()
	case authcode.FieldConnectorData:
		return m.ConnectorData()
	case authcode.FieldExpiry:
		return m.Expiry()
	case authcode.FieldCodeChallenge:
		return m.CodeChallenge()
	case authcode.FieldCodeChallengeMethod:
		return m.CodeChallengeMethod()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AuthCodeMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case authcode.FieldClientID:
		return m.OldClientID(ctx)
	case authcode.FieldScopes:
		return m.OldScopes(ctx)
	case authcode.FieldNonce:
		return m.OldNonce(ctx)
	case authcode.FieldRedirectURI:
		return m.OldRedirectURI(ctx)
	case authcode.FieldClaimsUserID:
		return m.OldClaimsUserID(ctx)
	case authcode.FieldClaimsUsername:
		return m.OldClaimsUsername(ctx)
	case authcode.FieldClaimsEmail:
		return m.OldClaimsEmail(ctx)
	case authcode.FieldClaimsEmailVerified:
		return m.OldClaimsEmailVerified(ctx)
	case authcode.FieldClaimsGroups:
		return m.OldClaimsGroups(ctx)
	case authcode.FieldClaimsPreferredUsername:
		return m.OldClaimsPreferredUsername(ctx)
	case authcode.FieldConnectorID:
		return m.OldConnectorID(ctx)
	case authcode.FieldConnectorData:
		return m.OldConnectorData(ctx)
	case authcode.FieldExpiry:
		return m.OldExpiry(ctx)
	case authcode.FieldCodeChallenge:
		return m.OldCodeChallenge(ctx)
	case authcode.FieldCodeChallengeMethod:
		return m.OldCodeChallengeMethod(ctx)
	}
	return nil, fmt.Errorf("unknown AuthCode field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AuthCodeMutation) SetField(name string, value ent.Value) error {
	switch name {
	case authcode.FieldClientID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientID(v)
		return nil
	case authcode.FieldScopes:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScopes(v)
		return nil
	case authcode.FieldNonce:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNonce(v)
		return nil
	case authcode.FieldRedirectURI:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRedirectURI(v)
		return nil
	case authcode.FieldClaimsUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsUserID(v)
		return nil
	case authcode.FieldClaimsUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsUsername(v)
		return nil
	case authcode.FieldClaimsEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsEmail(v)
		return nil
	case authcode.FieldClaimsEmailVerified:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsEmailVerified(v)
		return nil
	case authcode.FieldClaimsGroups:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsGroups(v)
		return nil
	case authcode.FieldClaimsPreferredUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsPreferredUsername(v)
		return nil
	case authcode.FieldConnectorID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnectorID(v)
		return nil
	case authcode.FieldConnectorData:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnectorData(v)
		return nil
	case authcode.FieldExpiry:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpiry(v)
		return nil
	case authcode.FieldCodeChallenge:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCodeChallenge(v)
		return nil
	case authcode.FieldCodeChallengeMethod:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCodeChallengeMethod(v)
		return nil
	}
	return fmt.Errorf("unknown AuthCode field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AuthCodeMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AuthCodeMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AuthCodeMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown AuthCode numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AuthCodeMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(authcode.FieldScopes) {
		fields = append(fields, authcode.FieldScopes)
	}
	if m.FieldCleared(authcode.FieldClaimsGroups) {
		fields = append(fields, authcode.FieldClaimsGroups)
	}
	if m.FieldCleared(authcode.FieldConnectorData) {
		fields = append(fields, authcode.FieldConnectorData)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AuthCodeMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AuthCodeMutation) ClearField(name string) error {
	switch name {
	case authcode.FieldScopes:
		m.ClearScopes()
		return nil
	case authcode.FieldClaimsGroups:
		m.ClearClaimsGroups()
		return nil
	case authcode.FieldConnectorData:
		m.ClearConnectorData()
		return nil
	}
	return fmt.Errorf("unknown AuthCode nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AuthCodeMutation) ResetField(name string) error {
	switch name {
	case authcode.FieldClientID:
		m.ResetClientID()
		return nil
	case authcode.FieldScopes:
		m.ResetScopes()
		return nil
	case authcode.FieldNonce:
		m.ResetNonce()
		return nil
	case authcode.FieldRedirectURI:
		m.ResetRedirectURI()
		return nil
	case authcode.FieldClaimsUserID:
		m.ResetClaimsUserID()
		return nil
	case authcode.FieldClaimsUsername:
		m.ResetClaimsUsername()
		return nil
	case authcode.FieldClaimsEmail:
		m.ResetClaimsEmail()
		return nil
	case authcode.FieldClaimsEmailVerified:
		m.ResetClaimsEmailVerified()
		return nil
	case authcode.FieldClaimsGroups:
		m.ResetClaimsGroups()
		return nil
	case authcode.FieldClaimsPreferredUsername:
		m.ResetClaimsPreferredUsername()
		return nil
	case authcode.FieldConnectorID:
		m.ResetConnectorID()
		return nil
	case authcode.FieldConnectorData:
		m.ResetConnectorData()
		return nil
	case authcode.FieldExpiry:
		m.ResetExpiry()
		return nil
	case authcode.FieldCodeChallenge:
		m.ResetCodeChallenge()
		return nil
	case authcode.FieldCodeChallengeMethod:
		m.ResetCodeChallengeMethod()
		return nil
	}
	return fmt.Errorf("unknown AuthCode field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AuthCodeMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AuthCodeMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AuthCodeMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AuthCodeMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AuthCodeMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AuthCodeMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AuthCodeMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown AuthCode unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AuthCodeMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown AuthCode edge %s", name)
}

// AuthRequestMutation represents an operation that mutates the AuthRequest nodes in the graph.
type AuthRequestMutation struct {
	config
	op                        Op
	typ                       string
	id                        *string
	client_id                 *string
	scopes                    *[]string
	response_types            *[]string
	redirect_uri              *string
	nonce                     *string
	state                     *string
	force_approval_prompt     *bool
	logged_in                 *bool
	claims_user_id            *string
	claims_username           *string
	claims_email              *string
	claims_email_verified     *bool
	claims_groups             *[]string
	claims_preferred_username *string
	connector_id              *string
	connector_data            *[]byte
	expiry                    *time.Time
	code_challenge            *string
	code_challenge_method     *string
	clearedFields             map[string]struct{}
	done                      bool
	oldValue                  func(context.Context) (*AuthRequest, error)
	predicates                []predicate.AuthRequest
}

var _ ent.Mutation = (*AuthRequestMutation)(nil)

// authrequestOption allows management of the mutation configuration using functional options.
type authrequestOption func(*AuthRequestMutation)

// newAuthRequestMutation creates new mutation for the AuthRequest entity.
func newAuthRequestMutation(c config, op Op, opts ...authrequestOption) *AuthRequestMutation {
	m := &AuthRequestMutation{
		config:        c,
		op:            op,
		typ:           TypeAuthRequest,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withAuthRequestID sets the ID field of the mutation.
func withAuthRequestID(id string) authrequestOption {
	return func(m *AuthRequestMutation) {
		var (
			err   error
			once  sync.Once
			value *AuthRequest
		)
		m.oldValue = func(ctx context.Context) (*AuthRequest, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().AuthRequest.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withAuthRequest sets the old AuthRequest of the mutation.
func withAuthRequest(node *AuthRequest) authrequestOption {
	return func(m *AuthRequestMutation) {
		m.oldValue = func(context.Context) (*AuthRequest, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m AuthRequestMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m AuthRequestMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of AuthRequest entities.
func (m *AuthRequestMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *AuthRequestMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetClientID sets the "client_id" field.
func (m *AuthRequestMutation) SetClientID(s string) {
	m.client_id = &s
}

// ClientID returns the value of the "client_id" field in the mutation.
func (m *AuthRequestMutation) ClientID() (r string, exists bool) {
	v := m.client_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClientID returns the old "client_id" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldClientID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClientID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClientID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientID: %w", err)
	}
	return oldValue.ClientID, nil
}

// ResetClientID resets all changes to the "client_id" field.
func (m *AuthRequestMutation) ResetClientID() {
	m.client_id = nil
}

// SetScopes sets the "scopes" field.
func (m *AuthRequestMutation) SetScopes(s []string) {
	m.scopes = &s
}

// Scopes returns the value of the "scopes" field in the mutation.
func (m *AuthRequestMutation) Scopes() (r []string, exists bool) {
	v := m.scopes
	if v == nil {
		return
	}
	return *v, true
}

// OldScopes returns the old "scopes" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldScopes(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldScopes is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldScopes requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScopes: %w", err)
	}
	return oldValue.Scopes, nil
}

// ClearScopes clears the value of the "scopes" field.
func (m *AuthRequestMutation) ClearScopes() {
	m.scopes = nil
	m.clearedFields[authrequest.FieldScopes] = struct{}{}
}

// ScopesCleared returns if the "scopes" field was cleared in this mutation.
func (m *AuthRequestMutation) ScopesCleared() bool {
	_, ok := m.clearedFields[authrequest.FieldScopes]
	return ok
}

// ResetScopes resets all changes to the "scopes" field.
func (m *AuthRequestMutation) ResetScopes() {
	m.scopes = nil
	delete(m.clearedFields, authrequest.FieldScopes)
}

// SetResponseTypes sets the "response_types" field.
func (m *AuthRequestMutation) SetResponseTypes(s []string) {
	m.response_types = &s
}

// ResponseTypes returns the value of the "response_types" field in the mutation.
func (m *AuthRequestMutation) ResponseTypes() (r []string, exists bool) {
	v := m.response_types
	if v == nil {
		return
	}
	return *v, true
}

// OldResponseTypes returns the old "response_types" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldResponseTypes(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldResponseTypes is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldResponseTypes requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldResponseTypes: %w", err)
	}
	return oldValue.ResponseTypes, nil
}

// ClearResponseTypes clears the value of the "response_types" field.
func (m *AuthRequestMutation) ClearResponseTypes() {
	m.response_types = nil
	m.clearedFields[authrequest.FieldResponseTypes] = struct{}{}
}

// ResponseTypesCleared returns if the "response_types" field was cleared in this mutation.
func (m *AuthRequestMutation) ResponseTypesCleared() bool {
	_, ok := m.clearedFields[authrequest.FieldResponseTypes]
	return ok
}

// ResetResponseTypes resets all changes to the "response_types" field.
func (m *AuthRequestMutation) ResetResponseTypes() {
	m.response_types = nil
	delete(m.clearedFields, authrequest.FieldResponseTypes)
}

// SetRedirectURI sets the "redirect_uri" field.
func (m *AuthRequestMutation) SetRedirectURI(s string) {
	m.redirect_uri = &s
}

// RedirectURI returns the value of the "redirect_uri" field in the mutation.
func (m *AuthRequestMutation) RedirectURI() (r string, exists bool) {
	v := m.redirect_uri
	if v == nil {
		return
	}
	return *v, true
}

// OldRedirectURI returns the old "redirect_uri" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldRedirectURI(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldRedirectURI is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldRedirectURI requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRedirectURI: %w", err)
	}
	return oldValue.RedirectURI, nil
}

// ResetRedirectURI resets all changes to the "redirect_uri" field.
func (m *AuthRequestMutation) ResetRedirectURI() {
	m.redirect_uri = nil
}

// SetNonce sets the "nonce" field.
func (m *AuthRequestMutation) SetNonce(s string) {
	m.nonce = &s
}

// Nonce returns the value of the "nonce" field in the mutation.
func (m *AuthRequestMutation) Nonce() (r string, exists bool) {
	v := m.nonce
	if v == nil {
		return
	}
	return *v, true
}

// OldNonce returns the old "nonce" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldNonce(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNonce is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNonce requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNonce: %w", err)
	}
	return oldValue.Nonce, nil
}

// ResetNonce resets all changes to the "nonce" field.
func (m *AuthRequestMutation) ResetNonce() {
	m.nonce = nil
}

// SetState sets the "state" field.
func (m *AuthRequestMutation) SetState(s string) {
	m.state = &s
}

// State returns the value of the "state" field in the mutation.
func (m *AuthRequestMutation) State() (r string, exists bool) {
	v := m.state
	if v == nil {
		return
	}
	return *v, true
}

// OldState returns the old "state" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldState(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldState is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldState requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldState: %w", err)
	}
	return oldValue.State, nil
}

// ResetState resets all changes to the "state" field.
func (m *AuthRequestMutation) ResetState() {
	m.state = nil
}

// SetForceApprovalPrompt sets the "force_approval_prompt" field.
func (m *AuthRequestMutation) SetForceApprovalPrompt(b bool) {
	m.force_approval_prompt = &b
}

// ForceApprovalPrompt returns the value of the "force_approval_prompt" field in the mutation.
func (m *AuthRequestMutation) ForceApprovalPrompt() (r bool, exists bool) {
	v := m.force_approval_prompt
	if v == nil {
		return
	}
	return *v, true
}

// OldForceApprovalPrompt returns the old "force_approval_prompt" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldForceApprovalPrompt(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldForceApprovalPrompt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldForceApprovalPrompt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldForceApprovalPrompt: %w", err)
	}
	return oldValue.ForceApprovalPrompt, nil
}

// ResetForceApprovalPrompt resets all changes to the "force_approval_prompt" field.
func (m *AuthRequestMutation) ResetForceApprovalPrompt() {
	m.force_approval_prompt = nil
}

// SetLoggedIn sets the "logged_in" field.
func (m *AuthRequestMutation) SetLoggedIn(b bool) {
	m.logged_in = &b
}

// LoggedIn returns the value of the "logged_in" field in the mutation.
func (m *AuthRequestMutation) LoggedIn() (r bool, exists bool) {
	v := m.logged_in
	if v == nil {
		return
	}
	return *v, true
}

// OldLoggedIn returns the old "logged_in" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldLoggedIn(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldLoggedIn is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldLoggedIn requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLoggedIn: %w", err)
	}
	return oldValue.LoggedIn, nil
}

// ResetLoggedIn resets all changes to the "logged_in" field.
func (m *AuthRequestMutation) ResetLoggedIn() {
	m.logged_in = nil
}

// SetClaimsUserID sets the "claims_user_id" field.
func (m *AuthRequestMutation) SetClaimsUserID(s string) {
	m.claims_user_id = &s
}

// ClaimsUserID returns the value of the "claims_user_id" field in the mutation.
func (m *AuthRequestMutation) ClaimsUserID() (r string, exists bool) {
	v := m.claims_user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsUserID returns the old "claims_user_id" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldClaimsUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsUserID: %w", err)
	}
	return oldValue.ClaimsUserID, nil
}

// ResetClaimsUserID resets all changes to the "claims_user_id" field.
func (m *AuthRequestMutation) ResetClaimsUserID() {
	m.claims_user_id = nil
}

// SetClaimsUsername sets the "claims_username" field.
func (m *AuthRequestMutation) SetClaimsUsername(s string) {
	m.claims_username = &s
}

// ClaimsUsername returns the value of the "claims_username" field in the mutation.
func (m *AuthRequestMutation) ClaimsUsername() (r string, exists bool) {
	v := m.claims_username
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsUsername returns the old "claims_username" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldClaimsUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsUsername: %w", err)
	}
	return oldValue.ClaimsUsername, nil
}

// ResetClaimsUsername resets all changes to the "claims_username" field.
func (m *AuthRequestMutation) ResetClaimsUsername() {
	m.claims_username = nil
}

// SetClaimsEmail sets the "claims_email" field.
func (m *AuthRequestMutation) SetClaimsEmail(s string) {
	m.claims_email = &s
}

// ClaimsEmail returns the value of the "claims_email" field in the mutation.
func (m *AuthRequestMutation) ClaimsEmail() (r string, exists bool) {
	v := m.claims_email
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsEmail returns the old "claims_email" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldClaimsEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsEmail: %w", err)
	}
	return oldValue.ClaimsEmail, nil
}

// ResetClaimsEmail resets all changes to the "claims_email" field.
func (m *AuthRequestMutation) ResetClaimsEmail() {
	m.claims_email = nil
}

// SetClaimsEmailVerified sets the "claims_email_verified" field.
func (m *AuthRequestMutation) SetClaimsEmailVerified(b bool) {
	m.claims_email_verified = &b
}

// ClaimsEmailVerified returns the value of the "claims_email_verified" field in the mutation.
func (m *AuthRequestMutation) ClaimsEmailVerified() (r bool, exists bool) {
	v := m.claims_email_verified
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsEmailVerified returns the old "claims_email_verified" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldClaimsEmailVerified(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsEmailVerified is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsEmailVerified requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsEmailVerified: %w", err)
	}
	return oldValue.ClaimsEmailVerified, nil
}

// ResetClaimsEmailVerified resets all changes to the "claims_email_verified" field.
func (m *AuthRequestMutation) ResetClaimsEmailVerified() {
	m.claims_email_verified = nil
}

// SetClaimsGroups sets the "claims_groups" field.
func (m *AuthRequestMutation) SetClaimsGroups(s []string) {
	m.claims_groups = &s
}

// ClaimsGroups returns the value of the "claims_groups" field in the mutation.
func (m *AuthRequestMutation) ClaimsGroups() (r []string, exists bool) {
	v := m.claims_groups
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsGroups returns the old "claims_groups" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldClaimsGroups(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsGroups is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsGroups requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsGroups: %w", err)
	}
	return oldValue.ClaimsGroups, nil
}

// ClearClaimsGroups clears the value of the "claims_groups" field.
func (m *AuthRequestMutation) ClearClaimsGroups() {
	m.claims_groups = nil
	m.clearedFields[authrequest.FieldClaimsGroups] = struct{}{}
}

// ClaimsGroupsCleared returns if the "claims_groups" field was cleared in this mutation.
func (m *AuthRequestMutation) ClaimsGroupsCleared() bool {
	_, ok := m.clearedFields[authrequest.FieldClaimsGroups]
	return ok
}

// ResetClaimsGroups resets all changes to the "claims_groups" field.
func (m *AuthRequestMutation) ResetClaimsGroups() {
	m.claims_groups = nil
	delete(m.clearedFields, authrequest.FieldClaimsGroups)
}

// SetClaimsPreferredUsername sets the "claims_preferred_username" field.
func (m *AuthRequestMutation) SetClaimsPreferredUsername(s string) {
	m.claims_preferred_username = &s
}

// ClaimsPreferredUsername returns the value of the "claims_preferred_username" field in the mutation.
func (m *AuthRequestMutation) ClaimsPreferredUsername() (r string, exists bool) {
	v := m.claims_preferred_username
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsPreferredUsername returns the old "claims_preferred_username" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldClaimsPreferredUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsPreferredUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsPreferredUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsPreferredUsername: %w", err)
	}
	return oldValue.ClaimsPreferredUsername, nil
}

// ResetClaimsPreferredUsername resets all changes to the "claims_preferred_username" field.
func (m *AuthRequestMutation) ResetClaimsPreferredUsername() {
	m.claims_preferred_username = nil
}

// SetConnectorID sets the "connector_id" field.
func (m *AuthRequestMutation) SetConnectorID(s string) {
	m.connector_id = &s
}

// ConnectorID returns the value of the "connector_id" field in the mutation.
func (m *AuthRequestMutation) ConnectorID() (r string, exists bool) {
	v := m.connector_id
	if v == nil {
		return
	}
	return *v, true
}

// OldConnectorID returns the old "connector_id" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldConnectorID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnectorID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnectorID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnectorID: %w", err)
	}
	return oldValue.ConnectorID, nil
}

// ResetConnectorID resets all changes to the "connector_id" field.
func (m *AuthRequestMutation) ResetConnectorID() {
	m.connector_id = nil
}

// SetConnectorData sets the "connector_data" field.
func (m *AuthRequestMutation) SetConnectorData(b []byte) {
	m.connector_data = &b
}

// ConnectorData returns the value of the "connector_data" field in the mutation.
func (m *AuthRequestMutation) ConnectorData() (r []byte, exists bool) {
	v := m.connector_data
	if v == nil {
		return
	}
	return *v, true
}

// OldConnectorData returns the old "connector_data" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldConnectorData(ctx context.Context) (v *[]byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnectorData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnectorData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnectorData: %w", err)
	}
	return oldValue.ConnectorData, nil
}

// ClearConnectorData clears the value of the "connector_data" field.
func (m *AuthRequestMutation) ClearConnectorData() {
	m.connector_data = nil
	m.clearedFields[authrequest.FieldConnectorData] = struct{}{}
}

// ConnectorDataCleared returns if the "connector_data" field was cleared in this mutation.
func (m *AuthRequestMutation) ConnectorDataCleared() bool {
	_, ok := m.clearedFields[authrequest.FieldConnectorData]
	return ok
}

// ResetConnectorData resets all changes to the "connector_data" field.
func (m *AuthRequestMutation) ResetConnectorData() {
	m.connector_data = nil
	delete(m.clearedFields, authrequest.FieldConnectorData)
}

// SetExpiry sets the "expiry" field.
func (m *AuthRequestMutation) SetExpiry(t time.Time) {
	m.expiry = &t
}

// Expiry returns the value of the "expiry" field in the mutation.
func (m *AuthRequestMutation) Expiry() (r time.Time, exists bool) {
	v := m.expiry
	if v == nil {
		return
	}
	return *v, true
}

// OldExpiry returns the old "expiry" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldExpiry(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldExpiry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldExpiry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpiry: %w", err)
	}
	return oldValue.Expiry, nil
}

// ResetExpiry resets all changes to the "expiry" field.
func (m *AuthRequestMutation) ResetExpiry() {
	m.expiry = nil
}

// SetCodeChallenge sets the "code_challenge" field.
func (m *AuthRequestMutation) SetCodeChallenge(s string) {
	m.code_challenge = &s
}

// CodeChallenge returns the value of the "code_challenge" field in the mutation.
func (m *AuthRequestMutation) CodeChallenge() (r string, exists bool) {
	v := m.code_challenge
	if v == nil {
		return
	}
	return *v, true
}

// OldCodeChallenge returns the old "code_challenge" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldCodeChallenge(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCodeChallenge is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCodeChallenge requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCodeChallenge: %w", err)
	}
	return oldValue.CodeChallenge, nil
}

// ResetCodeChallenge resets all changes to the "code_challenge" field.
func (m *AuthRequestMutation) ResetCodeChallenge() {
	m.code_challenge = nil
}

// SetCodeChallengeMethod sets the "code_challenge_method" field.
func (m *AuthRequestMutation) SetCodeChallengeMethod(s string) {
	m.code_challenge_method = &s
}

// CodeChallengeMethod returns the value of the "code_challenge_method" field in the mutation.
func (m *AuthRequestMutation) CodeChallengeMethod() (r string, exists bool) {
	v := m.code_challenge_method
	if v == nil {
		return
	}
	return *v, true
}

// OldCodeChallengeMethod returns the old "code_challenge_method" field's value of the AuthRequest entity.
// If the AuthRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *AuthRequestMutation) OldCodeChallengeMethod(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCodeChallengeMethod is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCodeChallengeMethod requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCodeChallengeMethod: %w", err)
	}
	return oldValue.CodeChallengeMethod, nil
}

// ResetCodeChallengeMethod resets all changes to the "code_challenge_method" field.
func (m *AuthRequestMutation) ResetCodeChallengeMethod() {
	m.code_challenge_method = nil
}

// Op returns the operation name.
func (m *AuthRequestMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (AuthRequest).
func (m *AuthRequestMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *AuthRequestMutation) Fields() []string {
	fields := make([]string, 0, 19)
	if m.client_id != nil {
		fields = append(fields, authrequest.FieldClientID)
	}
	if m.scopes != nil {
		fields = append(fields, authrequest.FieldScopes)
	}
	if m.response_types != nil {
		fields = append(fields, authrequest.FieldResponseTypes)
	}
	if m.redirect_uri != nil {
		fields = append(fields, authrequest.FieldRedirectURI)
	}
	if m.nonce != nil {
		fields = append(fields, authrequest.FieldNonce)
	}
	if m.state != nil {
		fields = append(fields, authrequest.FieldState)
	}
	if m.force_approval_prompt != nil {
		fields = append(fields, authrequest.FieldForceApprovalPrompt)
	}
	if m.logged_in != nil {
		fields = append(fields, authrequest.FieldLoggedIn)
	}
	if m.claims_user_id != nil {
		fields = append(fields, authrequest.FieldClaimsUserID)
	}
	if m.claims_username != nil {
		fields = append(fields, authrequest.FieldClaimsUsername)
	}
	if m.claims_email != nil {
		fields = append(fields, authrequest.FieldClaimsEmail)
	}
	if m.claims_email_verified != nil {
		fields = append(fields, authrequest.FieldClaimsEmailVerified)
	}
	if m.claims_groups != nil {
		fields = append(fields, authrequest.FieldClaimsGroups)
	}
	if m.claims_preferred_username != nil {
		fields = append(fields, authrequest.FieldClaimsPreferredUsername)
	}
	if m.connector_id != nil {
		fields = append(fields, authrequest.FieldConnectorID)
	}
	if m.connector_data != nil {
		fields = append(fields, authrequest.FieldConnectorData)
	}
	if m.expiry != nil {
		fields = append(fields, authrequest.FieldExpiry)
	}
	if m.code_challenge != nil {
		fields = append(fields, authrequest.FieldCodeChallenge)
	}
	if m.code_challenge_method != nil {
		fields = append(fields, authrequest.FieldCodeChallengeMethod)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *AuthRequestMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case authrequest.FieldClientID:
		return m.ClientID()
	case authrequest.FieldScopes:
		return m.Scopes()
	case authrequest.FieldResponseTypes:
		return m.ResponseTypes()
	case authrequest.FieldRedirectURI:
		return m.RedirectURI()
	case authrequest.FieldNonce:
		return m.Nonce()
	case authrequest.FieldState:
		return m.State()
	case authrequest.FieldForceApprovalPrompt:
		return m.ForceApprovalPrompt()
	case authrequest.FieldLoggedIn:
		return m.LoggedIn()
	case authrequest.FieldClaimsUserID:
		return m.ClaimsUserID()
	case authrequest.FieldClaimsUsername:
		return m.ClaimsUsername()
	case authrequest.FieldClaimsEmail:
		return m.ClaimsEmail()
	case authrequest.FieldClaimsEmailVerified:
		return m.ClaimsEmailVerified()
	case authrequest.FieldClaimsGroups:
		return m.ClaimsGroups()
	case authrequest.FieldClaimsPreferredUsername:
		return m.ClaimsPreferredUsername()
	case authrequest.FieldConnectorID:
		return m.ConnectorID()
	case authrequest.FieldConnectorData:
		return m.ConnectorData()
	case authrequest.FieldExpiry:
		return m.Expiry()
	case authrequest.FieldCodeChallenge:
		return m.CodeChallenge()
	case authrequest.FieldCodeChallengeMethod:
		return m.CodeChallengeMethod()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *AuthRequestMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case authrequest.FieldClientID:
		return m.OldClientID(ctx)
	case authrequest.FieldScopes:
		return m.OldScopes(ctx)
	case authrequest.FieldResponseTypes:
		return m.OldResponseTypes(ctx)
	case authrequest.FieldRedirectURI:
		return m.OldRedirectURI(ctx)
	case authrequest.FieldNonce:
		return m.OldNonce(ctx)
	case authrequest.FieldState:
		return m.OldState(ctx)
	case authrequest.FieldForceApprovalPrompt:
		return m.OldForceApprovalPrompt(ctx)
	case authrequest.FieldLoggedIn:
		return m.OldLoggedIn(ctx)
	case authrequest.FieldClaimsUserID:
		return m.OldClaimsUserID(ctx)
	case authrequest.FieldClaimsUsername:
		return m.OldClaimsUsername(ctx)
	case authrequest.FieldClaimsEmail:
		return m.OldClaimsEmail(ctx)
	case authrequest.FieldClaimsEmailVerified:
		return m.OldClaimsEmailVerified(ctx)
	case authrequest.FieldClaimsGroups:
		return m.OldClaimsGroups(ctx)
	case authrequest.FieldClaimsPreferredUsername:
		return m.OldClaimsPreferredUsername(ctx)
	case authrequest.FieldConnectorID:
		return m.OldConnectorID(ctx)
	case authrequest.FieldConnectorData:
		return m.OldConnectorData(ctx)
	case authrequest.FieldExpiry:
		return m.OldExpiry(ctx)
	case authrequest.FieldCodeChallenge:
		return m.OldCodeChallenge(ctx)
	case authrequest.FieldCodeChallengeMethod:
		return m.OldCodeChallengeMethod(ctx)
	}
	return nil, fmt.Errorf("unknown AuthRequest field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AuthRequestMutation) SetField(name string, value ent.Value) error {
	switch name {
	case authrequest.FieldClientID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientID(v)
		return nil
	case authrequest.FieldScopes:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScopes(v)
		return nil
	case authrequest.FieldResponseTypes:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetResponseTypes(v)
		return nil
	case authrequest.FieldRedirectURI:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRedirectURI(v)
		return nil
	case authrequest.FieldNonce:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNonce(v)
		return nil
	case authrequest.FieldState:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetState(v)
		return nil
	case authrequest.FieldForceApprovalPrompt:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetForceApprovalPrompt(v)
		return nil
	case authrequest.FieldLoggedIn:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLoggedIn(v)
		return nil
	case authrequest.FieldClaimsUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsUserID(v)
		return nil
	case authrequest.FieldClaimsUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsUsername(v)
		return nil
	case authrequest.FieldClaimsEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsEmail(v)
		return nil
	case authrequest.FieldClaimsEmailVerified:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsEmailVerified(v)
		return nil
	case authrequest.FieldClaimsGroups:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsGroups(v)
		return nil
	case authrequest.FieldClaimsPreferredUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsPreferredUsername(v)
		return nil
	case authrequest.FieldConnectorID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnectorID(v)
		return nil
	case authrequest.FieldConnectorData:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnectorData(v)
		return nil
	case authrequest.FieldExpiry:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpiry(v)
		return nil
	case authrequest.FieldCodeChallenge:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCodeChallenge(v)
		return nil
	case authrequest.FieldCodeChallengeMethod:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCodeChallengeMethod(v)
		return nil
	}
	return fmt.Errorf("unknown AuthRequest field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *AuthRequestMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *AuthRequestMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *AuthRequestMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown AuthRequest numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *AuthRequestMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(authrequest.FieldScopes) {
		fields = append(fields, authrequest.FieldScopes)
	}
	if m.FieldCleared(authrequest.FieldResponseTypes) {
		fields = append(fields, authrequest.FieldResponseTypes)
	}
	if m.FieldCleared(authrequest.FieldClaimsGroups) {
		fields = append(fields, authrequest.FieldClaimsGroups)
	}
	if m.FieldCleared(authrequest.FieldConnectorData) {
		fields = append(fields, authrequest.FieldConnectorData)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *AuthRequestMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *AuthRequestMutation) ClearField(name string) error {
	switch name {
	case authrequest.FieldScopes:
		m.ClearScopes()
		return nil
	case authrequest.FieldResponseTypes:
		m.ClearResponseTypes()
		return nil
	case authrequest.FieldClaimsGroups:
		m.ClearClaimsGroups()
		return nil
	case authrequest.FieldConnectorData:
		m.ClearConnectorData()
		return nil
	}
	return fmt.Errorf("unknown AuthRequest nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *AuthRequestMutation) ResetField(name string) error {
	switch name {
	case authrequest.FieldClientID:
		m.ResetClientID()
		return nil
	case authrequest.FieldScopes:
		m.ResetScopes()
		return nil
	case authrequest.FieldResponseTypes:
		m.ResetResponseTypes()
		return nil
	case authrequest.FieldRedirectURI:
		m.ResetRedirectURI()
		return nil
	case authrequest.FieldNonce:
		m.ResetNonce()
		return nil
	case authrequest.FieldState:
		m.ResetState()
		return nil
	case authrequest.FieldForceApprovalPrompt:
		m.ResetForceApprovalPrompt()
		return nil
	case authrequest.FieldLoggedIn:
		m.ResetLoggedIn()
		return nil
	case authrequest.FieldClaimsUserID:
		m.ResetClaimsUserID()
		return nil
	case authrequest.FieldClaimsUsername:
		m.ResetClaimsUsername()
		return nil
	case authrequest.FieldClaimsEmail:
		m.ResetClaimsEmail()
		return nil
	case authrequest.FieldClaimsEmailVerified:
		m.ResetClaimsEmailVerified()
		return nil
	case authrequest.FieldClaimsGroups:
		m.ResetClaimsGroups()
		return nil
	case authrequest.FieldClaimsPreferredUsername:
		m.ResetClaimsPreferredUsername()
		return nil
	case authrequest.FieldConnectorID:
		m.ResetConnectorID()
		return nil
	case authrequest.FieldConnectorData:
		m.ResetConnectorData()
		return nil
	case authrequest.FieldExpiry:
		m.ResetExpiry()
		return nil
	case authrequest.FieldCodeChallenge:
		m.ResetCodeChallenge()
		return nil
	case authrequest.FieldCodeChallengeMethod:
		m.ResetCodeChallengeMethod()
		return nil
	}
	return fmt.Errorf("unknown AuthRequest field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *AuthRequestMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *AuthRequestMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *AuthRequestMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *AuthRequestMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *AuthRequestMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *AuthRequestMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *AuthRequestMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown AuthRequest unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *AuthRequestMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown AuthRequest edge %s", name)
}

// ConnectorMutation represents an operation that mutates the Connector nodes in the graph.
type ConnectorMutation struct {
	config
	op               Op
	typ              string
	id               *string
	_type            *string
	name             *string
	resource_version *string
	_config          *[]byte
	clearedFields    map[string]struct{}
	done             bool
	oldValue         func(context.Context) (*Connector, error)
	predicates       []predicate.Connector
}

var _ ent.Mutation = (*ConnectorMutation)(nil)

// connectorOption allows management of the mutation configuration using functional options.
type connectorOption func(*ConnectorMutation)

// newConnectorMutation creates new mutation for the Connector entity.
func newConnectorMutation(c config, op Op, opts ...connectorOption) *ConnectorMutation {
	m := &ConnectorMutation{
		config:        c,
		op:            op,
		typ:           TypeConnector,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withConnectorID sets the ID field of the mutation.
func withConnectorID(id string) connectorOption {
	return func(m *ConnectorMutation) {
		var (
			err   error
			once  sync.Once
			value *Connector
		)
		m.oldValue = func(ctx context.Context) (*Connector, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Connector.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withConnector sets the old Connector of the mutation.
func withConnector(node *Connector) connectorOption {
	return func(m *ConnectorMutation) {
		m.oldValue = func(context.Context) (*Connector, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ConnectorMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ConnectorMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Connector entities.
func (m *ConnectorMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *ConnectorMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetType sets the "type" field.
func (m *ConnectorMutation) SetType(s string) {
	m._type = &s
}

// GetType returns the value of the "type" field in the mutation.
func (m *ConnectorMutation) GetType() (r string, exists bool) {
	v := m._type
	if v == nil {
		return
	}
	return *v, true
}

// OldType returns the old "type" field's value of the Connector entity.
// If the Connector object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConnectorMutation) OldType(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldType: %w", err)
	}
	return oldValue.Type, nil
}

// ResetType resets all changes to the "type" field.
func (m *ConnectorMutation) ResetType() {
	m._type = nil
}

// SetName sets the "name" field.
func (m *ConnectorMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *ConnectorMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Connector entity.
// If the Connector object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConnectorMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *ConnectorMutation) ResetName() {
	m.name = nil
}

// SetResourceVersion sets the "resource_version" field.
func (m *ConnectorMutation) SetResourceVersion(s string) {
	m.resource_version = &s
}

// ResourceVersion returns the value of the "resource_version" field in the mutation.
func (m *ConnectorMutation) ResourceVersion() (r string, exists bool) {
	v := m.resource_version
	if v == nil {
		return
	}
	return *v, true
}

// OldResourceVersion returns the old "resource_version" field's value of the Connector entity.
// If the Connector object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConnectorMutation) OldResourceVersion(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldResourceVersion is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldResourceVersion requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldResourceVersion: %w", err)
	}
	return oldValue.ResourceVersion, nil
}

// ResetResourceVersion resets all changes to the "resource_version" field.
func (m *ConnectorMutation) ResetResourceVersion() {
	m.resource_version = nil
}

// SetConfig sets the "config" field.
func (m *ConnectorMutation) SetConfig(b []byte) {
	m._config = &b
}

// Config returns the value of the "config" field in the mutation.
func (m *ConnectorMutation) Config() (r []byte, exists bool) {
	v := m._config
	if v == nil {
		return
	}
	return *v, true
}

// OldConfig returns the old "config" field's value of the Connector entity.
// If the Connector object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ConnectorMutation) OldConfig(ctx context.Context) (v []byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConfig is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConfig requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConfig: %w", err)
	}
	return oldValue.Config, nil
}

// ResetConfig resets all changes to the "config" field.
func (m *ConnectorMutation) ResetConfig() {
	m._config = nil
}

// Op returns the operation name.
func (m *ConnectorMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Connector).
func (m *ConnectorMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ConnectorMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m._type != nil {
		fields = append(fields, connector.FieldType)
	}
	if m.name != nil {
		fields = append(fields, connector.FieldName)
	}
	if m.resource_version != nil {
		fields = append(fields, connector.FieldResourceVersion)
	}
	if m._config != nil {
		fields = append(fields, connector.FieldConfig)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ConnectorMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case connector.FieldType:
		return m.GetType()
	case connector.FieldName:
		return m.Name()
	case connector.FieldResourceVersion:
		return m.ResourceVersion()
	case connector.FieldConfig:
		return m.Config()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ConnectorMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case connector.FieldType:
		return m.OldType(ctx)
	case connector.FieldName:
		return m.OldName(ctx)
	case connector.FieldResourceVersion:
		return m.OldResourceVersion(ctx)
	case connector.FieldConfig:
		return m.OldConfig(ctx)
	}
	return nil, fmt.Errorf("unknown Connector field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ConnectorMutation) SetField(name string, value ent.Value) error {
	switch name {
	case connector.FieldType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetType(v)
		return nil
	case connector.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case connector.FieldResourceVersion:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetResourceVersion(v)
		return nil
	case connector.FieldConfig:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConfig(v)
		return nil
	}
	return fmt.Errorf("unknown Connector field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ConnectorMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ConnectorMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ConnectorMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Connector numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ConnectorMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ConnectorMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ConnectorMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Connector nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ConnectorMutation) ResetField(name string) error {
	switch name {
	case connector.FieldType:
		m.ResetType()
		return nil
	case connector.FieldName:
		m.ResetName()
		return nil
	case connector.FieldResourceVersion:
		m.ResetResourceVersion()
		return nil
	case connector.FieldConfig:
		m.ResetConfig()
		return nil
	}
	return fmt.Errorf("unknown Connector field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ConnectorMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ConnectorMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ConnectorMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ConnectorMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ConnectorMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ConnectorMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ConnectorMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Connector unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ConnectorMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Connector edge %s", name)
}

// DeviceRequestMutation represents an operation that mutates the DeviceRequest nodes in the graph.
type DeviceRequestMutation struct {
	config
	op            Op
	typ           string
	id            *int
	user_code     *string
	device_code   *string
	client_id     *string
	client_secret *string
	scopes        *[]string
	expiry        *time.Time
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*DeviceRequest, error)
	predicates    []predicate.DeviceRequest
}

var _ ent.Mutation = (*DeviceRequestMutation)(nil)

// devicerequestOption allows management of the mutation configuration using functional options.
type devicerequestOption func(*DeviceRequestMutation)

// newDeviceRequestMutation creates new mutation for the DeviceRequest entity.
func newDeviceRequestMutation(c config, op Op, opts ...devicerequestOption) *DeviceRequestMutation {
	m := &DeviceRequestMutation{
		config:        c,
		op:            op,
		typ:           TypeDeviceRequest,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withDeviceRequestID sets the ID field of the mutation.
func withDeviceRequestID(id int) devicerequestOption {
	return func(m *DeviceRequestMutation) {
		var (
			err   error
			once  sync.Once
			value *DeviceRequest
		)
		m.oldValue = func(ctx context.Context) (*DeviceRequest, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().DeviceRequest.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withDeviceRequest sets the old DeviceRequest of the mutation.
func withDeviceRequest(node *DeviceRequest) devicerequestOption {
	return func(m *DeviceRequestMutation) {
		m.oldValue = func(context.Context) (*DeviceRequest, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m DeviceRequestMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m DeviceRequestMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *DeviceRequestMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetUserCode sets the "user_code" field.
func (m *DeviceRequestMutation) SetUserCode(s string) {
	m.user_code = &s
}

// UserCode returns the value of the "user_code" field in the mutation.
func (m *DeviceRequestMutation) UserCode() (r string, exists bool) {
	v := m.user_code
	if v == nil {
		return
	}
	return *v, true
}

// OldUserCode returns the old "user_code" field's value of the DeviceRequest entity.
// If the DeviceRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceRequestMutation) OldUserCode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUserCode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUserCode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserCode: %w", err)
	}
	return oldValue.UserCode, nil
}

// ResetUserCode resets all changes to the "user_code" field.
func (m *DeviceRequestMutation) ResetUserCode() {
	m.user_code = nil
}

// SetDeviceCode sets the "device_code" field.
func (m *DeviceRequestMutation) SetDeviceCode(s string) {
	m.device_code = &s
}

// DeviceCode returns the value of the "device_code" field in the mutation.
func (m *DeviceRequestMutation) DeviceCode() (r string, exists bool) {
	v := m.device_code
	if v == nil {
		return
	}
	return *v, true
}

// OldDeviceCode returns the old "device_code" field's value of the DeviceRequest entity.
// If the DeviceRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceRequestMutation) OldDeviceCode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDeviceCode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDeviceCode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeviceCode: %w", err)
	}
	return oldValue.DeviceCode, nil
}

// ResetDeviceCode resets all changes to the "device_code" field.
func (m *DeviceRequestMutation) ResetDeviceCode() {
	m.device_code = nil
}

// SetClientID sets the "client_id" field.
func (m *DeviceRequestMutation) SetClientID(s string) {
	m.client_id = &s
}

// ClientID returns the value of the "client_id" field in the mutation.
func (m *DeviceRequestMutation) ClientID() (r string, exists bool) {
	v := m.client_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClientID returns the old "client_id" field's value of the DeviceRequest entity.
// If the DeviceRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceRequestMutation) OldClientID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClientID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClientID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientID: %w", err)
	}
	return oldValue.ClientID, nil
}

// ResetClientID resets all changes to the "client_id" field.
func (m *DeviceRequestMutation) ResetClientID() {
	m.client_id = nil
}

// SetClientSecret sets the "client_secret" field.
func (m *DeviceRequestMutation) SetClientSecret(s string) {
	m.client_secret = &s
}

// ClientSecret returns the value of the "client_secret" field in the mutation.
func (m *DeviceRequestMutation) ClientSecret() (r string, exists bool) {
	v := m.client_secret
	if v == nil {
		return
	}
	return *v, true
}

// OldClientSecret returns the old "client_secret" field's value of the DeviceRequest entity.
// If the DeviceRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceRequestMutation) OldClientSecret(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClientSecret is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClientSecret requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientSecret: %w", err)
	}
	return oldValue.ClientSecret, nil
}

// ResetClientSecret resets all changes to the "client_secret" field.
func (m *DeviceRequestMutation) ResetClientSecret() {
	m.client_secret = nil
}

// SetScopes sets the "scopes" field.
func (m *DeviceRequestMutation) SetScopes(s []string) {
	m.scopes = &s
}

// Scopes returns the value of the "scopes" field in the mutation.
func (m *DeviceRequestMutation) Scopes() (r []string, exists bool) {
	v := m.scopes
	if v == nil {
		return
	}
	return *v, true
}

// OldScopes returns the old "scopes" field's value of the DeviceRequest entity.
// If the DeviceRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceRequestMutation) OldScopes(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldScopes is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldScopes requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScopes: %w", err)
	}
	return oldValue.Scopes, nil
}

// ClearScopes clears the value of the "scopes" field.
func (m *DeviceRequestMutation) ClearScopes() {
	m.scopes = nil
	m.clearedFields[devicerequest.FieldScopes] = struct{}{}
}

// ScopesCleared returns if the "scopes" field was cleared in this mutation.
func (m *DeviceRequestMutation) ScopesCleared() bool {
	_, ok := m.clearedFields[devicerequest.FieldScopes]
	return ok
}

// ResetScopes resets all changes to the "scopes" field.
func (m *DeviceRequestMutation) ResetScopes() {
	m.scopes = nil
	delete(m.clearedFields, devicerequest.FieldScopes)
}

// SetExpiry sets the "expiry" field.
func (m *DeviceRequestMutation) SetExpiry(t time.Time) {
	m.expiry = &t
}

// Expiry returns the value of the "expiry" field in the mutation.
func (m *DeviceRequestMutation) Expiry() (r time.Time, exists bool) {
	v := m.expiry
	if v == nil {
		return
	}
	return *v, true
}

// OldExpiry returns the old "expiry" field's value of the DeviceRequest entity.
// If the DeviceRequest object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceRequestMutation) OldExpiry(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldExpiry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldExpiry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpiry: %w", err)
	}
	return oldValue.Expiry, nil
}

// ResetExpiry resets all changes to the "expiry" field.
func (m *DeviceRequestMutation) ResetExpiry() {
	m.expiry = nil
}

// Op returns the operation name.
func (m *DeviceRequestMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (DeviceRequest).
func (m *DeviceRequestMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *DeviceRequestMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.user_code != nil {
		fields = append(fields, devicerequest.FieldUserCode)
	}
	if m.device_code != nil {
		fields = append(fields, devicerequest.FieldDeviceCode)
	}
	if m.client_id != nil {
		fields = append(fields, devicerequest.FieldClientID)
	}
	if m.client_secret != nil {
		fields = append(fields, devicerequest.FieldClientSecret)
	}
	if m.scopes != nil {
		fields = append(fields, devicerequest.FieldScopes)
	}
	if m.expiry != nil {
		fields = append(fields, devicerequest.FieldExpiry)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *DeviceRequestMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case devicerequest.FieldUserCode:
		return m.UserCode()
	case devicerequest.FieldDeviceCode:
		return m.DeviceCode()
	case devicerequest.FieldClientID:
		return m.ClientID()
	case devicerequest.FieldClientSecret:
		return m.ClientSecret()
	case devicerequest.FieldScopes:
		return m.Scopes()
	case devicerequest.FieldExpiry:
		return m.Expiry()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *DeviceRequestMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case devicerequest.FieldUserCode:
		return m.OldUserCode(ctx)
	case devicerequest.FieldDeviceCode:
		return m.OldDeviceCode(ctx)
	case devicerequest.FieldClientID:
		return m.OldClientID(ctx)
	case devicerequest.FieldClientSecret:
		return m.OldClientSecret(ctx)
	case devicerequest.FieldScopes:
		return m.OldScopes(ctx)
	case devicerequest.FieldExpiry:
		return m.OldExpiry(ctx)
	}
	return nil, fmt.Errorf("unknown DeviceRequest field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DeviceRequestMutation) SetField(name string, value ent.Value) error {
	switch name {
	case devicerequest.FieldUserCode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserCode(v)
		return nil
	case devicerequest.FieldDeviceCode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeviceCode(v)
		return nil
	case devicerequest.FieldClientID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientID(v)
		return nil
	case devicerequest.FieldClientSecret:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientSecret(v)
		return nil
	case devicerequest.FieldScopes:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScopes(v)
		return nil
	case devicerequest.FieldExpiry:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpiry(v)
		return nil
	}
	return fmt.Errorf("unknown DeviceRequest field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *DeviceRequestMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *DeviceRequestMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DeviceRequestMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown DeviceRequest numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *DeviceRequestMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(devicerequest.FieldScopes) {
		fields = append(fields, devicerequest.FieldScopes)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *DeviceRequestMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *DeviceRequestMutation) ClearField(name string) error {
	switch name {
	case devicerequest.FieldScopes:
		m.ClearScopes()
		return nil
	}
	return fmt.Errorf("unknown DeviceRequest nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *DeviceRequestMutation) ResetField(name string) error {
	switch name {
	case devicerequest.FieldUserCode:
		m.ResetUserCode()
		return nil
	case devicerequest.FieldDeviceCode:
		m.ResetDeviceCode()
		return nil
	case devicerequest.FieldClientID:
		m.ResetClientID()
		return nil
	case devicerequest.FieldClientSecret:
		m.ResetClientSecret()
		return nil
	case devicerequest.FieldScopes:
		m.ResetScopes()
		return nil
	case devicerequest.FieldExpiry:
		m.ResetExpiry()
		return nil
	}
	return fmt.Errorf("unknown DeviceRequest field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *DeviceRequestMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *DeviceRequestMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *DeviceRequestMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *DeviceRequestMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *DeviceRequestMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *DeviceRequestMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *DeviceRequestMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown DeviceRequest unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *DeviceRequestMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown DeviceRequest edge %s", name)
}

// DeviceTokenMutation represents an operation that mutates the DeviceToken nodes in the graph.
type DeviceTokenMutation struct {
	config
	op               Op
	typ              string
	id               *int
	device_code      *string
	status           *string
	token            *[]byte
	expiry           *time.Time
	last_request     *time.Time
	poll_interval    *int
	addpoll_interval *int
	clearedFields    map[string]struct{}
	done             bool
	oldValue         func(context.Context) (*DeviceToken, error)
	predicates       []predicate.DeviceToken
}

var _ ent.Mutation = (*DeviceTokenMutation)(nil)

// devicetokenOption allows management of the mutation configuration using functional options.
type devicetokenOption func(*DeviceTokenMutation)

// newDeviceTokenMutation creates new mutation for the DeviceToken entity.
func newDeviceTokenMutation(c config, op Op, opts ...devicetokenOption) *DeviceTokenMutation {
	m := &DeviceTokenMutation{
		config:        c,
		op:            op,
		typ:           TypeDeviceToken,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withDeviceTokenID sets the ID field of the mutation.
func withDeviceTokenID(id int) devicetokenOption {
	return func(m *DeviceTokenMutation) {
		var (
			err   error
			once  sync.Once
			value *DeviceToken
		)
		m.oldValue = func(ctx context.Context) (*DeviceToken, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().DeviceToken.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withDeviceToken sets the old DeviceToken of the mutation.
func withDeviceToken(node *DeviceToken) devicetokenOption {
	return func(m *DeviceTokenMutation) {
		m.oldValue = func(context.Context) (*DeviceToken, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m DeviceTokenMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m DeviceTokenMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *DeviceTokenMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetDeviceCode sets the "device_code" field.
func (m *DeviceTokenMutation) SetDeviceCode(s string) {
	m.device_code = &s
}

// DeviceCode returns the value of the "device_code" field in the mutation.
func (m *DeviceTokenMutation) DeviceCode() (r string, exists bool) {
	v := m.device_code
	if v == nil {
		return
	}
	return *v, true
}

// OldDeviceCode returns the old "device_code" field's value of the DeviceToken entity.
// If the DeviceToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceTokenMutation) OldDeviceCode(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDeviceCode is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDeviceCode requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeviceCode: %w", err)
	}
	return oldValue.DeviceCode, nil
}

// ResetDeviceCode resets all changes to the "device_code" field.
func (m *DeviceTokenMutation) ResetDeviceCode() {
	m.device_code = nil
}

// SetStatus sets the "status" field.
func (m *DeviceTokenMutation) SetStatus(s string) {
	m.status = &s
}

// Status returns the value of the "status" field in the mutation.
func (m *DeviceTokenMutation) Status() (r string, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the DeviceToken entity.
// If the DeviceToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceTokenMutation) OldStatus(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *DeviceTokenMutation) ResetStatus() {
	m.status = nil
}

// SetToken sets the "token" field.
func (m *DeviceTokenMutation) SetToken(b []byte) {
	m.token = &b
}

// Token returns the value of the "token" field in the mutation.
func (m *DeviceTokenMutation) Token() (r []byte, exists bool) {
	v := m.token
	if v == nil {
		return
	}
	return *v, true
}

// OldToken returns the old "token" field's value of the DeviceToken entity.
// If the DeviceToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceTokenMutation) OldToken(ctx context.Context) (v *[]byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldToken is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldToken requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldToken: %w", err)
	}
	return oldValue.Token, nil
}

// ClearToken clears the value of the "token" field.
func (m *DeviceTokenMutation) ClearToken() {
	m.token = nil
	m.clearedFields[devicetoken.FieldToken] = struct{}{}
}

// TokenCleared returns if the "token" field was cleared in this mutation.
func (m *DeviceTokenMutation) TokenCleared() bool {
	_, ok := m.clearedFields[devicetoken.FieldToken]
	return ok
}

// ResetToken resets all changes to the "token" field.
func (m *DeviceTokenMutation) ResetToken() {
	m.token = nil
	delete(m.clearedFields, devicetoken.FieldToken)
}

// SetExpiry sets the "expiry" field.
func (m *DeviceTokenMutation) SetExpiry(t time.Time) {
	m.expiry = &t
}

// Expiry returns the value of the "expiry" field in the mutation.
func (m *DeviceTokenMutation) Expiry() (r time.Time, exists bool) {
	v := m.expiry
	if v == nil {
		return
	}
	return *v, true
}

// OldExpiry returns the old "expiry" field's value of the DeviceToken entity.
// If the DeviceToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceTokenMutation) OldExpiry(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldExpiry is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldExpiry requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldExpiry: %w", err)
	}
	return oldValue.Expiry, nil
}

// ResetExpiry resets all changes to the "expiry" field.
func (m *DeviceTokenMutation) ResetExpiry() {
	m.expiry = nil
}

// SetLastRequest sets the "last_request" field.
func (m *DeviceTokenMutation) SetLastRequest(t time.Time) {
	m.last_request = &t
}

// LastRequest returns the value of the "last_request" field in the mutation.
func (m *DeviceTokenMutation) LastRequest() (r time.Time, exists bool) {
	v := m.last_request
	if v == nil {
		return
	}
	return *v, true
}

// OldLastRequest returns the old "last_request" field's value of the DeviceToken entity.
// If the DeviceToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceTokenMutation) OldLastRequest(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldLastRequest is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldLastRequest requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastRequest: %w", err)
	}
	return oldValue.LastRequest, nil
}

// ResetLastRequest resets all changes to the "last_request" field.
func (m *DeviceTokenMutation) ResetLastRequest() {
	m.last_request = nil
}

// SetPollInterval sets the "poll_interval" field.
func (m *DeviceTokenMutation) SetPollInterval(i int) {
	m.poll_interval = &i
	m.addpoll_interval = nil
}

// PollInterval returns the value of the "poll_interval" field in the mutation.
func (m *DeviceTokenMutation) PollInterval() (r int, exists bool) {
	v := m.poll_interval
	if v == nil {
		return
	}
	return *v, true
}

// OldPollInterval returns the old "poll_interval" field's value of the DeviceToken entity.
// If the DeviceToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *DeviceTokenMutation) OldPollInterval(ctx context.Context) (v int, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldPollInterval is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldPollInterval requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPollInterval: %w", err)
	}
	return oldValue.PollInterval, nil
}

// AddPollInterval adds i to the "poll_interval" field.
func (m *DeviceTokenMutation) AddPollInterval(i int) {
	if m.addpoll_interval != nil {
		*m.addpoll_interval += i
	} else {
		m.addpoll_interval = &i
	}
}

// AddedPollInterval returns the value that was added to the "poll_interval" field in this mutation.
func (m *DeviceTokenMutation) AddedPollInterval() (r int, exists bool) {
	v := m.addpoll_interval
	if v == nil {
		return
	}
	return *v, true
}

// ResetPollInterval resets all changes to the "poll_interval" field.
func (m *DeviceTokenMutation) ResetPollInterval() {
	m.poll_interval = nil
	m.addpoll_interval = nil
}

// Op returns the operation name.
func (m *DeviceTokenMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (DeviceToken).
func (m *DeviceTokenMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *DeviceTokenMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.device_code != nil {
		fields = append(fields, devicetoken.FieldDeviceCode)
	}
	if m.status != nil {
		fields = append(fields, devicetoken.FieldStatus)
	}
	if m.token != nil {
		fields = append(fields, devicetoken.FieldToken)
	}
	if m.expiry != nil {
		fields = append(fields, devicetoken.FieldExpiry)
	}
	if m.last_request != nil {
		fields = append(fields, devicetoken.FieldLastRequest)
	}
	if m.poll_interval != nil {
		fields = append(fields, devicetoken.FieldPollInterval)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *DeviceTokenMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case devicetoken.FieldDeviceCode:
		return m.DeviceCode()
	case devicetoken.FieldStatus:
		return m.Status()
	case devicetoken.FieldToken:
		return m.Token()
	case devicetoken.FieldExpiry:
		return m.Expiry()
	case devicetoken.FieldLastRequest:
		return m.LastRequest()
	case devicetoken.FieldPollInterval:
		return m.PollInterval()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *DeviceTokenMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case devicetoken.FieldDeviceCode:
		return m.OldDeviceCode(ctx)
	case devicetoken.FieldStatus:
		return m.OldStatus(ctx)
	case devicetoken.FieldToken:
		return m.OldToken(ctx)
	case devicetoken.FieldExpiry:
		return m.OldExpiry(ctx)
	case devicetoken.FieldLastRequest:
		return m.OldLastRequest(ctx)
	case devicetoken.FieldPollInterval:
		return m.OldPollInterval(ctx)
	}
	return nil, fmt.Errorf("unknown DeviceToken field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DeviceTokenMutation) SetField(name string, value ent.Value) error {
	switch name {
	case devicetoken.FieldDeviceCode:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeviceCode(v)
		return nil
	case devicetoken.FieldStatus:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case devicetoken.FieldToken:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetToken(v)
		return nil
	case devicetoken.FieldExpiry:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetExpiry(v)
		return nil
	case devicetoken.FieldLastRequest:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastRequest(v)
		return nil
	case devicetoken.FieldPollInterval:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPollInterval(v)
		return nil
	}
	return fmt.Errorf("unknown DeviceToken field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *DeviceTokenMutation) AddedFields() []string {
	var fields []string
	if m.addpoll_interval != nil {
		fields = append(fields, devicetoken.FieldPollInterval)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *DeviceTokenMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case devicetoken.FieldPollInterval:
		return m.AddedPollInterval()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *DeviceTokenMutation) AddField(name string, value ent.Value) error {
	switch name {
	case devicetoken.FieldPollInterval:
		v, ok := value.(int)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddPollInterval(v)
		return nil
	}
	return fmt.Errorf("unknown DeviceToken numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *DeviceTokenMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(devicetoken.FieldToken) {
		fields = append(fields, devicetoken.FieldToken)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *DeviceTokenMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *DeviceTokenMutation) ClearField(name string) error {
	switch name {
	case devicetoken.FieldToken:
		m.ClearToken()
		return nil
	}
	return fmt.Errorf("unknown DeviceToken nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *DeviceTokenMutation) ResetField(name string) error {
	switch name {
	case devicetoken.FieldDeviceCode:
		m.ResetDeviceCode()
		return nil
	case devicetoken.FieldStatus:
		m.ResetStatus()
		return nil
	case devicetoken.FieldToken:
		m.ResetToken()
		return nil
	case devicetoken.FieldExpiry:
		m.ResetExpiry()
		return nil
	case devicetoken.FieldLastRequest:
		m.ResetLastRequest()
		return nil
	case devicetoken.FieldPollInterval:
		m.ResetPollInterval()
		return nil
	}
	return fmt.Errorf("unknown DeviceToken field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *DeviceTokenMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *DeviceTokenMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *DeviceTokenMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *DeviceTokenMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *DeviceTokenMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *DeviceTokenMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *DeviceTokenMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown DeviceToken unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *DeviceTokenMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown DeviceToken edge %s", name)
}

// KeysMutation represents an operation that mutates the Keys nodes in the graph.
type KeysMutation struct {
	config
	op                Op
	typ               string
	id                *string
	verification_keys *[]storage.VerificationKey
	signing_key       *jose.JSONWebKey
	signing_key_pub   *jose.JSONWebKey
	next_rotation     *time.Time
	clearedFields     map[string]struct{}
	done              bool
	oldValue          func(context.Context) (*Keys, error)
	predicates        []predicate.Keys
}

var _ ent.Mutation = (*KeysMutation)(nil)

// keysOption allows management of the mutation configuration using functional options.
type keysOption func(*KeysMutation)

// newKeysMutation creates new mutation for the Keys entity.
func newKeysMutation(c config, op Op, opts ...keysOption) *KeysMutation {
	m := &KeysMutation{
		config:        c,
		op:            op,
		typ:           TypeKeys,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withKeysID sets the ID field of the mutation.
func withKeysID(id string) keysOption {
	return func(m *KeysMutation) {
		var (
			err   error
			once  sync.Once
			value *Keys
		)
		m.oldValue = func(ctx context.Context) (*Keys, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Keys.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withKeys sets the old Keys of the mutation.
func withKeys(node *Keys) keysOption {
	return func(m *KeysMutation) {
		m.oldValue = func(context.Context) (*Keys, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m KeysMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m KeysMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Keys entities.
func (m *KeysMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *KeysMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetVerificationKeys sets the "verification_keys" field.
func (m *KeysMutation) SetVerificationKeys(sk []storage.VerificationKey) {
	m.verification_keys = &sk
}

// VerificationKeys returns the value of the "verification_keys" field in the mutation.
func (m *KeysMutation) VerificationKeys() (r []storage.VerificationKey, exists bool) {
	v := m.verification_keys
	if v == nil {
		return
	}
	return *v, true
}

// OldVerificationKeys returns the old "verification_keys" field's value of the Keys entity.
// If the Keys object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *KeysMutation) OldVerificationKeys(ctx context.Context) (v []storage.VerificationKey, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldVerificationKeys is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldVerificationKeys requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldVerificationKeys: %w", err)
	}
	return oldValue.VerificationKeys, nil
}

// ResetVerificationKeys resets all changes to the "verification_keys" field.
func (m *KeysMutation) ResetVerificationKeys() {
	m.verification_keys = nil
}

// SetSigningKey sets the "signing_key" field.
func (m *KeysMutation) SetSigningKey(jwk jose.JSONWebKey) {
	m.signing_key = &jwk
}

// SigningKey returns the value of the "signing_key" field in the mutation.
func (m *KeysMutation) SigningKey() (r jose.JSONWebKey, exists bool) {
	v := m.signing_key
	if v == nil {
		return
	}
	return *v, true
}

// OldSigningKey returns the old "signing_key" field's value of the Keys entity.
// If the Keys object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *KeysMutation) OldSigningKey(ctx context.Context) (v jose.JSONWebKey, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSigningKey is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSigningKey requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSigningKey: %w", err)
	}
	return oldValue.SigningKey, nil
}

// ResetSigningKey resets all changes to the "signing_key" field.
func (m *KeysMutation) ResetSigningKey() {
	m.signing_key = nil
}

// SetSigningKeyPub sets the "signing_key_pub" field.
func (m *KeysMutation) SetSigningKeyPub(jwk jose.JSONWebKey) {
	m.signing_key_pub = &jwk
}

// SigningKeyPub returns the value of the "signing_key_pub" field in the mutation.
func (m *KeysMutation) SigningKeyPub() (r jose.JSONWebKey, exists bool) {
	v := m.signing_key_pub
	if v == nil {
		return
	}
	return *v, true
}

// OldSigningKeyPub returns the old "signing_key_pub" field's value of the Keys entity.
// If the Keys object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *KeysMutation) OldSigningKeyPub(ctx context.Context) (v jose.JSONWebKey, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSigningKeyPub is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSigningKeyPub requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSigningKeyPub: %w", err)
	}
	return oldValue.SigningKeyPub, nil
}

// ResetSigningKeyPub resets all changes to the "signing_key_pub" field.
func (m *KeysMutation) ResetSigningKeyPub() {
	m.signing_key_pub = nil
}

// SetNextRotation sets the "next_rotation" field.
func (m *KeysMutation) SetNextRotation(t time.Time) {
	m.next_rotation = &t
}

// NextRotation returns the value of the "next_rotation" field in the mutation.
func (m *KeysMutation) NextRotation() (r time.Time, exists bool) {
	v := m.next_rotation
	if v == nil {
		return
	}
	return *v, true
}

// OldNextRotation returns the old "next_rotation" field's value of the Keys entity.
// If the Keys object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *KeysMutation) OldNextRotation(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNextRotation is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNextRotation requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNextRotation: %w", err)
	}
	return oldValue.NextRotation, nil
}

// ResetNextRotation resets all changes to the "next_rotation" field.
func (m *KeysMutation) ResetNextRotation() {
	m.next_rotation = nil
}

// Op returns the operation name.
func (m *KeysMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Keys).
func (m *KeysMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *KeysMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.verification_keys != nil {
		fields = append(fields, keys.FieldVerificationKeys)
	}
	if m.signing_key != nil {
		fields = append(fields, keys.FieldSigningKey)
	}
	if m.signing_key_pub != nil {
		fields = append(fields, keys.FieldSigningKeyPub)
	}
	if m.next_rotation != nil {
		fields = append(fields, keys.FieldNextRotation)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *KeysMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case keys.FieldVerificationKeys:
		return m.VerificationKeys()
	case keys.FieldSigningKey:
		return m.SigningKey()
	case keys.FieldSigningKeyPub:
		return m.SigningKeyPub()
	case keys.FieldNextRotation:
		return m.NextRotation()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *KeysMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case keys.FieldVerificationKeys:
		return m.OldVerificationKeys(ctx)
	case keys.FieldSigningKey:
		return m.OldSigningKey(ctx)
	case keys.FieldSigningKeyPub:
		return m.OldSigningKeyPub(ctx)
	case keys.FieldNextRotation:
		return m.OldNextRotation(ctx)
	}
	return nil, fmt.Errorf("unknown Keys field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *KeysMutation) SetField(name string, value ent.Value) error {
	switch name {
	case keys.FieldVerificationKeys:
		v, ok := value.([]storage.VerificationKey)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetVerificationKeys(v)
		return nil
	case keys.FieldSigningKey:
		v, ok := value.(jose.JSONWebKey)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSigningKey(v)
		return nil
	case keys.FieldSigningKeyPub:
		v, ok := value.(jose.JSONWebKey)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSigningKeyPub(v)
		return nil
	case keys.FieldNextRotation:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNextRotation(v)
		return nil
	}
	return fmt.Errorf("unknown Keys field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *KeysMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *KeysMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *KeysMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Keys numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *KeysMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *KeysMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *KeysMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Keys nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *KeysMutation) ResetField(name string) error {
	switch name {
	case keys.FieldVerificationKeys:
		m.ResetVerificationKeys()
		return nil
	case keys.FieldSigningKey:
		m.ResetSigningKey()
		return nil
	case keys.FieldSigningKeyPub:
		m.ResetSigningKeyPub()
		return nil
	case keys.FieldNextRotation:
		m.ResetNextRotation()
		return nil
	}
	return fmt.Errorf("unknown Keys field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *KeysMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *KeysMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *KeysMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *KeysMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *KeysMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *KeysMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *KeysMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Keys unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *KeysMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Keys edge %s", name)
}

// OAuth2ClientMutation represents an operation that mutates the OAuth2Client nodes in the graph.
type OAuth2ClientMutation struct {
	config
	op            Op
	typ           string
	id            *string
	secret        *string
	redirect_uris *[]string
	trusted_peers *[]string
	public        *bool
	name          *string
	logo_url      *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*OAuth2Client, error)
	predicates    []predicate.OAuth2Client
}

var _ ent.Mutation = (*OAuth2ClientMutation)(nil)

// oauth2clientOption allows management of the mutation configuration using functional options.
type oauth2clientOption func(*OAuth2ClientMutation)

// newOAuth2ClientMutation creates new mutation for the OAuth2Client entity.
func newOAuth2ClientMutation(c config, op Op, opts ...oauth2clientOption) *OAuth2ClientMutation {
	m := &OAuth2ClientMutation{
		config:        c,
		op:            op,
		typ:           TypeOAuth2Client,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withOAuth2ClientID sets the ID field of the mutation.
func withOAuth2ClientID(id string) oauth2clientOption {
	return func(m *OAuth2ClientMutation) {
		var (
			err   error
			once  sync.Once
			value *OAuth2Client
		)
		m.oldValue = func(ctx context.Context) (*OAuth2Client, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().OAuth2Client.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withOAuth2Client sets the old OAuth2Client of the mutation.
func withOAuth2Client(node *OAuth2Client) oauth2clientOption {
	return func(m *OAuth2ClientMutation) {
		m.oldValue = func(context.Context) (*OAuth2Client, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m OAuth2ClientMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m OAuth2ClientMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of OAuth2Client entities.
func (m *OAuth2ClientMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *OAuth2ClientMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetSecret sets the "secret" field.
func (m *OAuth2ClientMutation) SetSecret(s string) {
	m.secret = &s
}

// Secret returns the value of the "secret" field in the mutation.
func (m *OAuth2ClientMutation) Secret() (r string, exists bool) {
	v := m.secret
	if v == nil {
		return
	}
	return *v, true
}

// OldSecret returns the old "secret" field's value of the OAuth2Client entity.
// If the OAuth2Client object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OAuth2ClientMutation) OldSecret(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldSecret is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldSecret requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldSecret: %w", err)
	}
	return oldValue.Secret, nil
}

// ResetSecret resets all changes to the "secret" field.
func (m *OAuth2ClientMutation) ResetSecret() {
	m.secret = nil
}

// SetRedirectUris sets the "redirect_uris" field.
func (m *OAuth2ClientMutation) SetRedirectUris(s []string) {
	m.redirect_uris = &s
}

// RedirectUris returns the value of the "redirect_uris" field in the mutation.
func (m *OAuth2ClientMutation) RedirectUris() (r []string, exists bool) {
	v := m.redirect_uris
	if v == nil {
		return
	}
	return *v, true
}

// OldRedirectUris returns the old "redirect_uris" field's value of the OAuth2Client entity.
// If the OAuth2Client object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OAuth2ClientMutation) OldRedirectUris(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldRedirectUris is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldRedirectUris requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRedirectUris: %w", err)
	}
	return oldValue.RedirectUris, nil
}

// ClearRedirectUris clears the value of the "redirect_uris" field.
func (m *OAuth2ClientMutation) ClearRedirectUris() {
	m.redirect_uris = nil
	m.clearedFields[oauth2client.FieldRedirectUris] = struct{}{}
}

// RedirectUrisCleared returns if the "redirect_uris" field was cleared in this mutation.
func (m *OAuth2ClientMutation) RedirectUrisCleared() bool {
	_, ok := m.clearedFields[oauth2client.FieldRedirectUris]
	return ok
}

// ResetRedirectUris resets all changes to the "redirect_uris" field.
func (m *OAuth2ClientMutation) ResetRedirectUris() {
	m.redirect_uris = nil
	delete(m.clearedFields, oauth2client.FieldRedirectUris)
}

// SetTrustedPeers sets the "trusted_peers" field.
func (m *OAuth2ClientMutation) SetTrustedPeers(s []string) {
	m.trusted_peers = &s
}

// TrustedPeers returns the value of the "trusted_peers" field in the mutation.
func (m *OAuth2ClientMutation) TrustedPeers() (r []string, exists bool) {
	v := m.trusted_peers
	if v == nil {
		return
	}
	return *v, true
}

// OldTrustedPeers returns the old "trusted_peers" field's value of the OAuth2Client entity.
// If the OAuth2Client object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OAuth2ClientMutation) OldTrustedPeers(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldTrustedPeers is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldTrustedPeers requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTrustedPeers: %w", err)
	}
	return oldValue.TrustedPeers, nil
}

// ClearTrustedPeers clears the value of the "trusted_peers" field.
func (m *OAuth2ClientMutation) ClearTrustedPeers() {
	m.trusted_peers = nil
	m.clearedFields[oauth2client.FieldTrustedPeers] = struct{}{}
}

// TrustedPeersCleared returns if the "trusted_peers" field was cleared in this mutation.
func (m *OAuth2ClientMutation) TrustedPeersCleared() bool {
	_, ok := m.clearedFields[oauth2client.FieldTrustedPeers]
	return ok
}

// ResetTrustedPeers resets all changes to the "trusted_peers" field.
func (m *OAuth2ClientMutation) ResetTrustedPeers() {
	m.trusted_peers = nil
	delete(m.clearedFields, oauth2client.FieldTrustedPeers)
}

// SetPublic sets the "public" field.
func (m *OAuth2ClientMutation) SetPublic(b bool) {
	m.public = &b
}

// Public returns the value of the "public" field in the mutation.
func (m *OAuth2ClientMutation) Public() (r bool, exists bool) {
	v := m.public
	if v == nil {
		return
	}
	return *v, true
}

// OldPublic returns the old "public" field's value of the OAuth2Client entity.
// If the OAuth2Client object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OAuth2ClientMutation) OldPublic(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldPublic is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldPublic requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPublic: %w", err)
	}
	return oldValue.Public, nil
}

// ResetPublic resets all changes to the "public" field.
func (m *OAuth2ClientMutation) ResetPublic() {
	m.public = nil
}

// SetName sets the "name" field.
func (m *OAuth2ClientMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *OAuth2ClientMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the OAuth2Client entity.
// If the OAuth2Client object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OAuth2ClientMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *OAuth2ClientMutation) ResetName() {
	m.name = nil
}

// SetLogoURL sets the "logo_url" field.
func (m *OAuth2ClientMutation) SetLogoURL(s string) {
	m.logo_url = &s
}

// LogoURL returns the value of the "logo_url" field in the mutation.
func (m *OAuth2ClientMutation) LogoURL() (r string, exists bool) {
	v := m.logo_url
	if v == nil {
		return
	}
	return *v, true
}

// OldLogoURL returns the old "logo_url" field's value of the OAuth2Client entity.
// If the OAuth2Client object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OAuth2ClientMutation) OldLogoURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldLogoURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldLogoURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLogoURL: %w", err)
	}
	return oldValue.LogoURL, nil
}

// ResetLogoURL resets all changes to the "logo_url" field.
func (m *OAuth2ClientMutation) ResetLogoURL() {
	m.logo_url = nil
}

// Op returns the operation name.
func (m *OAuth2ClientMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (OAuth2Client).
func (m *OAuth2ClientMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *OAuth2ClientMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.secret != nil {
		fields = append(fields, oauth2client.FieldSecret)
	}
	if m.redirect_uris != nil {
		fields = append(fields, oauth2client.FieldRedirectUris)
	}
	if m.trusted_peers != nil {
		fields = append(fields, oauth2client.FieldTrustedPeers)
	}
	if m.public != nil {
		fields = append(fields, oauth2client.FieldPublic)
	}
	if m.name != nil {
		fields = append(fields, oauth2client.FieldName)
	}
	if m.logo_url != nil {
		fields = append(fields, oauth2client.FieldLogoURL)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *OAuth2ClientMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case oauth2client.FieldSecret:
		return m.Secret()
	case oauth2client.FieldRedirectUris:
		return m.RedirectUris()
	case oauth2client.FieldTrustedPeers:
		return m.TrustedPeers()
	case oauth2client.FieldPublic:
		return m.Public()
	case oauth2client.FieldName:
		return m.Name()
	case oauth2client.FieldLogoURL:
		return m.LogoURL()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *OAuth2ClientMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case oauth2client.FieldSecret:
		return m.OldSecret(ctx)
	case oauth2client.FieldRedirectUris:
		return m.OldRedirectUris(ctx)
	case oauth2client.FieldTrustedPeers:
		return m.OldTrustedPeers(ctx)
	case oauth2client.FieldPublic:
		return m.OldPublic(ctx)
	case oauth2client.FieldName:
		return m.OldName(ctx)
	case oauth2client.FieldLogoURL:
		return m.OldLogoURL(ctx)
	}
	return nil, fmt.Errorf("unknown OAuth2Client field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *OAuth2ClientMutation) SetField(name string, value ent.Value) error {
	switch name {
	case oauth2client.FieldSecret:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetSecret(v)
		return nil
	case oauth2client.FieldRedirectUris:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRedirectUris(v)
		return nil
	case oauth2client.FieldTrustedPeers:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTrustedPeers(v)
		return nil
	case oauth2client.FieldPublic:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPublic(v)
		return nil
	case oauth2client.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case oauth2client.FieldLogoURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLogoURL(v)
		return nil
	}
	return fmt.Errorf("unknown OAuth2Client field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *OAuth2ClientMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *OAuth2ClientMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *OAuth2ClientMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown OAuth2Client numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *OAuth2ClientMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(oauth2client.FieldRedirectUris) {
		fields = append(fields, oauth2client.FieldRedirectUris)
	}
	if m.FieldCleared(oauth2client.FieldTrustedPeers) {
		fields = append(fields, oauth2client.FieldTrustedPeers)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *OAuth2ClientMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *OAuth2ClientMutation) ClearField(name string) error {
	switch name {
	case oauth2client.FieldRedirectUris:
		m.ClearRedirectUris()
		return nil
	case oauth2client.FieldTrustedPeers:
		m.ClearTrustedPeers()
		return nil
	}
	return fmt.Errorf("unknown OAuth2Client nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *OAuth2ClientMutation) ResetField(name string) error {
	switch name {
	case oauth2client.FieldSecret:
		m.ResetSecret()
		return nil
	case oauth2client.FieldRedirectUris:
		m.ResetRedirectUris()
		return nil
	case oauth2client.FieldTrustedPeers:
		m.ResetTrustedPeers()
		return nil
	case oauth2client.FieldPublic:
		m.ResetPublic()
		return nil
	case oauth2client.FieldName:
		m.ResetName()
		return nil
	case oauth2client.FieldLogoURL:
		m.ResetLogoURL()
		return nil
	}
	return fmt.Errorf("unknown OAuth2Client field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *OAuth2ClientMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *OAuth2ClientMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *OAuth2ClientMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *OAuth2ClientMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *OAuth2ClientMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *OAuth2ClientMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *OAuth2ClientMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown OAuth2Client unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *OAuth2ClientMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown OAuth2Client edge %s", name)
}

// OfflineSessionMutation represents an operation that mutates the OfflineSession nodes in the graph.
type OfflineSessionMutation struct {
	config
	op             Op
	typ            string
	id             *string
	user_id        *string
	conn_id        *string
	refresh        *[]byte
	connector_data *[]byte
	clearedFields  map[string]struct{}
	done           bool
	oldValue       func(context.Context) (*OfflineSession, error)
	predicates     []predicate.OfflineSession
}

var _ ent.Mutation = (*OfflineSessionMutation)(nil)

// offlinesessionOption allows management of the mutation configuration using functional options.
type offlinesessionOption func(*OfflineSessionMutation)

// newOfflineSessionMutation creates new mutation for the OfflineSession entity.
func newOfflineSessionMutation(c config, op Op, opts ...offlinesessionOption) *OfflineSessionMutation {
	m := &OfflineSessionMutation{
		config:        c,
		op:            op,
		typ:           TypeOfflineSession,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withOfflineSessionID sets the ID field of the mutation.
func withOfflineSessionID(id string) offlinesessionOption {
	return func(m *OfflineSessionMutation) {
		var (
			err   error
			once  sync.Once
			value *OfflineSession
		)
		m.oldValue = func(ctx context.Context) (*OfflineSession, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().OfflineSession.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withOfflineSession sets the old OfflineSession of the mutation.
func withOfflineSession(node *OfflineSession) offlinesessionOption {
	return func(m *OfflineSessionMutation) {
		m.oldValue = func(context.Context) (*OfflineSession, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m OfflineSessionMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m OfflineSessionMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of OfflineSession entities.
func (m *OfflineSessionMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *OfflineSessionMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetUserID sets the "user_id" field.
func (m *OfflineSessionMutation) SetUserID(s string) {
	m.user_id = &s
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *OfflineSessionMutation) UserID() (r string, exists bool) {
	v := m.user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the OfflineSession entity.
// If the OfflineSession object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OfflineSessionMutation) OldUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *OfflineSessionMutation) ResetUserID() {
	m.user_id = nil
}

// SetConnID sets the "conn_id" field.
func (m *OfflineSessionMutation) SetConnID(s string) {
	m.conn_id = &s
}

// ConnID returns the value of the "conn_id" field in the mutation.
func (m *OfflineSessionMutation) ConnID() (r string, exists bool) {
	v := m.conn_id
	if v == nil {
		return
	}
	return *v, true
}

// OldConnID returns the old "conn_id" field's value of the OfflineSession entity.
// If the OfflineSession object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OfflineSessionMutation) OldConnID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnID: %w", err)
	}
	return oldValue.ConnID, nil
}

// ResetConnID resets all changes to the "conn_id" field.
func (m *OfflineSessionMutation) ResetConnID() {
	m.conn_id = nil
}

// SetRefresh sets the "refresh" field.
func (m *OfflineSessionMutation) SetRefresh(b []byte) {
	m.refresh = &b
}

// Refresh returns the value of the "refresh" field in the mutation.
func (m *OfflineSessionMutation) Refresh() (r []byte, exists bool) {
	v := m.refresh
	if v == nil {
		return
	}
	return *v, true
}

// OldRefresh returns the old "refresh" field's value of the OfflineSession entity.
// If the OfflineSession object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OfflineSessionMutation) OldRefresh(ctx context.Context) (v []byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldRefresh is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldRefresh requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRefresh: %w", err)
	}
	return oldValue.Refresh, nil
}

// ResetRefresh resets all changes to the "refresh" field.
func (m *OfflineSessionMutation) ResetRefresh() {
	m.refresh = nil
}

// SetConnectorData sets the "connector_data" field.
func (m *OfflineSessionMutation) SetConnectorData(b []byte) {
	m.connector_data = &b
}

// ConnectorData returns the value of the "connector_data" field in the mutation.
func (m *OfflineSessionMutation) ConnectorData() (r []byte, exists bool) {
	v := m.connector_data
	if v == nil {
		return
	}
	return *v, true
}

// OldConnectorData returns the old "connector_data" field's value of the OfflineSession entity.
// If the OfflineSession object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *OfflineSessionMutation) OldConnectorData(ctx context.Context) (v *[]byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnectorData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnectorData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnectorData: %w", err)
	}
	return oldValue.ConnectorData, nil
}

// ClearConnectorData clears the value of the "connector_data" field.
func (m *OfflineSessionMutation) ClearConnectorData() {
	m.connector_data = nil
	m.clearedFields[offlinesession.FieldConnectorData] = struct{}{}
}

// ConnectorDataCleared returns if the "connector_data" field was cleared in this mutation.
func (m *OfflineSessionMutation) ConnectorDataCleared() bool {
	_, ok := m.clearedFields[offlinesession.FieldConnectorData]
	return ok
}

// ResetConnectorData resets all changes to the "connector_data" field.
func (m *OfflineSessionMutation) ResetConnectorData() {
	m.connector_data = nil
	delete(m.clearedFields, offlinesession.FieldConnectorData)
}

// Op returns the operation name.
func (m *OfflineSessionMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (OfflineSession).
func (m *OfflineSessionMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *OfflineSessionMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.user_id != nil {
		fields = append(fields, offlinesession.FieldUserID)
	}
	if m.conn_id != nil {
		fields = append(fields, offlinesession.FieldConnID)
	}
	if m.refresh != nil {
		fields = append(fields, offlinesession.FieldRefresh)
	}
	if m.connector_data != nil {
		fields = append(fields, offlinesession.FieldConnectorData)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *OfflineSessionMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case offlinesession.FieldUserID:
		return m.UserID()
	case offlinesession.FieldConnID:
		return m.ConnID()
	case offlinesession.FieldRefresh:
		return m.Refresh()
	case offlinesession.FieldConnectorData:
		return m.ConnectorData()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *OfflineSessionMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case offlinesession.FieldUserID:
		return m.OldUserID(ctx)
	case offlinesession.FieldConnID:
		return m.OldConnID(ctx)
	case offlinesession.FieldRefresh:
		return m.OldRefresh(ctx)
	case offlinesession.FieldConnectorData:
		return m.OldConnectorData(ctx)
	}
	return nil, fmt.Errorf("unknown OfflineSession field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *OfflineSessionMutation) SetField(name string, value ent.Value) error {
	switch name {
	case offlinesession.FieldUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case offlinesession.FieldConnID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnID(v)
		return nil
	case offlinesession.FieldRefresh:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRefresh(v)
		return nil
	case offlinesession.FieldConnectorData:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnectorData(v)
		return nil
	}
	return fmt.Errorf("unknown OfflineSession field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *OfflineSessionMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *OfflineSessionMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *OfflineSessionMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown OfflineSession numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *OfflineSessionMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(offlinesession.FieldConnectorData) {
		fields = append(fields, offlinesession.FieldConnectorData)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *OfflineSessionMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *OfflineSessionMutation) ClearField(name string) error {
	switch name {
	case offlinesession.FieldConnectorData:
		m.ClearConnectorData()
		return nil
	}
	return fmt.Errorf("unknown OfflineSession nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *OfflineSessionMutation) ResetField(name string) error {
	switch name {
	case offlinesession.FieldUserID:
		m.ResetUserID()
		return nil
	case offlinesession.FieldConnID:
		m.ResetConnID()
		return nil
	case offlinesession.FieldRefresh:
		m.ResetRefresh()
		return nil
	case offlinesession.FieldConnectorData:
		m.ResetConnectorData()
		return nil
	}
	return fmt.Errorf("unknown OfflineSession field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *OfflineSessionMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *OfflineSessionMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *OfflineSessionMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *OfflineSessionMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *OfflineSessionMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *OfflineSessionMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *OfflineSessionMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown OfflineSession unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *OfflineSessionMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown OfflineSession edge %s", name)
}

// PasswordMutation represents an operation that mutates the Password nodes in the graph.
type PasswordMutation struct {
	config
	op            Op
	typ           string
	id            *int
	email         *string
	hash          *[]byte
	username      *string
	user_id       *string
	clearedFields map[string]struct{}
	done          bool
	oldValue      func(context.Context) (*Password, error)
	predicates    []predicate.Password
}

var _ ent.Mutation = (*PasswordMutation)(nil)

// passwordOption allows management of the mutation configuration using functional options.
type passwordOption func(*PasswordMutation)

// newPasswordMutation creates new mutation for the Password entity.
func newPasswordMutation(c config, op Op, opts ...passwordOption) *PasswordMutation {
	m := &PasswordMutation{
		config:        c,
		op:            op,
		typ:           TypePassword,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withPasswordID sets the ID field of the mutation.
func withPasswordID(id int) passwordOption {
	return func(m *PasswordMutation) {
		var (
			err   error
			once  sync.Once
			value *Password
		)
		m.oldValue = func(ctx context.Context) (*Password, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Password.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withPassword sets the old Password of the mutation.
func withPassword(node *Password) passwordOption {
	return func(m *PasswordMutation) {
		m.oldValue = func(context.Context) (*Password, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m PasswordMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m PasswordMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *PasswordMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetEmail sets the "email" field.
func (m *PasswordMutation) SetEmail(s string) {
	m.email = &s
}

// Email returns the value of the "email" field in the mutation.
func (m *PasswordMutation) Email() (r string, exists bool) {
	v := m.email
	if v == nil {
		return
	}
	return *v, true
}

// OldEmail returns the old "email" field's value of the Password entity.
// If the Password object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PasswordMutation) OldEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldEmail: %w", err)
	}
	return oldValue.Email, nil
}

// ResetEmail resets all changes to the "email" field.
func (m *PasswordMutation) ResetEmail() {
	m.email = nil
}

// SetHash sets the "hash" field.
func (m *PasswordMutation) SetHash(b []byte) {
	m.hash = &b
}

// Hash returns the value of the "hash" field in the mutation.
func (m *PasswordMutation) Hash() (r []byte, exists bool) {
	v := m.hash
	if v == nil {
		return
	}
	return *v, true
}

// OldHash returns the old "hash" field's value of the Password entity.
// If the Password object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PasswordMutation) OldHash(ctx context.Context) (v []byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldHash is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldHash requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldHash: %w", err)
	}
	return oldValue.Hash, nil
}

// ResetHash resets all changes to the "hash" field.
func (m *PasswordMutation) ResetHash() {
	m.hash = nil
}

// SetUsername sets the "username" field.
func (m *PasswordMutation) SetUsername(s string) {
	m.username = &s
}

// Username returns the value of the "username" field in the mutation.
func (m *PasswordMutation) Username() (r string, exists bool) {
	v := m.username
	if v == nil {
		return
	}
	return *v, true
}

// OldUsername returns the old "username" field's value of the Password entity.
// If the Password object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PasswordMutation) OldUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUsername: %w", err)
	}
	return oldValue.Username, nil
}

// ResetUsername resets all changes to the "username" field.
func (m *PasswordMutation) ResetUsername() {
	m.username = nil
}

// SetUserID sets the "user_id" field.
func (m *PasswordMutation) SetUserID(s string) {
	m.user_id = &s
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *PasswordMutation) UserID() (r string, exists bool) {
	v := m.user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the Password entity.
// If the Password object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *PasswordMutation) OldUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *PasswordMutation) ResetUserID() {
	m.user_id = nil
}

// Op returns the operation name.
func (m *PasswordMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Password).
func (m *PasswordMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *PasswordMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.email != nil {
		fields = append(fields, password.FieldEmail)
	}
	if m.hash != nil {
		fields = append(fields, password.FieldHash)
	}
	if m.username != nil {
		fields = append(fields, password.FieldUsername)
	}
	if m.user_id != nil {
		fields = append(fields, password.FieldUserID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *PasswordMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case password.FieldEmail:
		return m.Email()
	case password.FieldHash:
		return m.Hash()
	case password.FieldUsername:
		return m.Username()
	case password.FieldUserID:
		return m.UserID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *PasswordMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case password.FieldEmail:
		return m.OldEmail(ctx)
	case password.FieldHash:
		return m.OldHash(ctx)
	case password.FieldUsername:
		return m.OldUsername(ctx)
	case password.FieldUserID:
		return m.OldUserID(ctx)
	}
	return nil, fmt.Errorf("unknown Password field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PasswordMutation) SetField(name string, value ent.Value) error {
	switch name {
	case password.FieldEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetEmail(v)
		return nil
	case password.FieldHash:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetHash(v)
		return nil
	case password.FieldUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUsername(v)
		return nil
	case password.FieldUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	}
	return fmt.Errorf("unknown Password field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *PasswordMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *PasswordMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *PasswordMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Password numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *PasswordMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *PasswordMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *PasswordMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Password nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *PasswordMutation) ResetField(name string) error {
	switch name {
	case password.FieldEmail:
		m.ResetEmail()
		return nil
	case password.FieldHash:
		m.ResetHash()
		return nil
	case password.FieldUsername:
		m.ResetUsername()
		return nil
	case password.FieldUserID:
		m.ResetUserID()
		return nil
	}
	return fmt.Errorf("unknown Password field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *PasswordMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *PasswordMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *PasswordMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *PasswordMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *PasswordMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *PasswordMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *PasswordMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown Password unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *PasswordMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown Password edge %s", name)
}

// RefreshTokenMutation represents an operation that mutates the RefreshToken nodes in the graph.
type RefreshTokenMutation struct {
	config
	op                        Op
	typ                       string
	id                        *string
	client_id                 *string
	scopes                    *[]string
	nonce                     *string
	claims_user_id            *string
	claims_username           *string
	claims_email              *string
	claims_email_verified     *bool
	claims_groups             *[]string
	claims_preferred_username *string
	connector_id              *string
	connector_data            *[]byte
	token                     *string
	obsolete_token            *string
	created_at                *time.Time
	last_used                 *time.Time
	clearedFields             map[string]struct{}
	done                      bool
	oldValue                  func(context.Context) (*RefreshToken, error)
	predicates                []predicate.RefreshToken
}

var _ ent.Mutation = (*RefreshTokenMutation)(nil)

// refreshtokenOption allows management of the mutation configuration using functional options.
type refreshtokenOption func(*RefreshTokenMutation)

// newRefreshTokenMutation creates new mutation for the RefreshToken entity.
func newRefreshTokenMutation(c config, op Op, opts ...refreshtokenOption) *RefreshTokenMutation {
	m := &RefreshTokenMutation{
		config:        c,
		op:            op,
		typ:           TypeRefreshToken,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withRefreshTokenID sets the ID field of the mutation.
func withRefreshTokenID(id string) refreshtokenOption {
	return func(m *RefreshTokenMutation) {
		var (
			err   error
			once  sync.Once
			value *RefreshToken
		)
		m.oldValue = func(ctx context.Context) (*RefreshToken, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().RefreshToken.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withRefreshToken sets the old RefreshToken of the mutation.
func withRefreshToken(node *RefreshToken) refreshtokenOption {
	return func(m *RefreshTokenMutation) {
		m.oldValue = func(context.Context) (*RefreshToken, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m RefreshTokenMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m RefreshTokenMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("db: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of RefreshToken entities.
func (m *RefreshTokenMutation) SetID(id string) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *RefreshTokenMutation) ID() (id string, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetClientID sets the "client_id" field.
func (m *RefreshTokenMutation) SetClientID(s string) {
	m.client_id = &s
}

// ClientID returns the value of the "client_id" field in the mutation.
func (m *RefreshTokenMutation) ClientID() (r string, exists bool) {
	v := m.client_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClientID returns the old "client_id" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldClientID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClientID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClientID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClientID: %w", err)
	}
	return oldValue.ClientID, nil
}

// ResetClientID resets all changes to the "client_id" field.
func (m *RefreshTokenMutation) ResetClientID() {
	m.client_id = nil
}

// SetScopes sets the "scopes" field.
func (m *RefreshTokenMutation) SetScopes(s []string) {
	m.scopes = &s
}

// Scopes returns the value of the "scopes" field in the mutation.
func (m *RefreshTokenMutation) Scopes() (r []string, exists bool) {
	v := m.scopes
	if v == nil {
		return
	}
	return *v, true
}

// OldScopes returns the old "scopes" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldScopes(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldScopes is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldScopes requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldScopes: %w", err)
	}
	return oldValue.Scopes, nil
}

// ClearScopes clears the value of the "scopes" field.
func (m *RefreshTokenMutation) ClearScopes() {
	m.scopes = nil
	m.clearedFields[refreshtoken.FieldScopes] = struct{}{}
}

// ScopesCleared returns if the "scopes" field was cleared in this mutation.
func (m *RefreshTokenMutation) ScopesCleared() bool {
	_, ok := m.clearedFields[refreshtoken.FieldScopes]
	return ok
}

// ResetScopes resets all changes to the "scopes" field.
func (m *RefreshTokenMutation) ResetScopes() {
	m.scopes = nil
	delete(m.clearedFields, refreshtoken.FieldScopes)
}

// SetNonce sets the "nonce" field.
func (m *RefreshTokenMutation) SetNonce(s string) {
	m.nonce = &s
}

// Nonce returns the value of the "nonce" field in the mutation.
func (m *RefreshTokenMutation) Nonce() (r string, exists bool) {
	v := m.nonce
	if v == nil {
		return
	}
	return *v, true
}

// OldNonce returns the old "nonce" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldNonce(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldNonce is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldNonce requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldNonce: %w", err)
	}
	return oldValue.Nonce, nil
}

// ResetNonce resets all changes to the "nonce" field.
func (m *RefreshTokenMutation) ResetNonce() {
	m.nonce = nil
}

// SetClaimsUserID sets the "claims_user_id" field.
func (m *RefreshTokenMutation) SetClaimsUserID(s string) {
	m.claims_user_id = &s
}

// ClaimsUserID returns the value of the "claims_user_id" field in the mutation.
func (m *RefreshTokenMutation) ClaimsUserID() (r string, exists bool) {
	v := m.claims_user_id
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsUserID returns the old "claims_user_id" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldClaimsUserID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsUserID: %w", err)
	}
	return oldValue.ClaimsUserID, nil
}

// ResetClaimsUserID resets all changes to the "claims_user_id" field.
func (m *RefreshTokenMutation) ResetClaimsUserID() {
	m.claims_user_id = nil
}

// SetClaimsUsername sets the "claims_username" field.
func (m *RefreshTokenMutation) SetClaimsUsername(s string) {
	m.claims_username = &s
}

// ClaimsUsername returns the value of the "claims_username" field in the mutation.
func (m *RefreshTokenMutation) ClaimsUsername() (r string, exists bool) {
	v := m.claims_username
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsUsername returns the old "claims_username" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldClaimsUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsUsername: %w", err)
	}
	return oldValue.ClaimsUsername, nil
}

// ResetClaimsUsername resets all changes to the "claims_username" field.
func (m *RefreshTokenMutation) ResetClaimsUsername() {
	m.claims_username = nil
}

// SetClaimsEmail sets the "claims_email" field.
func (m *RefreshTokenMutation) SetClaimsEmail(s string) {
	m.claims_email = &s
}

// ClaimsEmail returns the value of the "claims_email" field in the mutation.
func (m *RefreshTokenMutation) ClaimsEmail() (r string, exists bool) {
	v := m.claims_email
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsEmail returns the old "claims_email" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldClaimsEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsEmail: %w", err)
	}
	return oldValue.ClaimsEmail, nil
}

// ResetClaimsEmail resets all changes to the "claims_email" field.
func (m *RefreshTokenMutation) ResetClaimsEmail() {
	m.claims_email = nil
}

// SetClaimsEmailVerified sets the "claims_email_verified" field.
func (m *RefreshTokenMutation) SetClaimsEmailVerified(b bool) {
	m.claims_email_verified = &b
}

// ClaimsEmailVerified returns the value of the "claims_email_verified" field in the mutation.
func (m *RefreshTokenMutation) ClaimsEmailVerified() (r bool, exists bool) {
	v := m.claims_email_verified
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsEmailVerified returns the old "claims_email_verified" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldClaimsEmailVerified(ctx context.Context) (v bool, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsEmailVerified is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsEmailVerified requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsEmailVerified: %w", err)
	}
	return oldValue.ClaimsEmailVerified, nil
}

// ResetClaimsEmailVerified resets all changes to the "claims_email_verified" field.
func (m *RefreshTokenMutation) ResetClaimsEmailVerified() {
	m.claims_email_verified = nil
}

// SetClaimsGroups sets the "claims_groups" field.
func (m *RefreshTokenMutation) SetClaimsGroups(s []string) {
	m.claims_groups = &s
}

// ClaimsGroups returns the value of the "claims_groups" field in the mutation.
func (m *RefreshTokenMutation) ClaimsGroups() (r []string, exists bool) {
	v := m.claims_groups
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsGroups returns the old "claims_groups" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldClaimsGroups(ctx context.Context) (v []string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsGroups is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsGroups requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsGroups: %w", err)
	}
	return oldValue.ClaimsGroups, nil
}

// ClearClaimsGroups clears the value of the "claims_groups" field.
func (m *RefreshTokenMutation) ClearClaimsGroups() {
	m.claims_groups = nil
	m.clearedFields[refreshtoken.FieldClaimsGroups] = struct{}{}
}

// ClaimsGroupsCleared returns if the "claims_groups" field was cleared in this mutation.
func (m *RefreshTokenMutation) ClaimsGroupsCleared() bool {
	_, ok := m.clearedFields[refreshtoken.FieldClaimsGroups]
	return ok
}

// ResetClaimsGroups resets all changes to the "claims_groups" field.
func (m *RefreshTokenMutation) ResetClaimsGroups() {
	m.claims_groups = nil
	delete(m.clearedFields, refreshtoken.FieldClaimsGroups)
}

// SetClaimsPreferredUsername sets the "claims_preferred_username" field.
func (m *RefreshTokenMutation) SetClaimsPreferredUsername(s string) {
	m.claims_preferred_username = &s
}

// ClaimsPreferredUsername returns the value of the "claims_preferred_username" field in the mutation.
func (m *RefreshTokenMutation) ClaimsPreferredUsername() (r string, exists bool) {
	v := m.claims_preferred_username
	if v == nil {
		return
	}
	return *v, true
}

// OldClaimsPreferredUsername returns the old "claims_preferred_username" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldClaimsPreferredUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldClaimsPreferredUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldClaimsPreferredUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldClaimsPreferredUsername: %w", err)
	}
	return oldValue.ClaimsPreferredUsername, nil
}

// ResetClaimsPreferredUsername resets all changes to the "claims_preferred_username" field.
func (m *RefreshTokenMutation) ResetClaimsPreferredUsername() {
	m.claims_preferred_username = nil
}

// SetConnectorID sets the "connector_id" field.
func (m *RefreshTokenMutation) SetConnectorID(s string) {
	m.connector_id = &s
}

// ConnectorID returns the value of the "connector_id" field in the mutation.
func (m *RefreshTokenMutation) ConnectorID() (r string, exists bool) {
	v := m.connector_id
	if v == nil {
		return
	}
	return *v, true
}

// OldConnectorID returns the old "connector_id" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldConnectorID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnectorID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnectorID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnectorID: %w", err)
	}
	return oldValue.ConnectorID, nil
}

// ResetConnectorID resets all changes to the "connector_id" field.
func (m *RefreshTokenMutation) ResetConnectorID() {
	m.connector_id = nil
}

// SetConnectorData sets the "connector_data" field.
func (m *RefreshTokenMutation) SetConnectorData(b []byte) {
	m.connector_data = &b
}

// ConnectorData returns the value of the "connector_data" field in the mutation.
func (m *RefreshTokenMutation) ConnectorData() (r []byte, exists bool) {
	v := m.connector_data
	if v == nil {
		return
	}
	return *v, true
}

// OldConnectorData returns the old "connector_data" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldConnectorData(ctx context.Context) (v *[]byte, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldConnectorData is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldConnectorData requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldConnectorData: %w", err)
	}
	return oldValue.ConnectorData, nil
}

// ClearConnectorData clears the value of the "connector_data" field.
func (m *RefreshTokenMutation) ClearConnectorData() {
	m.connector_data = nil
	m.clearedFields[refreshtoken.FieldConnectorData] = struct{}{}
}

// ConnectorDataCleared returns if the "connector_data" field was cleared in this mutation.
func (m *RefreshTokenMutation) ConnectorDataCleared() bool {
	_, ok := m.clearedFields[refreshtoken.FieldConnectorData]
	return ok
}

// ResetConnectorData resets all changes to the "connector_data" field.
func (m *RefreshTokenMutation) ResetConnectorData() {
	m.connector_data = nil
	delete(m.clearedFields, refreshtoken.FieldConnectorData)
}

// SetToken sets the "token" field.
func (m *RefreshTokenMutation) SetToken(s string) {
	m.token = &s
}

// Token returns the value of the "token" field in the mutation.
func (m *RefreshTokenMutation) Token() (r string, exists bool) {
	v := m.token
	if v == nil {
		return
	}
	return *v, true
}

// OldToken returns the old "token" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldToken(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldToken is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldToken requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldToken: %w", err)
	}
	return oldValue.Token, nil
}

// ResetToken resets all changes to the "token" field.
func (m *RefreshTokenMutation) ResetToken() {
	m.token = nil
}

// SetObsoleteToken sets the "obsolete_token" field.
func (m *RefreshTokenMutation) SetObsoleteToken(s string) {
	m.obsolete_token = &s
}

// ObsoleteToken returns the value of the "obsolete_token" field in the mutation.
func (m *RefreshTokenMutation) ObsoleteToken() (r string, exists bool) {
	v := m.obsolete_token
	if v == nil {
		return
	}
	return *v, true
}

// OldObsoleteToken returns the old "obsolete_token" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldObsoleteToken(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldObsoleteToken is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldObsoleteToken requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldObsoleteToken: %w", err)
	}
	return oldValue.ObsoleteToken, nil
}

// ResetObsoleteToken resets all changes to the "obsolete_token" field.
func (m *RefreshTokenMutation) ResetObsoleteToken() {
	m.obsolete_token = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *RefreshTokenMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *RefreshTokenMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *RefreshTokenMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetLastUsed sets the "last_used" field.
func (m *RefreshTokenMutation) SetLastUsed(t time.Time) {
	m.last_used = &t
}

// LastUsed returns the value of the "last_used" field in the mutation.
func (m *RefreshTokenMutation) LastUsed() (r time.Time, exists bool) {
	v := m.last_used
	if v == nil {
		return
	}
	return *v, true
}

// OldLastUsed returns the old "last_used" field's value of the RefreshToken entity.
// If the RefreshToken object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *RefreshTokenMutation) OldLastUsed(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldLastUsed is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldLastUsed requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldLastUsed: %w", err)
	}
	return oldValue.LastUsed, nil
}

// ResetLastUsed resets all changes to the "last_used" field.
func (m *RefreshTokenMutation) ResetLastUsed() {
	m.last_used = nil
}

// Op returns the operation name.
func (m *RefreshTokenMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (RefreshToken).
func (m *RefreshTokenMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *RefreshTokenMutation) Fields() []string {
	fields := make([]string, 0, 15)
	if m.client_id != nil {
		fields = append(fields, refreshtoken.FieldClientID)
	}
	if m.scopes != nil {
		fields = append(fields, refreshtoken.FieldScopes)
	}
	if m.nonce != nil {
		fields = append(fields, refreshtoken.FieldNonce)
	}
	if m.claims_user_id != nil {
		fields = append(fields, refreshtoken.FieldClaimsUserID)
	}
	if m.claims_username != nil {
		fields = append(fields, refreshtoken.FieldClaimsUsername)
	}
	if m.claims_email != nil {
		fields = append(fields, refreshtoken.FieldClaimsEmail)
	}
	if m.claims_email_verified != nil {
		fields = append(fields, refreshtoken.FieldClaimsEmailVerified)
	}
	if m.claims_groups != nil {
		fields = append(fields, refreshtoken.FieldClaimsGroups)
	}
	if m.claims_preferred_username != nil {
		fields = append(fields, refreshtoken.FieldClaimsPreferredUsername)
	}
	if m.connector_id != nil {
		fields = append(fields, refreshtoken.FieldConnectorID)
	}
	if m.connector_data != nil {
		fields = append(fields, refreshtoken.FieldConnectorData)
	}
	if m.token != nil {
		fields = append(fields, refreshtoken.FieldToken)
	}
	if m.obsolete_token != nil {
		fields = append(fields, refreshtoken.FieldObsoleteToken)
	}
	if m.created_at != nil {
		fields = append(fields, refreshtoken.FieldCreatedAt)
	}
	if m.last_used != nil {
		fields = append(fields, refreshtoken.FieldLastUsed)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *RefreshTokenMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case refreshtoken.FieldClientID:
		return m.ClientID()
	case refreshtoken.FieldScopes:
		return m.Scopes()
	case refreshtoken.FieldNonce:
		return m.Nonce()
	case refreshtoken.FieldClaimsUserID:
		return m.ClaimsUserID()
	case refreshtoken.FieldClaimsUsername:
		return m.ClaimsUsername()
	case refreshtoken.FieldClaimsEmail:
		return m.ClaimsEmail()
	case refreshtoken.FieldClaimsEmailVerified:
		return m.ClaimsEmailVerified()
	case refreshtoken.FieldClaimsGroups:
		return m.ClaimsGroups()
	case refreshtoken.FieldClaimsPreferredUsername:
		return m.ClaimsPreferredUsername()
	case refreshtoken.FieldConnectorID:
		return m.ConnectorID()
	case refreshtoken.FieldConnectorData:
		return m.ConnectorData()
	case refreshtoken.FieldToken:
		return m.Token()
	case refreshtoken.FieldObsoleteToken:
		return m.ObsoleteToken()
	case refreshtoken.FieldCreatedAt:
		return m.CreatedAt()
	case refreshtoken.FieldLastUsed:
		return m.LastUsed()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *RefreshTokenMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case refreshtoken.FieldClientID:
		return m.OldClientID(ctx)
	case refreshtoken.FieldScopes:
		return m.OldScopes(ctx)
	case refreshtoken.FieldNonce:
		return m.OldNonce(ctx)
	case refreshtoken.FieldClaimsUserID:
		return m.OldClaimsUserID(ctx)
	case refreshtoken.FieldClaimsUsername:
		return m.OldClaimsUsername(ctx)
	case refreshtoken.FieldClaimsEmail:
		return m.OldClaimsEmail(ctx)
	case refreshtoken.FieldClaimsEmailVerified:
		return m.OldClaimsEmailVerified(ctx)
	case refreshtoken.FieldClaimsGroups:
		return m.OldClaimsGroups(ctx)
	case refreshtoken.FieldClaimsPreferredUsername:
		return m.OldClaimsPreferredUsername(ctx)
	case refreshtoken.FieldConnectorID:
		return m.OldConnectorID(ctx)
	case refreshtoken.FieldConnectorData:
		return m.OldConnectorData(ctx)
	case refreshtoken.FieldToken:
		return m.OldToken(ctx)
	case refreshtoken.FieldObsoleteToken:
		return m.OldObsoleteToken(ctx)
	case refreshtoken.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case refreshtoken.FieldLastUsed:
		return m.OldLastUsed(ctx)
	}
	return nil, fmt.Errorf("unknown RefreshToken field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *RefreshTokenMutation) SetField(name string, value ent.Value) error {
	switch name {
	case refreshtoken.FieldClientID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClientID(v)
		return nil
	case refreshtoken.FieldScopes:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetScopes(v)
		return nil
	case refreshtoken.FieldNonce:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetNonce(v)
		return nil
	case refreshtoken.FieldClaimsUserID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsUserID(v)
		return nil
	case refreshtoken.FieldClaimsUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsUsername(v)
		return nil
	case refreshtoken.FieldClaimsEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsEmail(v)
		return nil
	case refreshtoken.FieldClaimsEmailVerified:
		v, ok := value.(bool)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsEmailVerified(v)
		return nil
	case refreshtoken.FieldClaimsGroups:
		v, ok := value.([]string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsGroups(v)
		return nil
	case refreshtoken.FieldClaimsPreferredUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetClaimsPreferredUsername(v)
		return nil
	case refreshtoken.FieldConnectorID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnectorID(v)
		return nil
	case refreshtoken.FieldConnectorData:
		v, ok := value.([]byte)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetConnectorData(v)
		return nil
	case refreshtoken.FieldToken:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetToken(v)
		return nil
	case refreshtoken.FieldObsoleteToken:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetObsoleteToken(v)
		return nil
	case refreshtoken.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case refreshtoken.FieldLastUsed:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetLastUsed(v)
		return nil
	}
	return fmt.Errorf("unknown RefreshToken field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *RefreshTokenMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *RefreshTokenMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *RefreshTokenMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown RefreshToken numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *RefreshTokenMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(refreshtoken.FieldScopes) {
		fields = append(fields, refreshtoken.FieldScopes)
	}
	if m.FieldCleared(refreshtoken.FieldClaimsGroups) {
		fields = append(fields, refreshtoken.FieldClaimsGroups)
	}
	if m.FieldCleared(refreshtoken.FieldConnectorData) {
		fields = append(fields, refreshtoken.FieldConnectorData)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *RefreshTokenMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *RefreshTokenMutation) ClearField(name string) error {
	switch name {
	case refreshtoken.FieldScopes:
		m.ClearScopes()
		return nil
	case refreshtoken.FieldClaimsGroups:
		m.ClearClaimsGroups()
		return nil
	case refreshtoken.FieldConnectorData:
		m.ClearConnectorData()
		return nil
	}
	return fmt.Errorf("unknown RefreshToken nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *RefreshTokenMutation) ResetField(name string) error {
	switch name {
	case refreshtoken.FieldClientID:
		m.ResetClientID()
		return nil
	case refreshtoken.FieldScopes:
		m.ResetScopes()
		return nil
	case refreshtoken.FieldNonce:
		m.ResetNonce()
		return nil
	case refreshtoken.FieldClaimsUserID:
		m.ResetClaimsUserID()
		return nil
	case refreshtoken.FieldClaimsUsername:
		m.ResetClaimsUsername()
		return nil
	case refreshtoken.FieldClaimsEmail:
		m.ResetClaimsEmail()
		return nil
	case refreshtoken.FieldClaimsEmailVerified:
		m.ResetClaimsEmailVerified()
		return nil
	case refreshtoken.FieldClaimsGroups:
		m.ResetClaimsGroups()
		return nil
	case refreshtoken.FieldClaimsPreferredUsername:
		m.ResetClaimsPreferredUsername()
		return nil
	case refreshtoken.FieldConnectorID:
		m.ResetConnectorID()
		return nil
	case refreshtoken.FieldConnectorData:
		m.ResetConnectorData()
		return nil
	case refreshtoken.FieldToken:
		m.ResetToken()
		return nil
	case refreshtoken.FieldObsoleteToken:
		m.ResetObsoleteToken()
		return nil
	case refreshtoken.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case refreshtoken.FieldLastUsed:
		m.ResetLastUsed()
		return nil
	}
	return fmt.Errorf("unknown RefreshToken field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *RefreshTokenMutation) AddedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *RefreshTokenMutation) AddedIDs(name string) []ent.Value {
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *RefreshTokenMutation) RemovedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *RefreshTokenMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *RefreshTokenMutation) ClearedEdges() []string {
	edges := make([]string, 0, 0)
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *RefreshTokenMutation) EdgeCleared(name string) bool {
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *RefreshTokenMutation) ClearEdge(name string) error {
	return fmt.Errorf("unknown RefreshToken unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *RefreshTokenMutation) ResetEdge(name string) error {
	return fmt.Errorf("unknown RefreshToken edge %s", name)
}
