// Code generated by entc, DO NOT EDIT.

package hook

import (
	"context"
	"fmt"

	"github.com/dexidp/dex/storage/ent/db"
)

// The AuthCodeFunc type is an adapter to allow the use of ordinary
// function as AuthCode mutator.
type AuthCodeFunc func(context.Context, *db.AuthCodeMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f AuthCodeFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.AuthCodeMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.AuthCodeMutation", m)
	}
	return f(ctx, mv)
}

// The AuthRequestFunc type is an adapter to allow the use of ordinary
// function as AuthRequest mutator.
type AuthRequestFunc func(context.Context, *db.AuthRequestMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f AuthRequestFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.AuthRequestMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.AuthRequestMutation", m)
	}
	return f(ctx, mv)
}

// The ConnectorFunc type is an adapter to allow the use of ordinary
// function as Connector mutator.
type ConnectorFunc func(context.Context, *db.ConnectorMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f ConnectorFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.ConnectorMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.ConnectorMutation", m)
	}
	return f(ctx, mv)
}

// The DeviceRequestFunc type is an adapter to allow the use of ordinary
// function as DeviceRequest mutator.
type DeviceRequestFunc func(context.Context, *db.DeviceRequestMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f DeviceRequestFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.DeviceRequestMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.DeviceRequestMutation", m)
	}
	return f(ctx, mv)
}

// The DeviceTokenFunc type is an adapter to allow the use of ordinary
// function as DeviceToken mutator.
type DeviceTokenFunc func(context.Context, *db.DeviceTokenMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f DeviceTokenFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.DeviceTokenMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.DeviceTokenMutation", m)
	}
	return f(ctx, mv)
}

// The KeysFunc type is an adapter to allow the use of ordinary
// function as Keys mutator.
type KeysFunc func(context.Context, *db.KeysMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f KeysFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.KeysMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.KeysMutation", m)
	}
	return f(ctx, mv)
}

// The OAuth2ClientFunc type is an adapter to allow the use of ordinary
// function as OAuth2Client mutator.
type OAuth2ClientFunc func(context.Context, *db.OAuth2ClientMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f OAuth2ClientFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.OAuth2ClientMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.OAuth2ClientMutation", m)
	}
	return f(ctx, mv)
}

// The OfflineSessionFunc type is an adapter to allow the use of ordinary
// function as OfflineSession mutator.
type OfflineSessionFunc func(context.Context, *db.OfflineSessionMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f OfflineSessionFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.OfflineSessionMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.OfflineSessionMutation", m)
	}
	return f(ctx, mv)
}

// The PasswordFunc type is an adapter to allow the use of ordinary
// function as Password mutator.
type PasswordFunc func(context.Context, *db.PasswordMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f PasswordFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.PasswordMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.PasswordMutation", m)
	}
	return f(ctx, mv)
}

// The RefreshTokenFunc type is an adapter to allow the use of ordinary
// function as RefreshToken mutator.
type RefreshTokenFunc func(context.Context, *db.RefreshTokenMutation) (db.Value, error)

// Mutate calls f(ctx, m).
func (f RefreshTokenFunc) Mutate(ctx context.Context, m db.Mutation) (db.Value, error) {
	mv, ok := m.(*db.RefreshTokenMutation)
	if !ok {
		return nil, fmt.Errorf("unexpected mutation type %T. expect *db.RefreshTokenMutation", m)
	}
	return f(ctx, mv)
}

// Condition is a hook condition function.
type Condition func(context.Context, db.Mutation) bool

// And groups conditions with the AND operator.
func And(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m db.Mutation) bool {
		if !first(ctx, m) || !second(ctx, m) {
			return false
		}
		for _, cond := range rest {
			if !cond(ctx, m) {
				return false
			}
		}
		return true
	}
}

// Or groups conditions with the OR operator.
func Or(first, second Condition, rest ...Condition) Condition {
	return func(ctx context.Context, m db.Mutation) bool {
		if first(ctx, m) || second(ctx, m) {
			return true
		}
		for _, cond := range rest {
			if cond(ctx, m) {
				return true
			}
		}
		return false
	}
}

// Not negates a given condition.
func Not(cond Condition) Condition {
	return func(ctx context.Context, m db.Mutation) bool {
		return !cond(ctx, m)
	}
}

// HasOp is a condition testing mutation operation.
func HasOp(op db.Op) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		return m.Op().Is(op)
	}
}

// HasAddedFields is a condition validating `.AddedField` on fields.
func HasAddedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		if _, exists := m.AddedField(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.AddedField(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasClearedFields is a condition validating `.FieldCleared` on fields.
func HasClearedFields(field string, fields ...string) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		if exists := m.FieldCleared(field); !exists {
			return false
		}
		for _, field := range fields {
			if exists := m.FieldCleared(field); !exists {
				return false
			}
		}
		return true
	}
}

// HasFields is a condition validating `.Field` on fields.
func HasFields(field string, fields ...string) Condition {
	return func(_ context.Context, m db.Mutation) bool {
		if _, exists := m.Field(field); !exists {
			return false
		}
		for _, field := range fields {
			if _, exists := m.Field(field); !exists {
				return false
			}
		}
		return true
	}
}

// If executes the given hook under condition.
//
//	hook.If(ComputeAverage, And(HasFields(...), HasAddedFields(...)))
//
func If(hk db.Hook, cond Condition) db.Hook {
	return func(next db.Mutator) db.Mutator {
		return db.MutateFunc(func(ctx context.Context, m db.Mutation) (db.Value, error) {
			if cond(ctx, m) {
				return hk(next).Mutate(ctx, m)
			}
			return next.Mutate(ctx, m)
		})
	}
}

// On executes the given hook only for the given operation.
//
//	hook.On(Log, db.Delete|db.Create)
//
func On(hk db.Hook, op db.Op) db.Hook {
	return If(hk, HasOp(op))
}

// Unless skips the given hook only for the given operation.
//
//	hook.Unless(Log, db.Update|db.UpdateOne)
//
func Unless(hk db.Hook, op db.Op) db.Hook {
	return If(hk, Not(HasOp(op)))
}

// FixedError is a hook returning a fixed error.
func FixedError(err error) db.Hook {
	return func(db.Mutator) db.Mutator {
		return db.MutateFunc(func(context.Context, db.Mutation) (db.Value, error) {
			return nil, err
		})
	}
}

// Reject returns a hook that rejects all operations that match op.
//
//	func (T) Hooks() []db.Hook {
//		return []db.Hook{
//			Reject(db.Delete|db.Update),
//		}
//	}
//
func Reject(op db.Op) db.Hook {
	hk := FixedError(fmt.Errorf("%s operation is not allowed", op))
	return On(hk, op)
}

// Chain acts as a list of hooks and is effectively immutable.
// Once created, it will always hold the same set of hooks in the same order.
type Chain struct {
	hooks []db.Hook
}

// NewChain creates a new chain of hooks.
func NewChain(hooks ...db.Hook) Chain {
	return Chain{append([]db.Hook(nil), hooks...)}
}

// Hook chains the list of hooks and returns the final hook.
func (c Chain) Hook() db.Hook {
	return func(mutator db.Mutator) db.Mutator {
		for i := len(c.hooks) - 1; i >= 0; i-- {
			mutator = c.hooks[i](mutator)
		}
		return mutator
	}
}

// Append extends a chain, adding the specified hook
// as the last ones in the mutation flow.
func (c Chain) Append(hooks ...db.Hook) Chain {
	newHooks := make([]db.Hook, 0, len(c.hooks)+len(hooks))
	newHooks = append(newHooks, c.hooks...)
	newHooks = append(newHooks, hooks...)
	return Chain{newHooks}
}

// Extend extends a chain, adding the specified chain
// as the last ones in the mutation flow.
func (c Chain) Extend(chain Chain) Chain {
	return c.Append(chain.hooks...)
}
