// Code generated by entc, DO NOT EDIT.

package refreshtoken

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"github.com/dexidp/dex/storage/ent/db/predicate"
)

// ID filters vertices based on their ID field.
func ID(id string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldID), id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(ids) == 0 {
			s.Where(sql.False())
			return
		}
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.In(s.C(FieldID), v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(ids) == 0 {
			s.Where(sql.False())
			return
		}
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.NotIn(s.C(FieldID), v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldID), id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldID), id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldID), id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldID), id))
	})
}

// ClientID applies equality check predicate on the "client_id" field. It's identical to ClientIDEQ.
func ClientID(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClientID), v))
	})
}

// Nonce applies equality check predicate on the "nonce" field. It's identical to NonceEQ.
func Nonce(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNonce), v))
	})
}

// ClaimsUserID applies equality check predicate on the "claims_user_id" field. It's identical to ClaimsUserIDEQ.
func ClaimsUserID(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUsername applies equality check predicate on the "claims_username" field. It's identical to ClaimsUsernameEQ.
func ClaimsUsername(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsEmail applies equality check predicate on the "claims_email" field. It's identical to ClaimsEmailEQ.
func ClaimsEmail(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailVerified applies equality check predicate on the "claims_email_verified" field. It's identical to ClaimsEmailVerifiedEQ.
func ClaimsEmailVerified(v bool) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsEmailVerified), v))
	})
}

// ClaimsPreferredUsername applies equality check predicate on the "claims_preferred_username" field. It's identical to ClaimsPreferredUsernameEQ.
func ClaimsPreferredUsername(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ConnectorID applies equality check predicate on the "connector_id" field. It's identical to ConnectorIDEQ.
func ConnectorID(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldConnectorID), v))
	})
}

// ConnectorData applies equality check predicate on the "connector_data" field. It's identical to ConnectorDataEQ.
func ConnectorData(v []byte) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldConnectorData), v))
	})
}

// Token applies equality check predicate on the "token" field. It's identical to TokenEQ.
func Token(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldToken), v))
	})
}

// ObsoleteToken applies equality check predicate on the "obsolete_token" field. It's identical to ObsoleteTokenEQ.
func ObsoleteToken(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldObsoleteToken), v))
	})
}

// CreatedAt applies equality check predicate on the "created_at" field. It's identical to CreatedAtEQ.
func CreatedAt(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldCreatedAt), v))
	})
}

// LastUsed applies equality check predicate on the "last_used" field. It's identical to LastUsedEQ.
func LastUsed(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLastUsed), v))
	})
}

// ClientIDEQ applies the EQ predicate on the "client_id" field.
func ClientIDEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClientID), v))
	})
}

// ClientIDNEQ applies the NEQ predicate on the "client_id" field.
func ClientIDNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldClientID), v))
	})
}

// ClientIDIn applies the In predicate on the "client_id" field.
func ClientIDIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldClientID), v...))
	})
}

// ClientIDNotIn applies the NotIn predicate on the "client_id" field.
func ClientIDNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldClientID), v...))
	})
}

// ClientIDGT applies the GT predicate on the "client_id" field.
func ClientIDGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldClientID), v))
	})
}

// ClientIDGTE applies the GTE predicate on the "client_id" field.
func ClientIDGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldClientID), v))
	})
}

// ClientIDLT applies the LT predicate on the "client_id" field.
func ClientIDLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldClientID), v))
	})
}

// ClientIDLTE applies the LTE predicate on the "client_id" field.
func ClientIDLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldClientID), v))
	})
}

// ClientIDContains applies the Contains predicate on the "client_id" field.
func ClientIDContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldClientID), v))
	})
}

// ClientIDHasPrefix applies the HasPrefix predicate on the "client_id" field.
func ClientIDHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldClientID), v))
	})
}

// ClientIDHasSuffix applies the HasSuffix predicate on the "client_id" field.
func ClientIDHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldClientID), v))
	})
}

// ClientIDEqualFold applies the EqualFold predicate on the "client_id" field.
func ClientIDEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldClientID), v))
	})
}

// ClientIDContainsFold applies the ContainsFold predicate on the "client_id" field.
func ClientIDContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldClientID), v))
	})
}

// ScopesIsNil applies the IsNil predicate on the "scopes" field.
func ScopesIsNil() predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldScopes)))
	})
}

// ScopesNotNil applies the NotNil predicate on the "scopes" field.
func ScopesNotNil() predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldScopes)))
	})
}

// NonceEQ applies the EQ predicate on the "nonce" field.
func NonceEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldNonce), v))
	})
}

// NonceNEQ applies the NEQ predicate on the "nonce" field.
func NonceNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldNonce), v))
	})
}

// NonceIn applies the In predicate on the "nonce" field.
func NonceIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldNonce), v...))
	})
}

// NonceNotIn applies the NotIn predicate on the "nonce" field.
func NonceNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldNonce), v...))
	})
}

// NonceGT applies the GT predicate on the "nonce" field.
func NonceGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldNonce), v))
	})
}

// NonceGTE applies the GTE predicate on the "nonce" field.
func NonceGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldNonce), v))
	})
}

// NonceLT applies the LT predicate on the "nonce" field.
func NonceLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldNonce), v))
	})
}

// NonceLTE applies the LTE predicate on the "nonce" field.
func NonceLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldNonce), v))
	})
}

// NonceContains applies the Contains predicate on the "nonce" field.
func NonceContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldNonce), v))
	})
}

// NonceHasPrefix applies the HasPrefix predicate on the "nonce" field.
func NonceHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldNonce), v))
	})
}

// NonceHasSuffix applies the HasSuffix predicate on the "nonce" field.
func NonceHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldNonce), v))
	})
}

// NonceEqualFold applies the EqualFold predicate on the "nonce" field.
func NonceEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldNonce), v))
	})
}

// NonceContainsFold applies the ContainsFold predicate on the "nonce" field.
func NonceContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldNonce), v))
	})
}

// ClaimsUserIDEQ applies the EQ predicate on the "claims_user_id" field.
func ClaimsUserIDEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDNEQ applies the NEQ predicate on the "claims_user_id" field.
func ClaimsUserIDNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDIn applies the In predicate on the "claims_user_id" field.
func ClaimsUserIDIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldClaimsUserID), v...))
	})
}

// ClaimsUserIDNotIn applies the NotIn predicate on the "claims_user_id" field.
func ClaimsUserIDNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldClaimsUserID), v...))
	})
}

// ClaimsUserIDGT applies the GT predicate on the "claims_user_id" field.
func ClaimsUserIDGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDGTE applies the GTE predicate on the "claims_user_id" field.
func ClaimsUserIDGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDLT applies the LT predicate on the "claims_user_id" field.
func ClaimsUserIDLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDLTE applies the LTE predicate on the "claims_user_id" field.
func ClaimsUserIDLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDContains applies the Contains predicate on the "claims_user_id" field.
func ClaimsUserIDContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDHasPrefix applies the HasPrefix predicate on the "claims_user_id" field.
func ClaimsUserIDHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDHasSuffix applies the HasSuffix predicate on the "claims_user_id" field.
func ClaimsUserIDHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDEqualFold applies the EqualFold predicate on the "claims_user_id" field.
func ClaimsUserIDEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUserIDContainsFold applies the ContainsFold predicate on the "claims_user_id" field.
func ClaimsUserIDContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldClaimsUserID), v))
	})
}

// ClaimsUsernameEQ applies the EQ predicate on the "claims_username" field.
func ClaimsUsernameEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameNEQ applies the NEQ predicate on the "claims_username" field.
func ClaimsUsernameNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameIn applies the In predicate on the "claims_username" field.
func ClaimsUsernameIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldClaimsUsername), v...))
	})
}

// ClaimsUsernameNotIn applies the NotIn predicate on the "claims_username" field.
func ClaimsUsernameNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldClaimsUsername), v...))
	})
}

// ClaimsUsernameGT applies the GT predicate on the "claims_username" field.
func ClaimsUsernameGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameGTE applies the GTE predicate on the "claims_username" field.
func ClaimsUsernameGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameLT applies the LT predicate on the "claims_username" field.
func ClaimsUsernameLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameLTE applies the LTE predicate on the "claims_username" field.
func ClaimsUsernameLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameContains applies the Contains predicate on the "claims_username" field.
func ClaimsUsernameContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameHasPrefix applies the HasPrefix predicate on the "claims_username" field.
func ClaimsUsernameHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameHasSuffix applies the HasSuffix predicate on the "claims_username" field.
func ClaimsUsernameHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameEqualFold applies the EqualFold predicate on the "claims_username" field.
func ClaimsUsernameEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsUsernameContainsFold applies the ContainsFold predicate on the "claims_username" field.
func ClaimsUsernameContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldClaimsUsername), v))
	})
}

// ClaimsEmailEQ applies the EQ predicate on the "claims_email" field.
func ClaimsEmailEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailNEQ applies the NEQ predicate on the "claims_email" field.
func ClaimsEmailNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailIn applies the In predicate on the "claims_email" field.
func ClaimsEmailIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldClaimsEmail), v...))
	})
}

// ClaimsEmailNotIn applies the NotIn predicate on the "claims_email" field.
func ClaimsEmailNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldClaimsEmail), v...))
	})
}

// ClaimsEmailGT applies the GT predicate on the "claims_email" field.
func ClaimsEmailGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailGTE applies the GTE predicate on the "claims_email" field.
func ClaimsEmailGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailLT applies the LT predicate on the "claims_email" field.
func ClaimsEmailLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailLTE applies the LTE predicate on the "claims_email" field.
func ClaimsEmailLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailContains applies the Contains predicate on the "claims_email" field.
func ClaimsEmailContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailHasPrefix applies the HasPrefix predicate on the "claims_email" field.
func ClaimsEmailHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailHasSuffix applies the HasSuffix predicate on the "claims_email" field.
func ClaimsEmailHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailEqualFold applies the EqualFold predicate on the "claims_email" field.
func ClaimsEmailEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailContainsFold applies the ContainsFold predicate on the "claims_email" field.
func ClaimsEmailContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldClaimsEmail), v))
	})
}

// ClaimsEmailVerifiedEQ applies the EQ predicate on the "claims_email_verified" field.
func ClaimsEmailVerifiedEQ(v bool) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsEmailVerified), v))
	})
}

// ClaimsEmailVerifiedNEQ applies the NEQ predicate on the "claims_email_verified" field.
func ClaimsEmailVerifiedNEQ(v bool) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldClaimsEmailVerified), v))
	})
}

// ClaimsGroupsIsNil applies the IsNil predicate on the "claims_groups" field.
func ClaimsGroupsIsNil() predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldClaimsGroups)))
	})
}

// ClaimsGroupsNotNil applies the NotNil predicate on the "claims_groups" field.
func ClaimsGroupsNotNil() predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldClaimsGroups)))
	})
}

// ClaimsPreferredUsernameEQ applies the EQ predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameNEQ applies the NEQ predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameIn applies the In predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldClaimsPreferredUsername), v...))
	})
}

// ClaimsPreferredUsernameNotIn applies the NotIn predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldClaimsPreferredUsername), v...))
	})
}

// ClaimsPreferredUsernameGT applies the GT predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameGTE applies the GTE predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameLT applies the LT predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameLTE applies the LTE predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameContains applies the Contains predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameHasPrefix applies the HasPrefix predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameHasSuffix applies the HasSuffix predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameEqualFold applies the EqualFold predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ClaimsPreferredUsernameContainsFold applies the ContainsFold predicate on the "claims_preferred_username" field.
func ClaimsPreferredUsernameContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldClaimsPreferredUsername), v))
	})
}

// ConnectorIDEQ applies the EQ predicate on the "connector_id" field.
func ConnectorIDEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDNEQ applies the NEQ predicate on the "connector_id" field.
func ConnectorIDNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDIn applies the In predicate on the "connector_id" field.
func ConnectorIDIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldConnectorID), v...))
	})
}

// ConnectorIDNotIn applies the NotIn predicate on the "connector_id" field.
func ConnectorIDNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldConnectorID), v...))
	})
}

// ConnectorIDGT applies the GT predicate on the "connector_id" field.
func ConnectorIDGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDGTE applies the GTE predicate on the "connector_id" field.
func ConnectorIDGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDLT applies the LT predicate on the "connector_id" field.
func ConnectorIDLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDLTE applies the LTE predicate on the "connector_id" field.
func ConnectorIDLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDContains applies the Contains predicate on the "connector_id" field.
func ConnectorIDContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDHasPrefix applies the HasPrefix predicate on the "connector_id" field.
func ConnectorIDHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDHasSuffix applies the HasSuffix predicate on the "connector_id" field.
func ConnectorIDHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDEqualFold applies the EqualFold predicate on the "connector_id" field.
func ConnectorIDEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldConnectorID), v))
	})
}

// ConnectorIDContainsFold applies the ContainsFold predicate on the "connector_id" field.
func ConnectorIDContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldConnectorID), v))
	})
}

// ConnectorDataEQ applies the EQ predicate on the "connector_data" field.
func ConnectorDataEQ(v []byte) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldConnectorData), v))
	})
}

// ConnectorDataNEQ applies the NEQ predicate on the "connector_data" field.
func ConnectorDataNEQ(v []byte) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldConnectorData), v))
	})
}

// ConnectorDataIn applies the In predicate on the "connector_data" field.
func ConnectorDataIn(vs ...[]byte) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldConnectorData), v...))
	})
}

// ConnectorDataNotIn applies the NotIn predicate on the "connector_data" field.
func ConnectorDataNotIn(vs ...[]byte) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldConnectorData), v...))
	})
}

// ConnectorDataGT applies the GT predicate on the "connector_data" field.
func ConnectorDataGT(v []byte) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldConnectorData), v))
	})
}

// ConnectorDataGTE applies the GTE predicate on the "connector_data" field.
func ConnectorDataGTE(v []byte) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldConnectorData), v))
	})
}

// ConnectorDataLT applies the LT predicate on the "connector_data" field.
func ConnectorDataLT(v []byte) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldConnectorData), v))
	})
}

// ConnectorDataLTE applies the LTE predicate on the "connector_data" field.
func ConnectorDataLTE(v []byte) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldConnectorData), v))
	})
}

// ConnectorDataIsNil applies the IsNil predicate on the "connector_data" field.
func ConnectorDataIsNil() predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldConnectorData)))
	})
}

// ConnectorDataNotNil applies the NotNil predicate on the "connector_data" field.
func ConnectorDataNotNil() predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldConnectorData)))
	})
}

// TokenEQ applies the EQ predicate on the "token" field.
func TokenEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldToken), v))
	})
}

// TokenNEQ applies the NEQ predicate on the "token" field.
func TokenNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldToken), v))
	})
}

// TokenIn applies the In predicate on the "token" field.
func TokenIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldToken), v...))
	})
}

// TokenNotIn applies the NotIn predicate on the "token" field.
func TokenNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldToken), v...))
	})
}

// TokenGT applies the GT predicate on the "token" field.
func TokenGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldToken), v))
	})
}

// TokenGTE applies the GTE predicate on the "token" field.
func TokenGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldToken), v))
	})
}

// TokenLT applies the LT predicate on the "token" field.
func TokenLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldToken), v))
	})
}

// TokenLTE applies the LTE predicate on the "token" field.
func TokenLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldToken), v))
	})
}

// TokenContains applies the Contains predicate on the "token" field.
func TokenContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldToken), v))
	})
}

// TokenHasPrefix applies the HasPrefix predicate on the "token" field.
func TokenHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldToken), v))
	})
}

// TokenHasSuffix applies the HasSuffix predicate on the "token" field.
func TokenHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldToken), v))
	})
}

// TokenEqualFold applies the EqualFold predicate on the "token" field.
func TokenEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldToken), v))
	})
}

// TokenContainsFold applies the ContainsFold predicate on the "token" field.
func TokenContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldToken), v))
	})
}

// ObsoleteTokenEQ applies the EQ predicate on the "obsolete_token" field.
func ObsoleteTokenEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenNEQ applies the NEQ predicate on the "obsolete_token" field.
func ObsoleteTokenNEQ(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenIn applies the In predicate on the "obsolete_token" field.
func ObsoleteTokenIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldObsoleteToken), v...))
	})
}

// ObsoleteTokenNotIn applies the NotIn predicate on the "obsolete_token" field.
func ObsoleteTokenNotIn(vs ...string) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldObsoleteToken), v...))
	})
}

// ObsoleteTokenGT applies the GT predicate on the "obsolete_token" field.
func ObsoleteTokenGT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenGTE applies the GTE predicate on the "obsolete_token" field.
func ObsoleteTokenGTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenLT applies the LT predicate on the "obsolete_token" field.
func ObsoleteTokenLT(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenLTE applies the LTE predicate on the "obsolete_token" field.
func ObsoleteTokenLTE(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenContains applies the Contains predicate on the "obsolete_token" field.
func ObsoleteTokenContains(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenHasPrefix applies the HasPrefix predicate on the "obsolete_token" field.
func ObsoleteTokenHasPrefix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenHasSuffix applies the HasSuffix predicate on the "obsolete_token" field.
func ObsoleteTokenHasSuffix(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenEqualFold applies the EqualFold predicate on the "obsolete_token" field.
func ObsoleteTokenEqualFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldObsoleteToken), v))
	})
}

// ObsoleteTokenContainsFold applies the ContainsFold predicate on the "obsolete_token" field.
func ObsoleteTokenContainsFold(v string) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldObsoleteToken), v))
	})
}

// CreatedAtEQ applies the EQ predicate on the "created_at" field.
func CreatedAtEQ(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtNEQ applies the NEQ predicate on the "created_at" field.
func CreatedAtNEQ(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtIn applies the In predicate on the "created_at" field.
func CreatedAtIn(vs ...time.Time) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldCreatedAt), v...))
	})
}

// CreatedAtNotIn applies the NotIn predicate on the "created_at" field.
func CreatedAtNotIn(vs ...time.Time) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldCreatedAt), v...))
	})
}

// CreatedAtGT applies the GT predicate on the "created_at" field.
func CreatedAtGT(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtGTE applies the GTE predicate on the "created_at" field.
func CreatedAtGTE(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtLT applies the LT predicate on the "created_at" field.
func CreatedAtLT(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtLTE applies the LTE predicate on the "created_at" field.
func CreatedAtLTE(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldCreatedAt), v))
	})
}

// LastUsedEQ applies the EQ predicate on the "last_used" field.
func LastUsedEQ(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldLastUsed), v))
	})
}

// LastUsedNEQ applies the NEQ predicate on the "last_used" field.
func LastUsedNEQ(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldLastUsed), v))
	})
}

// LastUsedIn applies the In predicate on the "last_used" field.
func LastUsedIn(vs ...time.Time) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldLastUsed), v...))
	})
}

// LastUsedNotIn applies the NotIn predicate on the "last_used" field.
func LastUsedNotIn(vs ...time.Time) predicate.RefreshToken {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.RefreshToken(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldLastUsed), v...))
	})
}

// LastUsedGT applies the GT predicate on the "last_used" field.
func LastUsedGT(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldLastUsed), v))
	})
}

// LastUsedGTE applies the GTE predicate on the "last_used" field.
func LastUsedGTE(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldLastUsed), v))
	})
}

// LastUsedLT applies the LT predicate on the "last_used" field.
func LastUsedLT(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldLastUsed), v))
	})
}

// LastUsedLTE applies the LTE predicate on the "last_used" field.
func LastUsedLTE(v time.Time) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldLastUsed), v))
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.RefreshToken) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for _, p := range predicates {
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.RefreshToken) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for i, p := range predicates {
			if i > 0 {
				s1.Or()
			}
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.RefreshToken) predicate.RefreshToken {
	return predicate.RefreshToken(func(s *sql.Selector) {
		p(s.Not())
	})
}
