// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"sync"

	"entgo.io/ent/entc/integration/privacy/ent/predicate"
	"entgo.io/ent/entc/integration/privacy/ent/task"
	"entgo.io/ent/entc/integration/privacy/ent/team"
	"entgo.io/ent/entc/integration/privacy/ent/user"
	"github.com/google/uuid"

	"entgo.io/ent"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeTask = "Task"
	TypeTeam = "Team"
	TypeUser = "User"
)

// TaskMutation represents an operation that mutates the Task nodes in the graph.
type TaskMutation struct {
	config
	op            Op
	typ           string
	id            *int
	title         *string
	description   *string
	status        *task.Status
	uuid          *uuid.UUID
	clearedFields map[string]struct{}
	teams         map[int]struct{}
	removedteams  map[int]struct{}
	clearedteams  bool
	owner         *int
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Task, error)
	predicates    []predicate.Task
}

var _ ent.Mutation = (*TaskMutation)(nil)

// taskOption allows management of the mutation configuration using functional options.
type taskOption func(*TaskMutation)

// newTaskMutation creates new mutation for the Task entity.
func newTaskMutation(c config, op Op, opts ...taskOption) *TaskMutation {
	m := &TaskMutation{
		config:        c,
		op:            op,
		typ:           TypeTask,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withTaskID sets the ID field of the mutation.
func withTaskID(id int) taskOption {
	return func(m *TaskMutation) {
		var (
			err   error
			once  sync.Once
			value *Task
		)
		m.oldValue = func(ctx context.Context) (*Task, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Task.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withTask sets the old Task of the mutation.
func withTask(node *Task) taskOption {
	return func(m *TaskMutation) {
		m.oldValue = func(context.Context) (*Task, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m TaskMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m TaskMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *TaskMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetTitle sets the "title" field.
func (m *TaskMutation) SetTitle(s string) {
	m.title = &s
}

// Title returns the value of the "title" field in the mutation.
func (m *TaskMutation) Title() (r string, exists bool) {
	v := m.title
	if v == nil {
		return
	}
	return *v, true
}

// OldTitle returns the old "title" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldTitle(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldTitle is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldTitle requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldTitle: %w", err)
	}
	return oldValue.Title, nil
}

// ResetTitle resets all changes to the "title" field.
func (m *TaskMutation) ResetTitle() {
	m.title = nil
}

// SetDescription sets the "description" field.
func (m *TaskMutation) SetDescription(s string) {
	m.description = &s
}

// Description returns the value of the "description" field in the mutation.
func (m *TaskMutation) Description() (r string, exists bool) {
	v := m.description
	if v == nil {
		return
	}
	return *v, true
}

// OldDescription returns the old "description" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDescription: %w", err)
	}
	return oldValue.Description, nil
}

// ClearDescription clears the value of the "description" field.
func (m *TaskMutation) ClearDescription() {
	m.description = nil
	m.clearedFields[task.FieldDescription] = struct{}{}
}

// DescriptionCleared returns if the "description" field was cleared in this mutation.
func (m *TaskMutation) DescriptionCleared() bool {
	_, ok := m.clearedFields[task.FieldDescription]
	return ok
}

// ResetDescription resets all changes to the "description" field.
func (m *TaskMutation) ResetDescription() {
	m.description = nil
	delete(m.clearedFields, task.FieldDescription)
}

// SetStatus sets the "status" field.
func (m *TaskMutation) SetStatus(t task.Status) {
	m.status = &t
}

// Status returns the value of the "status" field in the mutation.
func (m *TaskMutation) Status() (r task.Status, exists bool) {
	v := m.status
	if v == nil {
		return
	}
	return *v, true
}

// OldStatus returns the old "status" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldStatus(ctx context.Context) (v task.Status, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldStatus is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldStatus requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldStatus: %w", err)
	}
	return oldValue.Status, nil
}

// ResetStatus resets all changes to the "status" field.
func (m *TaskMutation) ResetStatus() {
	m.status = nil
}

// SetUUID sets the "uuid" field.
func (m *TaskMutation) SetUUID(u uuid.UUID) {
	m.uuid = &u
}

// UUID returns the value of the "uuid" field in the mutation.
func (m *TaskMutation) UUID() (r uuid.UUID, exists bool) {
	v := m.uuid
	if v == nil {
		return
	}
	return *v, true
}

// OldUUID returns the old "uuid" field's value of the Task entity.
// If the Task object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TaskMutation) OldUUID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldUUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldUUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUUID: %w", err)
	}
	return oldValue.UUID, nil
}

// ClearUUID clears the value of the "uuid" field.
func (m *TaskMutation) ClearUUID() {
	m.uuid = nil
	m.clearedFields[task.FieldUUID] = struct{}{}
}

// UUIDCleared returns if the "uuid" field was cleared in this mutation.
func (m *TaskMutation) UUIDCleared() bool {
	_, ok := m.clearedFields[task.FieldUUID]
	return ok
}

// ResetUUID resets all changes to the "uuid" field.
func (m *TaskMutation) ResetUUID() {
	m.uuid = nil
	delete(m.clearedFields, task.FieldUUID)
}

// AddTeamIDs adds the "teams" edge to the Team entity by ids.
func (m *TaskMutation) AddTeamIDs(ids ...int) {
	if m.teams == nil {
		m.teams = make(map[int]struct{})
	}
	for i := range ids {
		m.teams[ids[i]] = struct{}{}
	}
}

// ClearTeams clears the "teams" edge to the Team entity.
func (m *TaskMutation) ClearTeams() {
	m.clearedteams = true
}

// TeamsCleared reports if the "teams" edge to the Team entity was cleared.
func (m *TaskMutation) TeamsCleared() bool {
	return m.clearedteams
}

// RemoveTeamIDs removes the "teams" edge to the Team entity by IDs.
func (m *TaskMutation) RemoveTeamIDs(ids ...int) {
	if m.removedteams == nil {
		m.removedteams = make(map[int]struct{})
	}
	for i := range ids {
		m.removedteams[ids[i]] = struct{}{}
	}
}

// RemovedTeams returns the removed IDs of the "teams" edge to the Team entity.
func (m *TaskMutation) RemovedTeamsIDs() (ids []int) {
	for id := range m.removedteams {
		ids = append(ids, id)
	}
	return
}

// TeamsIDs returns the "teams" edge IDs in the mutation.
func (m *TaskMutation) TeamsIDs() (ids []int) {
	for id := range m.teams {
		ids = append(ids, id)
	}
	return
}

// ResetTeams resets all changes to the "teams" edge.
func (m *TaskMutation) ResetTeams() {
	m.teams = nil
	m.clearedteams = false
	m.removedteams = nil
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *TaskMutation) SetOwnerID(id int) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *TaskMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *TaskMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *TaskMutation) OwnerID() (id int, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *TaskMutation) OwnerIDs() (ids []int) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *TaskMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Op returns the operation name.
func (m *TaskMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Task).
func (m *TaskMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *TaskMutation) Fields() []string {
	fields := make([]string, 0, 4)
	if m.title != nil {
		fields = append(fields, task.FieldTitle)
	}
	if m.description != nil {
		fields = append(fields, task.FieldDescription)
	}
	if m.status != nil {
		fields = append(fields, task.FieldStatus)
	}
	if m.uuid != nil {
		fields = append(fields, task.FieldUUID)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *TaskMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case task.FieldTitle:
		return m.Title()
	case task.FieldDescription:
		return m.Description()
	case task.FieldStatus:
		return m.Status()
	case task.FieldUUID:
		return m.UUID()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *TaskMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case task.FieldTitle:
		return m.OldTitle(ctx)
	case task.FieldDescription:
		return m.OldDescription(ctx)
	case task.FieldStatus:
		return m.OldStatus(ctx)
	case task.FieldUUID:
		return m.OldUUID(ctx)
	}
	return nil, fmt.Errorf("unknown Task field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskMutation) SetField(name string, value ent.Value) error {
	switch name {
	case task.FieldTitle:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetTitle(v)
		return nil
	case task.FieldDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDescription(v)
		return nil
	case task.FieldStatus:
		v, ok := value.(task.Status)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetStatus(v)
		return nil
	case task.FieldUUID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUUID(v)
		return nil
	}
	return fmt.Errorf("unknown Task field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *TaskMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *TaskMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TaskMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Task numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *TaskMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(task.FieldDescription) {
		fields = append(fields, task.FieldDescription)
	}
	if m.FieldCleared(task.FieldUUID) {
		fields = append(fields, task.FieldUUID)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *TaskMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *TaskMutation) ClearField(name string) error {
	switch name {
	case task.FieldDescription:
		m.ClearDescription()
		return nil
	case task.FieldUUID:
		m.ClearUUID()
		return nil
	}
	return fmt.Errorf("unknown Task nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *TaskMutation) ResetField(name string) error {
	switch name {
	case task.FieldTitle:
		m.ResetTitle()
		return nil
	case task.FieldDescription:
		m.ResetDescription()
		return nil
	case task.FieldStatus:
		m.ResetStatus()
		return nil
	case task.FieldUUID:
		m.ResetUUID()
		return nil
	}
	return fmt.Errorf("unknown Task field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *TaskMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.teams != nil {
		edges = append(edges, task.EdgeTeams)
	}
	if m.owner != nil {
		edges = append(edges, task.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *TaskMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case task.EdgeTeams:
		ids := make([]ent.Value, 0, len(m.teams))
		for id := range m.teams {
			ids = append(ids, id)
		}
		return ids
	case task.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *TaskMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedteams != nil {
		edges = append(edges, task.EdgeTeams)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *TaskMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case task.EdgeTeams:
		ids := make([]ent.Value, 0, len(m.removedteams))
		for id := range m.removedteams {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *TaskMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedteams {
		edges = append(edges, task.EdgeTeams)
	}
	if m.clearedowner {
		edges = append(edges, task.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *TaskMutation) EdgeCleared(name string) bool {
	switch name {
	case task.EdgeTeams:
		return m.clearedteams
	case task.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *TaskMutation) ClearEdge(name string) error {
	switch name {
	case task.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Task unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *TaskMutation) ResetEdge(name string) error {
	switch name {
	case task.EdgeTeams:
		m.ResetTeams()
		return nil
	case task.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Task edge %s", name)
}

// TeamMutation represents an operation that mutates the Team nodes in the graph.
type TeamMutation struct {
	config
	op            Op
	typ           string
	id            *int
	name          *string
	clearedFields map[string]struct{}
	tasks         map[int]struct{}
	removedtasks  map[int]struct{}
	clearedtasks  bool
	users         map[int]struct{}
	removedusers  map[int]struct{}
	clearedusers  bool
	done          bool
	oldValue      func(context.Context) (*Team, error)
	predicates    []predicate.Team
}

var _ ent.Mutation = (*TeamMutation)(nil)

// teamOption allows management of the mutation configuration using functional options.
type teamOption func(*TeamMutation)

// newTeamMutation creates new mutation for the Team entity.
func newTeamMutation(c config, op Op, opts ...teamOption) *TeamMutation {
	m := &TeamMutation{
		config:        c,
		op:            op,
		typ:           TypeTeam,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withTeamID sets the ID field of the mutation.
func withTeamID(id int) teamOption {
	return func(m *TeamMutation) {
		var (
			err   error
			once  sync.Once
			value *Team
		)
		m.oldValue = func(ctx context.Context) (*Team, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Team.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withTeam sets the old Team of the mutation.
func withTeam(node *Team) teamOption {
	return func(m *TeamMutation) {
		m.oldValue = func(context.Context) (*Team, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m TeamMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m TeamMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *TeamMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetName sets the "name" field.
func (m *TeamMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *TeamMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Team entity.
// If the Team object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TeamMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *TeamMutation) ResetName() {
	m.name = nil
}

// AddTaskIDs adds the "tasks" edge to the Task entity by ids.
func (m *TeamMutation) AddTaskIDs(ids ...int) {
	if m.tasks == nil {
		m.tasks = make(map[int]struct{})
	}
	for i := range ids {
		m.tasks[ids[i]] = struct{}{}
	}
}

// ClearTasks clears the "tasks" edge to the Task entity.
func (m *TeamMutation) ClearTasks() {
	m.clearedtasks = true
}

// TasksCleared reports if the "tasks" edge to the Task entity was cleared.
func (m *TeamMutation) TasksCleared() bool {
	return m.clearedtasks
}

// RemoveTaskIDs removes the "tasks" edge to the Task entity by IDs.
func (m *TeamMutation) RemoveTaskIDs(ids ...int) {
	if m.removedtasks == nil {
		m.removedtasks = make(map[int]struct{})
	}
	for i := range ids {
		m.removedtasks[ids[i]] = struct{}{}
	}
}

// RemovedTasks returns the removed IDs of the "tasks" edge to the Task entity.
func (m *TeamMutation) RemovedTasksIDs() (ids []int) {
	for id := range m.removedtasks {
		ids = append(ids, id)
	}
	return
}

// TasksIDs returns the "tasks" edge IDs in the mutation.
func (m *TeamMutation) TasksIDs() (ids []int) {
	for id := range m.tasks {
		ids = append(ids, id)
	}
	return
}

// ResetTasks resets all changes to the "tasks" edge.
func (m *TeamMutation) ResetTasks() {
	m.tasks = nil
	m.clearedtasks = false
	m.removedtasks = nil
}

// AddUserIDs adds the "users" edge to the User entity by ids.
func (m *TeamMutation) AddUserIDs(ids ...int) {
	if m.users == nil {
		m.users = make(map[int]struct{})
	}
	for i := range ids {
		m.users[ids[i]] = struct{}{}
	}
}

// ClearUsers clears the "users" edge to the User entity.
func (m *TeamMutation) ClearUsers() {
	m.clearedusers = true
}

// UsersCleared reports if the "users" edge to the User entity was cleared.
func (m *TeamMutation) UsersCleared() bool {
	return m.clearedusers
}

// RemoveUserIDs removes the "users" edge to the User entity by IDs.
func (m *TeamMutation) RemoveUserIDs(ids ...int) {
	if m.removedusers == nil {
		m.removedusers = make(map[int]struct{})
	}
	for i := range ids {
		m.removedusers[ids[i]] = struct{}{}
	}
}

// RemovedUsers returns the removed IDs of the "users" edge to the User entity.
func (m *TeamMutation) RemovedUsersIDs() (ids []int) {
	for id := range m.removedusers {
		ids = append(ids, id)
	}
	return
}

// UsersIDs returns the "users" edge IDs in the mutation.
func (m *TeamMutation) UsersIDs() (ids []int) {
	for id := range m.users {
		ids = append(ids, id)
	}
	return
}

// ResetUsers resets all changes to the "users" edge.
func (m *TeamMutation) ResetUsers() {
	m.users = nil
	m.clearedusers = false
	m.removedusers = nil
}

// Op returns the operation name.
func (m *TeamMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (Team).
func (m *TeamMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *TeamMutation) Fields() []string {
	fields := make([]string, 0, 1)
	if m.name != nil {
		fields = append(fields, team.FieldName)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *TeamMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case team.FieldName:
		return m.Name()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *TeamMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case team.FieldName:
		return m.OldName(ctx)
	}
	return nil, fmt.Errorf("unknown Team field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TeamMutation) SetField(name string, value ent.Value) error {
	switch name {
	case team.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	}
	return fmt.Errorf("unknown Team field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *TeamMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *TeamMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TeamMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Team numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *TeamMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *TeamMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *TeamMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Team nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *TeamMutation) ResetField(name string) error {
	switch name {
	case team.FieldName:
		m.ResetName()
		return nil
	}
	return fmt.Errorf("unknown Team field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *TeamMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.tasks != nil {
		edges = append(edges, team.EdgeTasks)
	}
	if m.users != nil {
		edges = append(edges, team.EdgeUsers)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *TeamMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case team.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.tasks))
		for id := range m.tasks {
			ids = append(ids, id)
		}
		return ids
	case team.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.users))
		for id := range m.users {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *TeamMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedtasks != nil {
		edges = append(edges, team.EdgeTasks)
	}
	if m.removedusers != nil {
		edges = append(edges, team.EdgeUsers)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *TeamMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case team.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.removedtasks))
		for id := range m.removedtasks {
			ids = append(ids, id)
		}
		return ids
	case team.EdgeUsers:
		ids := make([]ent.Value, 0, len(m.removedusers))
		for id := range m.removedusers {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *TeamMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedtasks {
		edges = append(edges, team.EdgeTasks)
	}
	if m.clearedusers {
		edges = append(edges, team.EdgeUsers)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *TeamMutation) EdgeCleared(name string) bool {
	switch name {
	case team.EdgeTasks:
		return m.clearedtasks
	case team.EdgeUsers:
		return m.clearedusers
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *TeamMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Team unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *TeamMutation) ResetEdge(name string) error {
	switch name {
	case team.EdgeTasks:
		m.ResetTasks()
		return nil
	case team.EdgeUsers:
		m.ResetUsers()
		return nil
	}
	return fmt.Errorf("unknown Team edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op            Op
	typ           string
	id            *int
	name          *string
	age           *uint
	addage        *uint
	clearedFields map[string]struct{}
	teams         map[int]struct{}
	removedteams  map[int]struct{}
	clearedteams  bool
	tasks         map[int]struct{}
	removedtasks  map[int]struct{}
	clearedtasks  bool
	done          bool
	oldValue      func(context.Context) (*User, error)
	predicates    []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id int) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = fmt.Errorf("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, fmt.Errorf("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// ID returns the ID value in the mutation. Note that the ID
// is only available if it was provided to the builder.
func (m *UserMutation) ID() (id int, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// SetName sets the "name" field.
func (m *UserMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *UserMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *UserMutation) ResetName() {
	m.name = nil
}

// SetAge sets the "age" field.
func (m *UserMutation) SetAge(u uint) {
	m.age = &u
	m.addage = nil
}

// Age returns the value of the "age" field in the mutation.
func (m *UserMutation) Age() (r uint, exists bool) {
	v := m.age
	if v == nil {
		return
	}
	return *v, true
}

// OldAge returns the old "age" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldAge(ctx context.Context) (v uint, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, fmt.Errorf("OldAge is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, fmt.Errorf("OldAge requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldAge: %w", err)
	}
	return oldValue.Age, nil
}

// AddAge adds u to the "age" field.
func (m *UserMutation) AddAge(u uint) {
	if m.addage != nil {
		*m.addage += u
	} else {
		m.addage = &u
	}
}

// AddedAge returns the value that was added to the "age" field in this mutation.
func (m *UserMutation) AddedAge() (r uint, exists bool) {
	v := m.addage
	if v == nil {
		return
	}
	return *v, true
}

// ClearAge clears the value of the "age" field.
func (m *UserMutation) ClearAge() {
	m.age = nil
	m.addage = nil
	m.clearedFields[user.FieldAge] = struct{}{}
}

// AgeCleared returns if the "age" field was cleared in this mutation.
func (m *UserMutation) AgeCleared() bool {
	_, ok := m.clearedFields[user.FieldAge]
	return ok
}

// ResetAge resets all changes to the "age" field.
func (m *UserMutation) ResetAge() {
	m.age = nil
	m.addage = nil
	delete(m.clearedFields, user.FieldAge)
}

// AddTeamIDs adds the "teams" edge to the Team entity by ids.
func (m *UserMutation) AddTeamIDs(ids ...int) {
	if m.teams == nil {
		m.teams = make(map[int]struct{})
	}
	for i := range ids {
		m.teams[ids[i]] = struct{}{}
	}
}

// ClearTeams clears the "teams" edge to the Team entity.
func (m *UserMutation) ClearTeams() {
	m.clearedteams = true
}

// TeamsCleared reports if the "teams" edge to the Team entity was cleared.
func (m *UserMutation) TeamsCleared() bool {
	return m.clearedteams
}

// RemoveTeamIDs removes the "teams" edge to the Team entity by IDs.
func (m *UserMutation) RemoveTeamIDs(ids ...int) {
	if m.removedteams == nil {
		m.removedteams = make(map[int]struct{})
	}
	for i := range ids {
		m.removedteams[ids[i]] = struct{}{}
	}
}

// RemovedTeams returns the removed IDs of the "teams" edge to the Team entity.
func (m *UserMutation) RemovedTeamsIDs() (ids []int) {
	for id := range m.removedteams {
		ids = append(ids, id)
	}
	return
}

// TeamsIDs returns the "teams" edge IDs in the mutation.
func (m *UserMutation) TeamsIDs() (ids []int) {
	for id := range m.teams {
		ids = append(ids, id)
	}
	return
}

// ResetTeams resets all changes to the "teams" edge.
func (m *UserMutation) ResetTeams() {
	m.teams = nil
	m.clearedteams = false
	m.removedteams = nil
}

// AddTaskIDs adds the "tasks" edge to the Task entity by ids.
func (m *UserMutation) AddTaskIDs(ids ...int) {
	if m.tasks == nil {
		m.tasks = make(map[int]struct{})
	}
	for i := range ids {
		m.tasks[ids[i]] = struct{}{}
	}
}

// ClearTasks clears the "tasks" edge to the Task entity.
func (m *UserMutation) ClearTasks() {
	m.clearedtasks = true
}

// TasksCleared reports if the "tasks" edge to the Task entity was cleared.
func (m *UserMutation) TasksCleared() bool {
	return m.clearedtasks
}

// RemoveTaskIDs removes the "tasks" edge to the Task entity by IDs.
func (m *UserMutation) RemoveTaskIDs(ids ...int) {
	if m.removedtasks == nil {
		m.removedtasks = make(map[int]struct{})
	}
	for i := range ids {
		m.removedtasks[ids[i]] = struct{}{}
	}
}

// RemovedTasks returns the removed IDs of the "tasks" edge to the Task entity.
func (m *UserMutation) RemovedTasksIDs() (ids []int) {
	for id := range m.removedtasks {
		ids = append(ids, id)
	}
	return
}

// TasksIDs returns the "tasks" edge IDs in the mutation.
func (m *UserMutation) TasksIDs() (ids []int) {
	for id := range m.tasks {
		ids = append(ids, id)
	}
	return
}

// ResetTasks resets all changes to the "tasks" edge.
func (m *UserMutation) ResetTasks() {
	m.tasks = nil
	m.clearedtasks = false
	m.removedtasks = nil
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 2)
	if m.name != nil {
		fields = append(fields, user.FieldName)
	}
	if m.age != nil {
		fields = append(fields, user.FieldAge)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case user.FieldName:
		return m.Name()
	case user.FieldAge:
		return m.Age()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case user.FieldName:
		return m.OldName(ctx)
	case user.FieldAge:
		return m.OldAge(ctx)
	}
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case user.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case user.FieldAge:
		v, ok := value.(uint)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetAge(v)
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	var fields []string
	if m.addage != nil {
		fields = append(fields, user.FieldAge)
	}
	return fields
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	switch name {
	case user.FieldAge:
		return m.AddedAge()
	}
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	switch name {
	case user.FieldAge:
		v, ok := value.(uint)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.AddAge(v)
		return nil
	}
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(user.FieldAge) {
		fields = append(fields, user.FieldAge)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	switch name {
	case user.FieldAge:
		m.ClearAge()
		return nil
	}
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	switch name {
	case user.FieldName:
		m.ResetName()
		return nil
	case user.FieldAge:
		m.ResetAge()
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.teams != nil {
		edges = append(edges, user.EdgeTeams)
	}
	if m.tasks != nil {
		edges = append(edges, user.EdgeTasks)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeTeams:
		ids := make([]ent.Value, 0, len(m.teams))
		for id := range m.teams {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.tasks))
		for id := range m.tasks {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	if m.removedteams != nil {
		edges = append(edges, user.EdgeTeams)
	}
	if m.removedtasks != nil {
		edges = append(edges, user.EdgeTasks)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeTeams:
		ids := make([]ent.Value, 0, len(m.removedteams))
		for id := range m.removedteams {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeTasks:
		ids := make([]ent.Value, 0, len(m.removedtasks))
		for id := range m.removedtasks {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.clearedteams {
		edges = append(edges, user.EdgeTeams)
	}
	if m.clearedtasks {
		edges = append(edges, user.EdgeTasks)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case user.EdgeTeams:
		return m.clearedteams
	case user.EdgeTasks:
		return m.clearedtasks
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case user.EdgeTeams:
		m.ResetTeams()
		return nil
	case user.EdgeTasks:
		m.ResetTasks()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}
