// Code generated by entc, DO NOT EDIT.

package db

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/dexidp/dex/storage/ent/db/keys"
	"github.com/dexidp/dex/storage/ent/db/predicate"
)

// KeysDelete is the builder for deleting a Keys entity.
type KeysDelete struct {
	config
	hooks    []Hook
	mutation *KeysMutation
}

// Where adds a new predicate to the KeysDelete builder.
func (kd *KeysDelete) Where(ps ...predicate.Keys) *KeysDelete {
	kd.mutation.predicates = append(kd.mutation.predicates, ps...)
	return kd
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (kd *KeysDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(kd.hooks) == 0 {
		affected, err = kd.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*KeysMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			kd.mutation = mutation
			affected, err = kd.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(kd.hooks) - 1; i >= 0; i-- {
			mut = kd.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, kd.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (kd *KeysDelete) ExecX(ctx context.Context) int {
	n, err := kd.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (kd *KeysDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: keys.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: keys.FieldID,
			},
		},
	}
	if ps := kd.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return sqlgraph.DeleteNodes(ctx, kd.driver, _spec)
}

// KeysDeleteOne is the builder for deleting a single Keys entity.
type KeysDeleteOne struct {
	kd *KeysDelete
}

// Exec executes the deletion query.
func (kdo *KeysDeleteOne) Exec(ctx context.Context) error {
	n, err := kdo.kd.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{keys.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (kdo *KeysDeleteOne) ExecX(ctx context.Context) {
	kdo.kd.ExecX(ctx)
}
